% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fips_codes.R
\docType{data}
\name{acs5_geography}
\alias{acs5_geography}
\title{Dataset used to identify geography availability in the 5-year ACS Detailed Tables}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 12228 rows and 3 columns.
}
\usage{
data(acs5_geography)
}
\description{
Built-in dataset for use by \code{load_variables()} to identify the smallest
geography at which 5-year ACS data are available

\itemize{
  \item \code{table}: The ACS Table ID
  \item \code{geography}: The smallest geography at which a given table is available
  for a given year
  \item \code{year}: The endyear of the 5-year ACS dataset
}
}
\details{
Dataset used to identify geography availability in the 5-year ACS Detailed Tables

Built-in dataset that includes information on the smallest geography at which
5-year ACS Detailed Tables data are available, by table, since 2011. This dataset
is used internally by \code{load_variables()} to add a \code{geography} column
when variables are retrieved for a 5-year ACS Detailed Tables dataset.
}
\keyword{datasets}
