% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_shmax.R
\name{superimposed_shmax_PB}
\alias{superimposed_shmax_PB}
\title{SHmax direction resulting from multiple plate boundaries considering distance
to plate boundaries}
\usage{
superimposed_shmax_PB(
  x,
  pbs,
  model,
  rotation_weighting = TRUE,
  type_weights = c(divergent = 1, convergent = 3, transform_L = 2, transform_R = 2),
  idp = 1
)
}
\arguments{
\item{x}{grid. An object of \code{sf}, \code{sfc} or 2-column matrix}

\item{pbs}{plate boundaries. \code{sf} object}

\item{model}{\code{data.frame} containing the Euler pole parameters. See
\code{\link[=equivalent_rotation]{equivalent_rotation()}} for details.}

\item{rotation_weighting}{logical.}

\item{type_weights}{named vector.}

\item{idp}{numeric. Weighting power of inverse distance. The higher the
number, the less impact far-distant boundaries have. When set to \code{0}, no
weighting is applied.}
}
\value{
two-column matrix. \code{azi} is the resultant azimuth (in degrees), \code{R}
is the resultant length.
}
\description{
Calculates a \eqn{\sigma_{Hmax}}{SHmax} direction at given coordinates,
sourced by multiple plate boundaries. This first-order approximation is the
circular mean of the superimposed theoretical directions, weighted by the
rotation rates of the underlying PoRs, the inverse distance to the plate
boundaries, and the type of plate boundary.
}
\examples{
na_grid <- sf::st_make_grid(san_andreas, what = "centers", cellsize = 1)
na_plate <- subset(plates, plateA == "na" | plateB == "na")
cpm <- subset(cpm_models, cpm_models$model == "NNR-MORVEL56")

# make divergent to ridge-push:
na_plate <- transform(na_plate, type = ifelse(na_plate$pair == "eu-na", "convergent", type))

res <- superimposed_shmax_PB(na_grid, na_plate, model = cpm, idp = 2)
head(res)
}
\seealso{
\code{\link[=superimposed_shmax]{superimposed_shmax()}}
}
