% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_names.R
\name{match_names}
\alias{match_names}
\alias{match_names,character,character-method}
\alias{match_names,character,taxlist-method}
\title{Search matchings between character and taxlist objects}
\usage{
match_names(x, object, ...)

\S4method{match_names}{character,character}(x, object, best = 5, clean = TRUE, ...)

\S4method{match_names}{character,taxlist}(
  x,
  object,
  clean = TRUE,
  output = "data.frame",
  best = 5,
  show_concepts = FALSE,
  accepted_only = FALSE,
  method = "lcs",
  ...
)
}
\arguments{
\item{x}{A character vector with names to be compared.}

\item{object}{An object of class \linkS4class{taxlist} to be compared
with.}

\item{best}{Integer value indicating how many from the best matches have to
be displayed (only working for \code{output="list"}).}

\item{clean}{Logical value, whether leading, tailing and double blanks should
be deleted from \code{x}.}

\item{output}{Character value indicating the type of output (see details).}

\item{show_concepts}{Logical value, whether respective concepts should be
displayed in output or not.}

\item{accepted_only}{Logical value, whether only accepted names should be
matched or all.}

\item{method, ...}{Further arguments passed to \code{\link[=stringsim]{stringsim()}}.}
}
\description{
Names provided in a character vector will be compared with names stored in
slot \code{taxonNames} within an object of class \linkS4class{taxlist} by
using the function \code{\link[=stringsim]{stringsim()}}.
}
\details{
For \code{output="list"} a list with the best matches (taxon usage name ID and
similarity) for each queried name will be retrieved, where the number is set
by argument \code{best}.
Option \code{accepted_only=TRUE} will only work with\code{output="data.frame"}.
This will be applied especially in those cases were the requested names have
more than one match in the reference \linkS4class{taxlist} object
(matching homonyms) and will retrieve the one name, that has the status of
accepted name, otherwise no matchings will be retrieved.
}
\examples{
## Names to be compared
species <- c("Cperus papyrus", "Typha australis", "Luke skywalker")

## Retrieve taxon usage names
match_names(species, Easplist)

## Display accepted names in output
match_names(species, Easplist, show_concepts=TRUE)

}
\seealso{
\code{\link[=stringsim]{stringsim()}}
}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
