% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statquote.R
\name{statquote}
\alias{statquote}
\alias{print.statquote}
\alias{as.data.frame.statquote}
\title{Display a randomly chosen statistical quote.}
\usage{
statquote(ind = NULL, pattern = NULL, tag = NULL, source = NULL, topic = NULL)

\method{print}{statquote}(x, cite = TRUE, width = NULL, ...)

\method{as.data.frame}{statquote}(x, row.names = NULL, optional = FALSE, ...)
}
\arguments{
\item{ind}{Integer or character.
If 'ind' is missing, a random quote is chosen from all quotations.
If 'ind' is specified and is an integer, return the ind^th quote.
If 'ind' is specified and is character, use it as the 'pattern'.}

\item{pattern}{Character string. Quotes are subset to to those which
match the pattern in the quote text.}

\item{tag}{Character string. Quotes are subset to those matching the
specified tag.}

\item{source}{Character string. Quotes are subset to those matching
the specified source (person).}

\item{topic}{Deprecated. Use 'tag' instead. Only kept for backward compatability.}

\item{x}{object of class \code{'statquote'}}

\item{cite}{logical; should the \code{cite} field be printed?}

\item{width}{Optional print width parameter}

\item{...}{Other optional arguments, unused here}

\item{row.names}{see \code{\link{as.data.frame}}}

\item{optional}{see \code{\link{as.data.frame}}}
}
\value{
A character vector containing one quote.
It is of class \code{statquote} for which an S3 print method will be invoked, and for which
other methods are available.
}
\description{
Display a randomly chosen statistical quote.
}
\examples{
set.seed(1234)
statquote()
statquote(10)
statquote("boggled")
statquote(pattern="boggled")
statquote(source="Yates")
statquote(tag="anova")
print.data.frame(statquote(302)) # All information

}
\seealso{
\code{\link{quote_tags}}, \code{\link{search_quotes}}, \code{\link{quotes}},
Inspired by: \code{\link[fortunes]{fortune}}

\code{\link{as.latex}}, \code{\link{as.markdown}}
}
