% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample.by.poly.R
\name{constantDensitySampling}
\alias{constantDensitySampling}
\title{Sample Polygons at a Fixed Density}
\usage{
constantDensitySampling(
  x,
  polygon.id = "pID",
  n.pts.per.ac = 1,
  min.samples = 5,
  sampling.type = "regular"
)
}
\arguments{
\item{x}{either \code{SpatVector} or object that can be coerced into one, should contain polygons registered to a planar coordinate reference system}

\item{polygon.id}{character, name of column which contains a unique ID for each polygon}

\item{n.pts.per.ac}{numeric, sampling density in "points per acre"}

\item{min.samples}{integer, enforced minimum number of samples per polygon}

\item{sampling.type}{character, sampling type passed to \code{\link[terra:sample]{terra::spatSample()}}}
}
\value{
\code{SpatVector} of sample points
}
\description{
Perform constant-density sampling of polygons.
}
\author{
D.E. Beaudette
}
\keyword{manip}
