% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_plot.R
\name{plot.incremental}
\alias{plot.incremental}
\alias{IncrementalPlot}
\alias{PlotIncremental}
\title{Plot of incremental performance}
\usage{
\method{plot}{incremental}(
  x,
  quantiles = c(0.05, 0.95),
  col = c("red", "grey"),
  col.axis = NULL,
  xgrid = FALSE,
  ygrid = FALSE,
  output_data = FALSE,
  ...
)

IncrementalPlot(
  x,
  quantiles = c(0.05, 0.95),
  col = c("red", "grey"),
  col.axis = NULL,
  xgrid = FALSE,
  ygrid = FALSE,
  output_data = FALSE,
  ...
)

PlotIncremental(
  x,
  quantiles = c(0.05, 0.95),
  col = c("red", "grey"),
  col.axis = NULL,
  xgrid = FALSE,
  ygrid = FALSE,
  output_data = FALSE,
  ...
)
}
\arguments{
\item{x}{output of \code{\link{Incremental}}.}

\item{quantiles}{quantiles defining the lower and upper bounds.}

\item{col}{vector of colours by stable selection status.}

\item{col.axis}{optional vector of label colours by stable selection status.}

\item{xgrid}{logical indicating if a vertical grid should be drawn.}

\item{ygrid}{logical indicating if a horizontal grid should be drawn.}

\item{output_data}{logical indicating if the median and quantiles should be
returned in a matrix.}

\item{...}{additional plotting arguments (see \code{\link[graphics]{par}}).}
}
\value{
A plot.
}
\description{
Represents prediction performances upon sequential inclusion of the
predictors in a logistic or Cox regression model as produced by
\code{\link{Incremental}}. The median and \code{quantiles} of the performance
metric are reported. See examples in \code{\link{Incremental}}.
}
\seealso{
\code{\link{Incremental}}
}
