% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LL_function.R
\name{LL_model}
\alias{LL_model}
\title{Analysis: Logistic regression}
\usage{
LL_model(
  trat,
  resp,
  npar = "LL.3",
  error = "SE",
  ylab = "Germination (\%)",
  xlab = expression("Temperature ("^"o" * "C)"),
  theme = theme_classic(),
  legend.position = "top",
  cardinal = 0,
  r2 = "all",
  width.bar = NA,
  scale = "none"
)
}
\arguments{
\item{trat}{Numerical or complex vector with treatments}

\item{resp}{Numerical vector containing the response of the experiment.}

\item{npar}{Number of model parameters}

\item{error}{Error bar (It can be SE - \emph{default}, SD or FALSE)}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{xlab}{Treatments name (Accepts the \emph{expression}() function)}

\item{theme}{ggplot2 theme (\emph{default} is theme_bw())}

\item{legend.position}{Legend position (\emph{default} is c(0.3,0.8))}

\item{cardinal}{Defines the value of y considered extreme (\emph{default} considers 0 germination)}

\item{r2}{Coefficient of determination of the mean or all values (\emph{default} is all)}

\item{width.bar}{Bar width}

\item{scale}{Sets x scale (\emph{default} is none, can be "log")}
}
\value{
The function returns the coefficients and respective p-values; statistical parameters such as AIC, BIC, pseudo-R2, RMSE (root mean squared error); cardinal and optimal temperatures and the graph using ggplot2 with the equation.
}
\description{
Logistic models with three (LL.3) or four (LL.4) continuous data parameters. This model was extracted from the drc package and adapted for temperature analysis in seed germination.
}
\details{
The three-parameter log-logistic function with lower limit 0 is
\deqn{f(x) = 0 + \frac{d}{1+\exp(b(\log(x)-\log(e)))}}
The four-parameter log-logistic function is given by the expression
\deqn{f(x) = c + \frac{d-c}{1+\exp(b(\log(x)-\log(e)))}}
The function is symmetric about the inflection point (e).
}
\note{
if the maximum predicted value is equal to the maximum x, the curve does not have a maximum point within the studied range. If the minimum value is less than the lowest point studied, disregard the value.
}
\examples{
library(seedreg)
data("aristolochia")
attach(aristolochia)

#================================
# Germination
#================================
LL_model(trat,germ)

#================================
# Germination speed
#================================
LL_model(trat, vel, ylab=expression("v"~(dias^-1)))
}
\references{
Seber, G. A. F. and Wild, C. J (1989) Nonlinear Regression, New York: Wiley \& Sons (p. 330).

Ritz, C.; Strebig, J.C.; Ritz, M.C. Package ‘drc’. Creative Commons: Mountain View, CA, USA, 2016.
}
\author{
Model imported from the drc package (Ritz et al., 2016)

Gabriel Danilo Shimizu

Leandro Simoes Azeredo Goncalves
}
