% Generated by roxygen2 (4.0.2): do not edit by hand
\name{calculateQValue}
\alias{calculateQValue}
\title{Compute saps q-value}
\usage{
calculateQValue(dataSet, sampleSize, survivalTimes, followup, saps_score,
  random.samples, qvalue.samples, cpus, gsea.perm, rankedGenes)
}
\arguments{
\item{dataSet}{A matrix, where the column names are gene identifiers
and the values are gene expression levels. Each row should contain data for a
single patient.}

\item{sampleSize}{The desired size for the randomly sampled gene sets.}

\item{survivalTimes}{A vector of survival times. The length must equal
the number of rows in \code{dataSet}.}

\item{followup}{A vector of 0 or 1 values, indicating whether the patient was
lost to followup (0) or not (1). The length must equal the number of rows
(i.e. patients) in \code{dataSet}.}

\item{saps_score}{The saps score for the candidate geneset. The q-value is
calculated as the proportion of random saps scores whose absolute value
is >= to the provided saps score.}

\item{random.samples}{The number of random gene sets to sample during
the calculation of \code{P_random}.}

\item{qvalue.samples}{The number of random gene sets to sample for
purposes of computing the q-value.}

\item{cpus}{An integer that specifies the number of cpus/cores to be used when
calculating \code{P_enrichment}. If greater than 1, the
\pkg{snowfall} package must be installed or an error will occur.}

\item{gsea.perm}{The number of permutations to be used when calculating
\code{P_enrich}. This is passed to the \code{\link[piano]{runGSA}} function
in the \pkg{piano} package.}

\item{rankedGenes}{A vector of ranking scores for each gene in \code{dataSet}.
Ordinarily this will be the z-scores obtained by a call to
\code{\link{rankConcordance}}.}
}
\value{
The function returns a list with two elements:

\item{q_value}{the calculated q-value.}
\item{random_saps_scores}{a vector of individual saps scores for each
randomly generated geneset.}
}
\description{
This function computes the saps q-value for a candidate prognostic
geneset by computing the saps score for randomly generated genesets and
determining the proportion at least as significant as the saps score for
the candidate set. This function is normally called by \code{\link{saps}}.
}
\examples{
# 25 patients, none lost to followup
followup <- rep(1, 25)

# first 5 patients have good survival (in days)
time <- c(25, 27, 24, 21, 26, sample(1:3, 20, TRUE))*365

# create data for 100 genes, 25 patients
dat <- matrix(rnorm(25*100), nrow=25, ncol=100)
colnames(dat) <- as.character(1:100)

# borderline significant saps score
saps_score <- 1.3

\dontrun{
rankedGenes <- rankConcordance(dat, time, followup)[,"z"]

q_value <- calculateQValue(dat, 5, time, followup, saps_score, random.samples=100,
     qvalue.samples=10, cpus=1, gsea.perm=1000, rankedGenes)

q_value$q_value
random_scores <- abs(q_value$random_saps_scores)
hist(random_scores)
length(random_scores[random_scores > saps_score])
}
}
\references{
Beck AH, Knoblauch NW, Hefti MM, Kaplan J, Schnitt SJ, et al.
(2013) Significance Analysis of Prognostic Signatures. PLoS Comput Biol 9(1):
e1002875.doi:10.1371/journal.pcbi.1002875
}
\seealso{
\code{\link{saps}}
}

