% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessdb.R
\name{sm_expand_date}
\alias{sm_expand_date}
\title{Generate Temporal Identifiers from a Date Column}
\usage{
sm_expand_date(
  x,
  gen = c("year", "quarter", "month"),
  origin = "1899-12-30",
  keep.date = TRUE,
  remove.missing.date = TRUE,
  sort = TRUE,
  as.factor = TRUE,
  name = "date",
  ...
)
}
\arguments{
\item{x}{either a vector of class 'Date', or coercible to date using \code{\link[base]{as.Date}}, or a data frame / list containing with a date-column called \code{name}.}

\item{gen}{character. A vector of identifiers to generate from \code{x}. The possible identifiers are found in \code{\link{.SAMADB_T}}.}

\item{origin}{character / Date. Passed to \code{\link[base]{as.Date}}: for converting numeric \code{x} to date. The default reflects converting date-numbers from Excel for Windows.}

\item{keep.date}{logical. \code{TRUE} will keep the date variable in the resulting dataset, \code{FALSE} will remove the date variable in favor of the generated identifiers.}

\item{remove.missing.date}{logical. \code{TRUE} will remove missing values in \code{x}. If \code{x} is a dataset, rows missing the date variable will be removed.}

\item{sort}{logical. \code{TRUE} will sort the data by the date column.}

\item{as.factor}{\code{TRUE} will generate quarters and months as factor variables. It is also possible to use \code{as.factor = "ordered"} to generate ordered factors. \code{FALSE} will generate quarters and months as integer variables.}

\item{name}{character. The name of the date variable to expand.}

\item{\dots}{not used.}
}
\value{
A \code{\link[data.table]{data.table}} containing the computed identifiers as columns. See Examples.
}
\description{
This function expands a date column and generates additional temporal identifiers from it (year, month, quarter, day).
}
\examples{
# First a basic example
x <- seq.Date(as.Date("1999-01-01"), as.Date("2000-01-01"), by = "month")
sm_expand_date(x)
sm_expand_date(x, gen = .SAMADB_T[-1L], keep.date = FALSE)
\donttest{
# Now using the API
sm_expand_date(sm_data("BUSINESS_CYCLES"))

# Same thing
sm_data("BUSINESS_CYCLES", expand.date = TRUE)
}

}
\seealso{
\code{\link{sm_as_date}}, \code{\link{samadb}}
}
