% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colby_constructors.R
\name{split_cols_by_cuts}
\alias{split_cols_by_cuts}
\alias{split_rows_by_cuts}
\alias{split_cols_by_cutfun}
\alias{split_cols_by_quartiles}
\alias{split_rows_by_quartiles}
\alias{split_rows_by_cutfun}
\title{Split on static or dynamic cuts of the data}
\usage{
split_cols_by_cuts(
  lyt,
  var,
  cuts,
  cutlabels = NULL,
  split_label = var,
  nested = TRUE,
  cumulative = FALSE
)

split_rows_by_cuts(
  lyt,
  var,
  cuts,
  cutlabels = NULL,
  split_label = var,
  nested = TRUE,
  cumulative = FALSE,
  visible_label = FALSE
)

split_cols_by_cutfun(
  lyt,
  var,
  cutfun = qtile_cuts,
  cutlabelfun = function(x) NULL,
  split_label = var,
  format = NULL,
  nested = TRUE,
  extra_args = list(),
  cumulative = FALSE
)

split_cols_by_quartiles(
  lyt,
  var,
  split_label = var,
  format = NULL,
  nested = TRUE,
  extra_args = list(),
  cumulative = FALSE
)

split_rows_by_quartiles(
  lyt,
  var,
  split_label = var,
  format = NULL,
  nested = TRUE,
  child_labels = c("default", "visible", "hidden"),
  extra_args = list(),
  cumulative = FALSE,
  indent_mod = 0L,
  visible_label = FALSE
)

split_rows_by_cutfun(
  lyt,
  var,
  cutfun = qtile_cuts,
  cutlabelfun = function(x) NULL,
  split_label = var,
  format = NULL,
  nested = TRUE,
  child_labels = c("default", "visible", "hidden"),
  extra_args = list(),
  cumulative = FALSE,
  indent_mod = 0L,
  visible_label = FALSE
)
}
\arguments{
\item{lyt}{layout object pre-data used for tabulation}

\item{var}{string, variable name}

\item{cuts}{numeric. Cuts to use}

\item{cutlabels}{character (or NULL). Labels for the cutst}

\item{split_label}{string. Label string to be associated with the table generated by the split. Not to be confused with labels assigned to each child (which are based on the data and type of split during tabulation).}

\item{nested}{boolean, Add this as a new top-level split  (defining a new subtable directly under root). Defaults to \code{FALSE}}

\item{cumulative}{logical. Should the cuts be treated as cumulative. Defaults to \code{FALSE}}

\item{visible_label}{logical(1). Should the \emph{split} label be visible in the resulting table.}

\item{cutfun}{function. Function which accepts the full vector of \code{var} values and returns cut points to be passed to \code{cut}.}

\item{cutlabelfun}{function. Function which returns either labels for the cuts or NULL when passed the return value of \code{cutfun}}

\item{format}{FormatSpec. Format associated with this split. Formats can be declared via strings (\code{"xx.x"}) or function. In cases such as \code{analyze} calls, they can character vectors or lists of functions.}

\item{extra_args}{list. Extra arguments to be passed to the tabulation function. Element position in thte list corresponds to the children of this split. Named elements in the child-specific lists are ignored if they do not match a formal argument of the ttabulation function.}

\item{child_labels}{string. One of \code{"default"}, \code{"visible"}, \code{"hidden"}. What should the display behavior be for the  labels (ie label rows) of the children of this split. Defaults to \code{"default"} which flags the label row as visible only if the child has 0 content rows.}

\item{indent_mod}{numeric. Modifier for the default indent position for the structure created by this function(subtable, content table, or row) \emph{and all of that structure's children}. Defaults to 0, which corresponds to the unmodified default behavior.}
}
\value{
A \code{PreDataTableLayouts} object suitable for passing to further layouting functions, and to \code{build_table}.
}
\description{
Create columns (or row splits) based on values (such as quartiles) of \code{var}.
}
\details{
For dynamic cuts, the cut is transformed into a static cut by \code{\link{build_table}} \emph{based on the full
dataset}, before proceeding. Thus even when nested within another split in column/row space, the resulting split will
reflect the overall vaalues (e.g., quartiles) in the dataset, NOT the values for subset  it is nested under.
}
\examples{
library(dplyr)

# split_cols_by_cuts
l <- basic_table() \%>\%
    split_cols_by("ARM") \%>\%
    split_cols_by_cuts("AGE", split_label = "Age",
                       cuts = c(0, 25, 35, 1000),
                       cutlabels = c("young", "medium", "old")) \%>\%
    analyze(c("BMRKR2", "STRATA2")) \%>\%
    append_topleft("counts")

build_table(l, ex_adsl)


# split_rows_by_cuts
l <- basic_table() \%>\%
    split_cols_by("ARM") \%>\%
    split_rows_by_cuts("AGE", split_label = "Age",
                  cuts = c(0, 25, 35, 1000),
                  cutlabels = c("young", "medium", "old")) \%>\%
    analyze(c("BMRKR2", "STRATA2")) \%>\%
    append_topleft("counts")


build_table(l, ex_adsl)


# split_cols_by_quartiles

l <- basic_table() \%>\%
    split_cols_by("ARM") \%>\%
    split_cols_by_quartiles("AGE", split_label = "Age") \%>\%
    analyze(c("BMRKR2", "STRATA2")) \%>\%
    append_topleft("counts")

build_table(l, ex_adsl)

# split_rows_by_quartiles
l <- basic_table() \%>\%
    split_cols_by("ARM") \%>\%
    add_colcounts() \%>\%
    split_rows_by_quartiles("AGE", split_label = "Age") \%>\%
    analyze("BMRKR2") \%>\%
    append_topleft(c("Age Quartiles", " Counts BMRKR2"))

build_table(l, ex_adsl)


}
\author{
Gabriel Becker
}
