% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/occ_download_sql.R
\name{occ_download_sql}
\alias{occ_download_sql}
\alias{occ_download_sql_validate}
\alias{occ_download_sql_prep}
\title{Download occurrence data using a SQL query}
\usage{
occ_download_sql(
  q = NULL,
  format = "SQL_TSV_ZIP",
  user = NULL,
  pwd = NULL,
  email = NULL,
  validate = TRUE,
  curlopts = list(http_version = 2)
)

occ_download_sql_validate(q = NULL, user = NULL, pwd = NULL)

occ_download_sql_prep(
  q = NULL,
  format = "SQL_TSV_ZIP",
  user = NULL,
  pwd = NULL,
  email = NULL,
  validate = TRUE,
  curlopts = list(http_version = 2)
)
}
\arguments{
\item{q}{sql query}

\item{format}{only "SQL_TSV_ZIP" is supported right now}

\item{user}{your GBIF user name}

\item{pwd}{your GBIF password}

\item{email}{your email address}

\item{validate}{should the query be validated before submission. Default is
TRUE.}

\item{curlopts}{list of curl options}
}
\value{
an object of class 'occ_download_sql'
}
\description{
Download occurrence data using a SQL query
}
\details{
This is an experimental feature, and the implementation may change throughout
2024. The feature is currently only available for preview by invited users.
Contact \code{helpdesk@gbif.org} to request access.

Please see the article here for more information:
\url{https://docs.ropensci.org/rgbif/articles/gbif_sql_downloads.html}
}
\examples{
\dontrun{
occ_download_sql("SELECT gbifid,countryCode FROM occurrence 
                  WHERE genusKey = 2435098")
}

}
\references{
\url{https://techdocs.gbif.org/en/data-use/api-sql-downloads}
}
