/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.silent;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAdductFormula;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.interfaces.IMolecularFormulaSet;
import org.openscience.cdk.silent.SilentChemObjectBuilder;

@TestClass(value="org.openscience.cdk.silent.AdductFormulaTest")
public class AdductFormula
implements Iterable<IMolecularFormula>,
IAdductFormula,
Cloneable {
    private static final long serialVersionUID = -811384981700039389L;
    private List<IMolecularFormula> components = new ArrayList<IMolecularFormula>();

    public AdductFormula() {
    }

    public AdductFormula(IMolecularFormula formula) {
        this.components.add(0, formula);
    }

    @TestMethod(value="testAddMolecularFormula_IMolecularFormula")
    public void addMolecularFormula(IMolecularFormula formula) {
        this.components.add(formula);
    }

    @TestMethod(value="testAdd_IMolecularFormulaSet")
    public void add(IMolecularFormulaSet formulaSet) {
        for (IMolecularFormula mf : formulaSet.molecularFormulas()) {
            this.addMolecularFormula(mf);
        }
    }

    @TestMethod(value="testContains_IIsotope")
    public boolean contains(IIsotope isotope) {
        for (IIsotope thisIsotope : this.isotopes()) {
            if (!this.isTheSame(thisIsotope, isotope)) continue;
            return true;
        }
        return false;
    }

    @TestMethod(value="testGetCharge")
    public Integer getCharge() {
        Integer charge = 0;
        Iterator<IMolecularFormula> componentIterator = this.components.iterator();
        while (componentIterator.hasNext()) {
            charge = charge + componentIterator.next().getCharge();
        }
        return charge;
    }

    @TestMethod(value="testGetIsotopeCount_IIsotope")
    public int getIsotopeCount(IIsotope isotope) {
        int count = 0;
        Iterator<IMolecularFormula> componentIterator = this.components.iterator();
        while (componentIterator.hasNext()) {
            count += componentIterator.next().getIsotopeCount(isotope);
        }
        return count;
    }

    @TestMethod(value="testGetIsotopeCount")
    public int getIsotopeCount() {
        return this.isotopesList().size();
    }

    @TestMethod(value="testIsotopes")
    public Iterable<IIsotope> isotopes() {
        return new Iterable<IIsotope>(){

            @Override
            public Iterator<IIsotope> iterator() {
                return AdductFormula.this.isotopesList().iterator();
            }
        };
    }

    private List<IIsotope> isotopesList() {
        ArrayList<IIsotope> isotopes = new ArrayList<IIsotope>();
        Iterator<IMolecularFormula> componentIterator = this.components.iterator();
        while (componentIterator.hasNext()) {
            for (IIsotope isotope : componentIterator.next().isotopes()) {
                if (isotopes.contains(isotope)) continue;
                isotopes.add(isotope);
            }
        }
        return isotopes;
    }

    @TestMethod(value="testSetCharge")
    public void setCharge(Integer charge) {
        throw new IllegalAccessError();
    }

    @TestMethod(value="testMolecularFormulas")
    public Iterable<IMolecularFormula> molecularFormulas() {
        return this.components;
    }

    @Override
    @TestMethod(value="testIterator")
    public Iterator<IMolecularFormula> iterator() {
        return this.components.iterator();
    }

    @TestMethod(value="testSize")
    public int size() {
        return this.components.size();
    }

    @TestMethod(value="testContains_IMolecularFormula")
    public boolean contains(IMolecularFormula formula) {
        return this.components.contains(formula);
    }

    @TestMethod(value="testGetMolecularFormulas_int")
    public IMolecularFormula getMolecularFormula(int position) {
        return this.components.get(position);
    }

    @TestMethod(value="testRemoveAllMolecularFormulas")
    public void removeAllMolecularFormulas() {
        this.components.clear();
    }

    @TestMethod(value="testRemoveMolecularFormula_IMolecularFormula")
    public void removeMolecularFormula(IMolecularFormula formula) {
        this.components.remove(formula);
    }

    @TestMethod(value="testRemoveMolecularFormula_int")
    public void removeMolecularFormula(int position) {
        this.components.remove(position);
    }

    @TestMethod(value="testClone")
    public Object clone() throws CloneNotSupportedException {
        AdductFormula clone = new AdductFormula();
        for (IMolecularFormula form : this.molecularFormulas()) {
            clone.addMolecularFormula((IMolecularFormula)form.clone());
        }
        return clone;
    }

    private boolean isTheSame(IIsotope isotopeOne, IIsotope isotopeTwo) {
        if (isotopeOne.getSymbol() != isotopeTwo.getSymbol()) {
            return false;
        }
        if (isotopeOne.getNaturalAbundance() != isotopeTwo.getNaturalAbundance()) {
            return false;
        }
        return isotopeOne.getExactMass() == isotopeTwo.getExactMass();
    }

    public IChemObjectBuilder getBuilder() {
        return SilentChemObjectBuilder.getInstance();
    }
}

