/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.config.isotopes;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.config.isotopes.IsotopeHandler;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

@TestClass(value="org.openscience.cdk.config.isotopes.IsotopeReaderTest")
public class IsotopeReader {
    private XMLReader parser;
    private InputStream input;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(IsotopeReader.class);
    private IChemObjectBuilder builder;

    @TestMethod(value="testIsotopeReader_InputStream_IChemObjectBuilder")
    public IsotopeReader(InputStream input, IChemObjectBuilder builder) {
        this.init();
        this.input = input;
        this.builder = builder;
    }

    private void init() {
        boolean success = false;
        if (!success) {
            try {
                SAXParserFactory spf = SAXParserFactory.newInstance();
                spf.setNamespaceAware(true);
                SAXParser saxParser = spf.newSAXParser();
                this.parser = saxParser.getXMLReader();
                logger.info((Object)"Using JAXP/SAX XML parser.");
                success = true;
            }
            catch (Exception exception) {
                logger.warn((Object)"Could not instantiate JAXP/SAX XML reader!");
                logger.debug((Object)exception);
            }
        }
        if (!success) {
            try {
                this.parser = (XMLReader)this.getClass().getClassLoader().loadClass("gnu.xml.aelfred2.XmlReader").newInstance();
                logger.info((Object)"Using Aelfred2 XML parser.");
                success = true;
            }
            catch (Exception e) {
                logger.warn((Object)"Could not instantiate Aelfred2 XML reader!");
                logger.debug((Object)e);
            }
        }
        if (!success) {
            try {
                this.parser = (XMLReader)this.getClass().getClassLoader().loadClass("org.apache.xerces.parsers.SAXParser").newInstance();
                logger.info((Object)"Using Xerces XML parser.");
                success = true;
            }
            catch (Exception e) {
                logger.warn((Object)"Could not instantiate Xerces XML reader!");
                logger.debug((Object)e);
            }
        }
        if (!success) {
            logger.error((Object)"Could not instantiate any XML parser!");
        }
    }

    @TestMethod(value="testReadIsotopes,testReadIsotopes2")
    public List<IIsotope> readIsotopes() {
        ArrayList<IIsotope> isotopes = new ArrayList();
        try {
            this.parser.setFeature("http://xml.org/sax/features/validation", false);
            logger.info((Object)"Deactivated validation");
        }
        catch (SAXException exception) {
            logger.warn((Object)"Cannot deactivate validation: ", new Object[]{exception.getMessage()});
            logger.debug((Object)exception);
        }
        IsotopeHandler handler = new IsotopeHandler(this.builder);
        this.parser.setContentHandler(handler);
        try {
            this.parser.parse(new InputSource(this.input));
            isotopes = handler.getIsotopes();
        }
        catch (IOException exception) {
            logger.error((Object)"IOException: ", new Object[]{exception.getMessage()});
            logger.debug((Object)exception);
        }
        catch (SAXException saxe) {
            logger.error((Object)"SAXException: ", new Object[]{saxe.getClass().getName()});
            logger.error((Object)saxe.getMessage());
            logger.debug((Object)saxe);
        }
        return isotopes;
    }
}

