/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller;

import java.util.Map;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import org.openscience.cdk.controller.ControllerModuleAdapter;
import org.openscience.cdk.controller.IChemModelRelay;
import org.openscience.cdk.controller.edit.AbstractEdit;
import org.openscience.cdk.controller.edit.AddAtom;
import org.openscience.cdk.controller.edit.AddBond;
import org.openscience.cdk.controller.edit.AppendAtom;
import org.openscience.cdk.controller.edit.CreateBond;
import org.openscience.cdk.controller.edit.IEdit;
import org.openscience.cdk.controller.edit.SetBondOrder;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.renderer.selection.SingleSelection;

public class AddBondDragModule
extends ControllerModuleAdapter {
    Point2d start;
    Point2d dest;
    IAtom source = null;
    IAtom merge = null;
    boolean newSource = false;
    boolean isBond = false;
    private double bondLenght;

    public AddBondDragModule(IChemModelRelay chemModelRelay) {
        super(chemModelRelay);
    }

    private IChemObjectBuilder getBuilder() {
        IAtomContainer ac = this.getModel();
        if (ac != null) {
            return ac.getBuilder();
        }
        throw new IllegalStateException("Could not get IAtomContainer model");
    }

    @Override
    public void mouseClickedDown(Point2d worldCoord) {
        IBond closestBond;
        IAtom closestAtom;
        IChemObject singleSelection;
        this.start = null;
        this.dest = null;
        this.source = null;
        this.merge = null;
        this.isBond = false;
        this.newSource = false;
        this.bondLenght = this.calculateAverageBondLength(this.getModel());
        if (this.bondLenght == 0.0 || Double.isNaN(this.bondLenght)) {
            this.bondLenght = 1.5;
        }
        if ((singleSelection = this.getHighlighted(worldCoord, new IChemObject[]{closestAtom = this.chemModelRelay.getClosestAtom(worldCoord), closestBond = this.chemModelRelay.getClosestBond(worldCoord)})) == null) {
            this.source = (IAtom)this.getBuilder().newInstance(IAtom.class, new Object[]{"C", new Point2d(worldCoord)});
            this.newSource = true;
        } else if (singleSelection instanceof IAtom) {
            this.source = (IAtom)singleSelection;
        } else if (singleSelection instanceof IBond) {
            this.isBond = true;
            this.chemModelRelay.execute(SetBondOrder.cycleBondValence((IBond)singleSelection));
            this.setSelection(new SingleSelection<IChemObject>(singleSelection));
        }
        this.start = new Point2d(this.source.getPoint2d());
    }

    private double calculateAverageBondLength(IAtomContainer ac) {
        int bondCount = 0;
        double bondLengthSum = 0.0;
        for (IBond bond : ac.bonds()) {
            IAtom atom1 = bond.getAtom(0);
            IAtom atom2 = bond.getAtom(1);
            if (atom1.getPoint2d() == null || atom2.getPoint2d() == null) continue;
            ++bondCount;
            bondLengthSum += GeometryTools.getLength2D((IBond)bond);
        }
        if (bondCount == 0) {
            return 1.4;
        }
        return bondLengthSum / (double)bondCount;
    }

    @Override
    public void mouseDrag(Point2d worldCoordFrom, Point2d worldCoordTo) {
        if (this.isBond) {
            return;
        }
        IAtom closestAtom = this.chemModelRelay.getClosestAtom(worldCoordTo);
        this.merge = (IAtom)this.getHighlighted(worldCoordTo, new IChemObject[]{closestAtom});
        Map<IAtom, IAtom> mergeM = this.chemModelRelay.getRenderModel().getMerge();
        mergeM.clear();
        this.chemModelRelay.clearPhantoms();
        if (this.start.distance(worldCoordTo) < this.getHighlightDistance()) {
            this.merge = null;
            this.dest = null;
        } else if (this.merge != null) {
            this.chemModelRelay.addPhantomBond((IBond)this.getBuilder().newInstance(IBond.class, new Object[]{this.source, this.merge}));
            this.dest = null;
        } else {
            this.dest = this.roundAngle(this.start, worldCoordTo);
            IAtom atom = (IAtom)this.getBuilder().newInstance(IAtom.class, new Object[]{"C", this.dest});
            IBond bond = (IBond)this.getBuilder().newInstance(IBond.class, new Object[]{this.source, atom});
            this.chemModelRelay.addPhantomBond(bond);
        }
        this.chemModelRelay.updateView();
    }

    private Point2d roundAngle(Point2d s, Point2d d) {
        Vector2d v = new Vector2d();
        v.sub(d, s);
        double rad = Math.atan2(v.y, v.x);
        double deg = Math.toDegrees(rad);
        deg = Math.round(deg / 15.0) * 15L;
        rad = Math.toRadians(deg);
        v.x = this.bondLenght * Math.cos(rad);
        v.y = this.bondLenght * Math.sin(rad);
        Point2d result = new Point2d();
        result.add(s, v);
        return result;
    }

    @Override
    public void mouseClickedUp(Point2d worldCoord) {
        this.chemModelRelay.clearPhantoms();
        this.chemModelRelay.getRenderModel().getMerge().clear();
        if (this.isBond) {
            return;
        }
        AbstractEdit edit = this.start.distance(worldCoord) < this.getHighlightDistance() ? (this.newSource ? AddAtom.createAtom("C", this.start) : AppendAtom.appendAtom("C", this.source)) : (this.merge != null ? (this.newSource ? AppendAtom.appendAtom("C", this.merge, this.start) : AddBond.addBond(this.source, this.merge)) : (this.newSource ? CreateBond.edit(this.start, this.dest) : AppendAtom.appendAtom("C", this.source, this.dest)));
        this.chemModelRelay.execute(edit);
    }

    @Override
    public String getDrawModeString() {
        return "Draw Bond";
    }

    class State {
        IEdit edit;

        State() {
        }
    }
}

