% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_queuefunctions.R
\name{lag_step}
\alias{lag_step}
\title{Add lag to vector of arrival times.}
\usage{
lag_step(arrivals, service)
}
\arguments{
\item{arrivals}{Either a numeric vector or an object of class \code{queue_list}. It represents the arrival times.}

\item{service}{A vector of service times with the same ordering as arrivals}
}
\value{
A vector of response times for the input of arrival times and service times.
}
\description{
Add lag to vector of arrival times.
}
\examples{
# Create arrival times
arrivals <- rlnorm(100, meanlog = 3)

# Create service times
service <- rlnorm(100)
lag_step(arrivals = arrivals, service = service)

# lag_step is equivalent to queue_step with a large number of queues, but it's faster to compute.

cbind(queue(arrivals, service = service, servers = 100),
lag_step(arrivals = arrivals, service = service))
}
\seealso{
\code{\link{wait_step}}, \code{\link{queue_step}}.
}

