% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_methods.R
\name{summary.qad}
\alias{summary.qad}
\alias{coef.qad}
\title{Summarize a qad object}
\usage{
\method{summary}{qad}(object, ...)

\method{coef}{qad}(
  object,
  select = c("q(x1,x2)", "q(x2,x1)", "max.dependence", "asymmetry", "p.q(x1,x2)",
    "p.q(x2,x1)", "p.max.dependence", "p.asymmetry"),
  ...
)
}
\arguments{
\item{object}{an object of class 'qad'}

\item{...}{some methods for this generic require additional arguments. None are used in this method.}

\item{select}{a vector of strings indicating which dependence measure should be returned. Options are c('q(x1,x2)', 'q(x2,x1)', 'max.dependence', 'asymmetry')}
}
\value{
an object containing the calculated values of a \code{qad} object.
}
\description{
Summary and coefficients of a \code{qad} output. The function
\code{summary()} prints the dependence measures, sample size and resolution of
the checkerboard copula and returns a list with the mentioned values.
The function \code{coef()} returns a named vector with the selected values.
}
\examples{
n <- 100
x <- runif(n, 0, 1)
y <- x^2 + rnorm(n, 0, 0.1)
sample <- data.frame(x, y)
##(Not Run)
fit <- qad(sample)
summary(fit)
coef(fit)
coef(fit, select = c('q(x1,x2)','p.q(x1,x2)'))

}
