% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bw_single.R
\name{bw_single}
\alias{bw_single}
\title{Predictor selection function for backward selection of
Logistic regression models.}
\usage{
bw_single(
  data,
  formula = NULL,
  Outcome = NULL,
  predictors = NULL,
  p.crit = 1,
  cat.predictors = NULL,
  spline.predictors = NULL,
  int.predictors = NULL,
  keep.predictors = NULL,
  nknots = NULL,
  anova_test = "Chisq"
)
}
\arguments{
\item{data}{A data frame.}

\item{formula}{A formula object to specify the model as normally used by glm.
See under "Details" and "Examples" how these can be specified.}

\item{Outcome}{Character vector containing the name of the outcome variable.}

\item{predictors}{Character vector with the names of the predictor variables.
At least one predictor variable has to be defined. Give predictors unique names
and do not use predictor name combinations with numbers as, age2, gnder10, etc.}

\item{p.crit}{A numerical scalar. P-value selection criterium. A value of 1
provides the pooled model without selection.}

\item{cat.predictors}{A single string or a vector of strings to define the
categorical variables. Default is NULL categorical predictors.}

\item{spline.predictors}{A single string or a vector of strings to define the
(restricted cubic) spline variables. Default is NULL spline predictors. See details.}

\item{int.predictors}{A single string or a vector of strings with the names of the variables that form
an interaction pair, separated by a “:” symbol.}

\item{keep.predictors}{A single string or a vector of strings including the variables that are forced
in the model during predictor selection. All type of variables are allowed.}

\item{nknots}{A numerical vector that defines the number of knots for each spline predictor separately.}

\item{anova_test}{a character string, matching one of "Chisq" or "LRT".}
}
\value{
An object of class \code{smods} (single models) from
 which the following objects can be extracted: original dataset as \code{data}, final selected
 model as \code{RR_model_final}, model at each selection step \code{RR_model_setp},
 p-values at final step according to selection method as \code{multiparm_final}, and
 at each step as \code{multiparm_step}, formula object at final step as \code{formula_final}, 
 and at each step as \code{formula_step} and for start model as \code{formula_initial}, 
 predictors included at each selection step as \code{predictors_in}, predictors excluded
 at each step as \code{predictors_out}, and \code{Outcome}, \code{anova_test}, \code{p.crit}, \code{call},
 \code{model_type}, \code{predictors_final} for names of predictors in final selection step and 
 \code{predictors_initial} for names of predictors in start model.
}
\description{
\code{bw_single} Backward selection of Logistic regression
prediction models using selection methods LRT or Chisq.
}
\details{
A typical formula object has the form \code{Outcome ~ terms}. Categorical variables has to
 be defined as \code{Outcome ~ factor(variable)}, restricted cubic spline variables as
 \code{Outcome ~ rcs(variable, 3)}. Interaction terms can be defined as
 \code{Outcome ~ variable1*variable2} or \code{Outcome ~ variable1 + variable2 + variable1:variable2}.
 All variables in the terms part have to be separated by a "+".
}
\examples{
 res_single <- bw_single(data=lbpmilr, p.crit = 0.05, Outcome="Chronic",
         predictors=c("Tampascale", "Smoking"),
         cat.predictors = c("Satisfaction"), anova_test = "Chisq")
         
res_single$RR_model_final

}
\references{
http://missingdatasolutions.rbind.io/
}
\seealso{
\code{\link{psfmi_perform}}
}
\author{
Martijn Heymans, 2020
}
