% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictions.R
\name{predictCS}
\alias{predictCS}
\title{Internal function to prepare data for prediction}
\usage{
predictCS(object, newdata, groups)
}
\arguments{
\item{object}{An object of S4 class \dQuote{MahalanobisScores},
\dQuote{SumScores}, or \dQuote{FactorScores} containing
a model and results to be used to get predictions on new data.}

\item{newdata}{A data frame with identical variable names as was used
to build the initial model.}

\item{groups}{A vector with the same length as the data frame in \code{newdata},
has rows, containing the groups each row belongs to.  See \code{CompositeData}
for more details.}
}
\value{
An object of S4 class \dQuote{CompositeReady}
}
\description{
Internal function to prepare data for prediction
}
\examples{
d <- CompositeData(mtcars[, c("mpg", "hp", "wt", "disp")],
                   thresholds = list(one = with(mtcars, c(
                                     mpg = max(mpg),
                                     hp = max(hp),
                                     wt = min(wt),
                                     disp = min(disp)))),
                   higherisbetter = c(TRUE, TRUE, FALSE, FALSE))
## create the distance scores
## and prepare to create the composite
dres <- prepareComposite(d)

## create composite based on summing the (standardized)
scomp <- sumComposite(dres, "square", "sum")
## use model to generate predictions on new data
predictCS(scomp,
          newdata = mtcars[1, c("mpg", "hp", "wt", "qsec")],
          groups = "one")

## create composite based on mahalanobis distances
mcomp <- mahalanobisComposite(dres)
## use model to generate predictions on new data
predictCS(mcomp,
          newdata = mtcars[1, c("mpg", "hp", "wt", "qsec")],
          groups = "one")
## note in this too simple example, there are negative variance estimates
## create composite based on factor scores
fcomp <- factorComposite(dres, type = "onefactor")
## use model to generate predictions on new data
predictCS(fcomp,
          newdata = mtcars[1:5, c("mpg", "hp", "wt", "disp")],
          groups = rep("one", 5))
}
