% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ridge.cv.R
\name{ridge.cv}
\alias{ridge.cv}
\title{Ridge Regression.}
\usage{
ridge.cv(
  X,
  y,
  lambda = NULL,
  scale = TRUE,
  k = 10,
  plot.it = FALSE,
  groups = NULL,
  method.cor = "pearson",
  compute.jackknife = TRUE
)
}
\arguments{
\item{X}{matrix of input observations. The rows of \code{X} contain the
samples, the columns of \code{X} contain the observed variables}

\item{y}{vector of responses. The length of y must equal the number of rows
of X}

\item{lambda}{Vector of penalty terms.}

\item{scale}{Scale the columns of X? Default is scale=TRUE.}

\item{k}{Number of splits in \code{k}-fold cross-validation. Default value
is \code{k}=10.}

\item{plot.it}{Plot the cross-validation error as a function of
\code{lambda}? Default is FALSE.}

\item{groups}{an optional vector with the same length as \code{y}. It
encodes a partitioning of the data into distinct subgroups. If \code{groups}
is provided, \code{k=10} is ignored and instead, cross-validation is
performed based on the partioning. Default is \code{NULL}.}

\item{method.cor}{How should the correlation to the response be computed?
Default is ''pearson''.}

\item{compute.jackknife}{Logical. If \code{TRUE}, the regression
coefficients on each of the cross-validation splits is stored. Default is
\code{TRUE}.}
}
\value{
\item{cv.error.matrix}{matrix of cross-validated errors based on
mean squared error. A row corresponds to one cross-validation split.}
\item{cv.error}{vector of cross-validated errors based on mean squared
error} \item{lambda.opt}{optimal value of \code{lambda}, based on mean
squared error} \item{intercept}{intercept of the optimal model, based on
mean squared error} \item{coefficients}{vector of regression coefficients of
the optimal model, based on mean squared error}
\item{cor.error.matrix}{matrix of cross-validated errors based on
correlation. A row corresponds to one cross-validation split.}
\item{cor.error}{vector of cross-validated errors based on correlation}
\item{lambda.opt.cor}{optimal value of \code{lambda}, based on correlation}
\item{intercept.cor}{intercept of the optimal model, based on correlation}
\item{coefficients.cor}{vector of regression coefficients of the optimal
model, based on mean squared error} \item{coefficients.jackknife}{Array of
the regression coefficients on each of the cross-validation splits. The
dimension is \code{ncol(X) x length(lambda) x k}.}
}
\description{
This function computes the optimal ridge regression model based on
cross-validation.
}
\details{
Based on the regression coefficients \code{coefficients.jackknife} computed
on the cross-validation splits, we can estimate their mean and their
variance using the jackknife. We remark that under a fixed design and the
assumption of normally distributed \code{y}-values, we can also derive the
true distribution of the regression coefficients.
}
\examples{

n<-100 # number of observations
p<-60 # number of variables
X<-matrix(rnorm(n*p),ncol=p) 
y<-rnorm(n)
ridge.object<-ridge.cv(X,y)

}
\seealso{
\code{\link{pls.cv}}, \code{\link{pcr.cv}},
\code{\link{benchmark.regression}}
}
\author{
Nicole Kraemer
}
\keyword{multivariate}
