% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.tag.r
\name{untag}
\alias{untag}
\alias{untag.default}
\alias{untag.generic_mspct}
\alias{untag.generic_spct}
\title{Remove tags}
\usage{
untag(x, ...)

\method{untag}{default}(x, ...)

\method{untag}{generic_spct}(x, byref = FALSE, ...)

\method{untag}{generic_mspct}(x, byref = FALSE, ...)
}
\arguments{
\item{x}{an R object}

\item{...}{not used in current version}

\item{byref}{logical indicating if new object will be created by reference or
by copy of x}
}
\value{
if \code{x} contains tag data they are removed and the "spct.tags"
  atrribute is set to \code{NA}, while if \code{x} has no tags, it is not
  modified. In either case, the byref argument is respected: in all cases if
  \code{byref=FALSE} a copy of \code{x} is returned.
}
\description{
Remove tags from an R object if present, otherwise return the object
unchanged.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default for generic function

\item \code{generic_spct}: Specialization for generic_spct

\item \code{generic_mspct}: Specialization for generic_spct
}}
\seealso{
Other tagging and related functions: \code{\link{is_tagged}},
  \code{\link{tag}}, \code{\link{wb2rect_spct}},
  \code{\link{wb2spct}}, \code{\link{wb2tagged_spct}}
}

