% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.fshift.r
\name{fshift}
\alias{fshift}
\alias{fshift.cps_mspct}
\alias{fshift.cps_spct}
\alias{fshift.filter_mspct}
\alias{fshift.filter_spct}
\alias{fshift.generic_mspct}
\alias{fshift.generic_spct}
\alias{fshift.raw_mspct}
\alias{fshift.raw_spct}
\alias{fshift.reflector_mspct}
\alias{fshift.reflector_spct}
\alias{fshift.response_mspct}
\alias{fshift.response_spct}
\alias{fshift.source_mspct}
\alias{fshift.source_spct}
\title{Shift the scale of a spectrum using a summary function}
\usage{
fshift(x, ...)

\method{fshift}{source_spct}(x, range = c(min(x), min(x) + 10), f = "mean",
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  ...)

\method{fshift}{response_spct}(x, range = c(min(x), min(x) + 10),
  f = "mean", unit.out = getOption("photobiology.radiation.unit", default =
  "energy"), ...)

\method{fshift}{filter_spct}(x, range = c(min(x), min(x) + 10), f = "min",
  qty.out = getOption("photobiology.filter.qty", default = "transmittance"),
  ...)

\method{fshift}{reflector_spct}(x, range = c(min(x), min(x) + 10),
  f = "min", qty.out = NULL, ...)

\method{fshift}{source_mspct}(x, range = c(min(x), min(x) + 10), f = "mean",
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  ...)

\method{fshift}{raw_spct}(x, range = c(min(x), min(x) + 10), f = "mean",
  qty.out = NULL, ...)

\method{fshift}{cps_spct}(x, range = c(min(x), min(x) + 10), f = "mean",
  qty.out = NULL, ...)

\method{fshift}{generic_spct}(x, range = c(min(x), min(x) + 10), f = "mean",
  col.names, ...)

\method{fshift}{response_mspct}(x, range = c(min(x), min(x) + 10),
  f = "mean", unit.out = getOption("photobiology.radiation.unit", default =
  "energy"), ...)

\method{fshift}{filter_mspct}(x, range = c(min(x), min(x) + 10), f = "min",
  qty.out = getOption("photobiology.filter.qty", default = "transmittance"),
  ...)

\method{fshift}{reflector_mspct}(x, range = c(min(x), min(x) + 10),
  f = "min", qty.out = NULL, ...)

\method{fshift}{raw_mspct}(x, range = c(min(x), min(x) + 10), f = "min",
  ...)

\method{fshift}{cps_mspct}(x, range = c(min(x), min(x) + 10), f = "min",
  ...)

\method{fshift}{generic_mspct}(x, range = c(min(x), min(x) + 10), f = "min",
  col.names, ...)
}
\arguments{
\item{x}{An R object}

\item{...}{additonal named arguments passed down to \code{f}.}

\item{range}{An R object on which \code{range()} returns a numeric vector of
length 2 with the limits of a range of wavelengths in nm, with min annd max
wavelengths (nm)}

\item{f}{character string "mean", "min" or "max" for scaling so that this
summary value becomes the origin of the spectral data scale in the returned
object, or the name of a function taking \code{x} as first argument and
returning a numeric value.}

\item{unit.out}{character Allowed values "energy", and "photon", or its alias
"quantum"}

\item{qty.out}{character Allowed values "transmittance", and "absorbance"}

\item{col.names}{character vector containing the names of columns or
variables to which to apply the scale shift.}
}
\description{
These functions return a spectral object of the same class as the one
supplied as argument but with the spectral data on a shift scale.
}
\section{Methods (by class)}{
\itemize{
\item \code{source_spct}: 

\item \code{response_spct}: 

\item \code{filter_spct}: 

\item \code{reflector_spct}: 

\item \code{source_mspct}: 

\item \code{raw_spct}: 

\item \code{cps_spct}: 

\item \code{generic_spct}: 

\item \code{response_mspct}: 

\item \code{filter_mspct}: 

\item \code{reflector_mspct}: 

\item \code{raw_mspct}: 

\item \code{cps_mspct}: 

\item \code{generic_mspct}: 
}}
\seealso{
Other rescaling functions: \code{\link{fscale}},
  \code{\link{getNormalized}}, \code{\link{is_normalized}},
  \code{\link{is_scaled}}, \code{\link{normalize}},
  \code{\link{setNormalized}}, \code{\link{setScaled}}
}

