#' @title CIE D65 illuminant data
#'
#' @description A dataset containing wavelengths at a 5 nm interval (300 nm to
#'   830 nm) and the corresponding spectral energy irradiance normalized to 1 at
#'   560 nm. Spectrum approximates the midday solar spectrum at middle latitude
#'   as 'corresponds' to the white point of a black body a 6504 K. Original data
#'   from \url{http://files.cie.co.at/204.xls} downloaded on 2014-07-25 The
#'   variables are as follows:
#'
#' @details \itemize{ \item w.length (nm) \item s.e.irrad (rel. units) }
#'
#' @author CIE
#'
#' @docType data
#' @keywords datasets
#' @format A source spectrum with 107 rows and 2 variables
#' @name D65.illuminant.spct
NULL

#' @title CIE A illuminant data
#'
#' @description A dataset containing wavelengths at a 5 nm interval (300 nm to
#'   830 nm) and the corresponding spectral energy irradiance normalized to 1 at
#'   560 nm. Spectrum approximates typical, domestic, tungsten-filament lighting
#'   and 'corresponds' to a black body a 2856 K. CIE standard illuminant A is
#'   intended to represent typical, domestic, tungsten-filament lighting.
#'   Original data from \url{http://files.cie.co.at/204.xls} downloaded on
#'   2014-07-25 The variables are as follows:
#'
#' @details \itemize{ \item w.length (nm) \item s.e.irrad (rel. units) }
#'
#' @author CIE
#'
#' @docType data
#' @keywords datasets
#' @format A source spectrum with 96 rows and 2 variables
#' @name A.illuminant.spct
NULL
