% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bestDocs.R
\name{bestDocs}
\alias{bestDocs}
\title{Find Informative Documents in a Corpus}
\usage{
bestDocs(co, num = 3L, n = 10L, pd = NULL)
}
\arguments{
\item{co}{A corpus with documents}

\item{num}{Integer with the number of documents to return}

\item{n}{Integer with the number of high frequency phrases to use}

\item{pd}{phraseDoc object for the corpus in \code{co}; if NULL, a
phraseDoc will be created for it.}
}
\value{
A corpus with the \code{num} documents that have the most
high frequency phrases, in order of the number of high frequency
phrases. The corpus returned will have the meta field oldIdx set
to the index of the document in the original corpus, and the meta
field hfPhrases to the number of high frequency phrases it contains.
}
\description{
Find the documents in a corpus that have the most high frequency
phrases and return a corpus with just those documents
}
\examples{
v1=c("Here is some text to test phrase mining","phrase mining is fun",
  "Some text is better than no text","No text, no phrase mining")
co=tm::VCorpus(tm::VectorSource(v1))
pd=phraseDoc(co,min.freq=2)
bestDocs(co,2,2,pd)
}
