% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eff_summary.R
\name{eff_summary}
\alias{eff_summary}
\title{Compute the summary statistics of efficacy measure with specified
parameters.}
\usage{
eff_summary(eff.structure, eff.Sigma, eff.sd_trans, n.sim = 3e+05,
  seed = 123, plot.flag = F, plot.title = T)
}
\arguments{
\item{eff.structure}{A matrix providing the mean of the multivariate
Gaussian distribution in efficacy data generation. Specifically, the
\eqn{(i, j)}th element represents the mean value of \eqn{i}th dose and
\eqn{j}th cycle of the Gaussian distribution for efficacy data
generation.}

\item{eff.Sigma}{The covariance matrix of the multivariate Guassian
distribution in efficacy data generation.}

\item{eff.sd_trans}{A positive number controling the skewness of the
distribution of the efficacy response.}

\item{n.sim}{Number of simulations for calculation summary statistics.
Default is 300,000}

\item{seed}{The seed of R's random number generator. Default is 123}

\item{plot.flag}{Whether output the marginal density, and correlation
matrix or not. Default is FALSE.}

\item{plot.title}{Whether display the title of the plot or not. Default is
TRUE}
}
\value{
\item{eff.M}{A matrix recording the efficacy mean whose \eqn{(i,
j)}th element represents the efficacy mean of \eqn{i}th dose level and
\eqn{j}th cycle }

\item{eff.cor.ls}{A list with a length of dose levels numbers recording the
marginal correlation matrix across cycles of efficacy data for each dose
level}
}
\description{
Numerically compute the Mean, mariginal standard deviance and mariginal
correlation matrix of efficacy measure generated with specified parameters.
The function provides plots of marginal density of generated efficacy and
correlation matrix for each dose. Check details to see the efficacy data
generation procedures.
}
\details{
The user can simulate longitudinal efficacy response with
  different dose-efficacy and cycle-efficacy pattern using argument
  \code{eff.structure}, \code{eff.Sigma} and \code{eff.sd_trans}. The
  sampling process of efficacy response starts from generating \eqn{z =
  {z1, \ldots, zd} } from multivariate Gaussian distribution \deqn{z ~
  MVN(\mu, V)}, where \eqn{\mu} and \eqn{V} are specified by
  \code{eff.structure} and \code{eff.Sigma}, respectively. Define
  \eqn{\phi} be the density of \eqn{N(0, \sigma^2)} with CDF \eqn{\Phi},
  where \eqn{\sigma^2} is set by \code{eff.sd_trans}. Then the efficacy
  measure is generated by taking the CDF of \eqn{z}: \deqn{x={x1, \ldots,
  xd} = \Phi(z) = { \Phi(z1), \ldots, \Phi(zd)}}. Notice here the variance
  parameter \eqn{\sigma^2_{trans}} controls the variance of the generated
  efficacy.
}
\examples{
data("eff")       # load eff.RData from package phase1PRMD. Details see "?eff"
eff.structure = eff$Dose_Cycle_Meff["plat", "dec", , ]
eff.Sigma = eff$Sigma
eff.sd_trans = eff$sd_trans

# res <- eff_summary(eff.structure, eff.Sigma, eff.sd_trans, n.sim = 300000,
#                    seed = 123)
# res
# set a special cases and check the density and correlation plots
# eff_summary(eff.structure = matrix(eff.structure[cbind(c(1:6), c(1:6))],
#                                   nrow = 1, ncol = 6),
#             eff.Sigma, eff.sd_trans, n.sim = 300000, seed = 123,
#             plot.flag = TRUE, plot.title = FALSE)

}
