% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lakeformation_operations.R
\name{lakeformation_list_permissions}
\alias{lakeformation_list_permissions}
\title{Returns a list of the principal permissions on the resource, filtered by
the permissions of the caller}
\usage{
lakeformation_list_permissions(
  CatalogId = NULL,
  Principal = NULL,
  ResourceType = NULL,
  Resource = NULL,
  NextToken = NULL,
  MaxResults = NULL,
  IncludeRelated = NULL
)
}
\arguments{
\item{CatalogId}{The identifier for the Data Catalog. By default, the account ID. The
Data Catalog is the persistent metadata store. It contains database
definitions, table definitions, and other control information to manage
your Lake Formation environment.}

\item{Principal}{Specifies a principal to filter the permissions returned.}

\item{ResourceType}{Specifies a resource type to filter the permissions returned.}

\item{Resource}{A resource where you will get a list of the principal permissions.

This operation does not support getting privileges on a table with
columns. Instead, call this operation on the table, and the operation
returns the table and the table w columns.}

\item{NextToken}{A continuation token, if this is not the first call to retrieve this
list.}

\item{MaxResults}{The maximum number of results to return.}

\item{IncludeRelated}{Indicates that related permissions should be included in the results.}
}
\description{
Returns a list of the principal permissions on the resource, filtered by the permissions of the caller. For example, if you are granted an ALTER permission, you are able to see only the principal permissions for ALTER.

See \url{https://www.paws-r-sdk.com/docs/lakeformation_list_permissions/} for full documentation.
}
\keyword{internal}
