% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_remove_tags_from_resource}
\alias{elasticache_remove_tags_from_resource}
\title{Removes the tags identified by the TagKeys list from the named resource}
\usage{
elasticache_remove_tags_from_resource(ResourceName, TagKeys)
}
\arguments{
\item{ResourceName}{[required] The Amazon Resource Name (ARN) of the resource from which you want the
tags removed, for example
\code{arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster} or
\code{arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot}.

For more information about ARNs, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Names (ARNs) and Amazon Service Namespaces}.}

\item{TagKeys}{[required] A list of \code{TagKeys} identifying the tags you want removed from the named
resource.}
}
\description{
Removes the tags identified by the \code{TagKeys} list from the named resource. A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track all your ElastiCache resources, with the exception of global replication group. When you add or remove tags on replication groups, those actions will be replicated to all nodes in the replication group. For more information, see \href{https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/IAM.ResourceLevelPermissions.html}{Resource-level permissions}.

See \url{https://www.paws-r-sdk.com/docs/elasticache_remove_tags_from_resource/} for full documentation.
}
\keyword{internal}
