% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinpointemail_operations.R
\name{pinpointemail_put_email_identity_feedback_attributes}
\alias{pinpointemail_put_email_identity_feedback_attributes}
\title{Used to enable or disable feedback forwarding for an identity}
\usage{
pinpointemail_put_email_identity_feedback_attributes(EmailIdentity,
  EmailForwardingEnabled)
}
\arguments{
\item{EmailIdentity}{[required] The email identity that you want to configure bounce and complaint
feedback forwarding for.}

\item{EmailForwardingEnabled}{Sets the feedback forwarding configuration for the identity.

If the value is \code{true}, Amazon Pinpoint sends you email notifications
when bounce or complaint events occur. Amazon Pinpoint sends this
notification to the address that you specified in the Return-Path header
of the original email.

When you set this value to \code{false}, Amazon Pinpoint sends notifications
through other mechanisms, such as by notifying an Amazon SNS topic or
another event destination. You\'re required to have a method of tracking
bounces and complaints. If you haven\'t set up another mechanism for
receiving bounce or complaint notifications, Amazon Pinpoint sends an
email notification when these events occur (even if this setting is
disabled).}
}
\description{
Used to enable or disable feedback forwarding for an identity. This
setting determines what happens when an identity is used to send an
email that results in a bounce or complaint event.
}
\details{
When you enable feedback forwarding, Amazon Pinpoint sends you email
notifications when bounce or complaint events occur. Amazon Pinpoint
sends this notification to the address that you specified in the
Return-Path header of the original email.

When you disable feedback forwarding, Amazon Pinpoint sends
notifications through other mechanisms, such as by notifying an Amazon
SNS topic. You\'re required to have a method of tracking bounces and
complaints. If you haven\'t set up another mechanism for receiving
bounce or complaint notifications, Amazon Pinpoint sends an email
notification when these events occur (even if this setting is disabled).
}
\section{Request syntax}{
\preformatted{svc$put_email_identity_feedback_attributes(
  EmailIdentity = "string",
  EmailForwardingEnabled = TRUE|FALSE
)
}
}

\keyword{internal}
