% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/budgets_operations.R
\name{budgets_update_notification}
\alias{budgets_update_notification}
\title{Updates a notification}
\usage{
budgets_update_notification(AccountId, BudgetName, OldNotification,
  NewNotification)
}
\arguments{
\item{AccountId}{[required] The \code{accountId} that is associated with the budget whose notification
you want to update.}

\item{BudgetName}{[required] The name of the budget whose notification you want to update.}

\item{OldNotification}{[required] The previous notification that is associated with a budget.}

\item{NewNotification}{[required] The updated notification to be associated with a budget.}
}
\description{
Updates a notification.
}
\section{Request syntax}{
\preformatted{svc$update_notification(
  AccountId = "string",
  BudgetName = "string",
  OldNotification = list(
    NotificationType = "ACTUAL"|"FORECASTED",
    ComparisonOperator = "GREATER_THAN"|"LESS_THAN"|"EQUAL_TO",
    Threshold = 123.0,
    ThresholdType = "PERCENTAGE"|"ABSOLUTE_VALUE",
    NotificationState = "OK"|"ALARM"
  ),
  NewNotification = list(
    NotificationType = "ACTUAL"|"FORECASTED",
    ComparisonOperator = "GREATER_THAN"|"LESS_THAN"|"EQUAL_TO",
    Threshold = 123.0,
    ThresholdType = "PERCENTAGE"|"ABSOLUTE_VALUE",
    NotificationState = "OK"|"ALARM"
  )
)
}
}

\keyword{internal}
