# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include costexplorer_service.R
NULL

#' Creates a new cost anomaly detection monitor with the requested type and
#' monitor specification
#'
#' @description
#' Creates a new cost anomaly detection monitor with the requested type and
#' monitor specification.
#'
#' @usage
#' costexplorer_create_anomaly_monitor(AnomalyMonitor)
#'
#' @param AnomalyMonitor &#91;required&#93; The cost anomaly detection monitor object that you want to create.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   MonitorArn = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_anomaly_monitor(
#'   AnomalyMonitor = list(
#'     MonitorArn = "string",
#'     MonitorName = "string",
#'     CreationDate = "string",
#'     LastUpdatedDate = "string",
#'     LastEvaluatedDate = "string",
#'     MonitorType = "DIMENSIONAL"|"CUSTOM",
#'     MonitorDimension = "SERVICE",
#'     MonitorSpecification = list(
#'       Or = list(
#'         list()
#'       ),
#'       And = list(
#'         list()
#'       ),
#'       Not = list(),
#'       Dimensions = list(
#'         Key = "AZ"|"INSTANCE_TYPE"|"LINKED_ACCOUNT"|"LINKED_ACCOUNT_NAME"|"OPERATION"|"PURCHASE_TYPE"|"REGION"|"SERVICE"|"SERVICE_CODE"|"USAGE_TYPE"|"USAGE_TYPE_GROUP"|"RECORD_TYPE"|"OPERATING_SYSTEM"|"TENANCY"|"SCOPE"|"PLATFORM"|"SUBSCRIPTION_ID"|"LEGAL_ENTITY_NAME"|"DEPLOYMENT_OPTION"|"DATABASE_ENGINE"|"CACHE_ENGINE"|"INSTANCE_TYPE_FAMILY"|"BILLING_ENTITY"|"RESERVATION_ID"|"RESOURCE_ID"|"RIGHTSIZING_TYPE"|"SAVINGS_PLANS_TYPE"|"SAVINGS_PLAN_ARN"|"PAYMENT_OPTION"|"AGREEMENT_END_DATE_TIME_AFTER"|"AGREEMENT_END_DATE_TIME_BEFORE",
#'         Values = list(
#'           "string"
#'         ),
#'         MatchOptions = list(
#'           "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'         )
#'       ),
#'       Tags = list(
#'         Key = "string",
#'         Values = list(
#'           "string"
#'         ),
#'         MatchOptions = list(
#'           "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'         )
#'       ),
#'       CostCategories = list(
#'         Key = "string",
#'         Values = list(
#'           "string"
#'         ),
#'         MatchOptions = list(
#'           "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'         )
#'       )
#'     ),
#'     DimensionalValueCount = 123
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname costexplorer_create_anomaly_monitor
costexplorer_create_anomaly_monitor <- function(AnomalyMonitor) {
  op <- new_operation(
    name = "CreateAnomalyMonitor",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$create_anomaly_monitor_input(AnomalyMonitor = AnomalyMonitor)
  output <- .costexplorer$create_anomaly_monitor_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$create_anomaly_monitor <- costexplorer_create_anomaly_monitor

#' Adds a subscription to a cost anomaly detection monitor
#'
#' @description
#' Adds a subscription to a cost anomaly detection monitor. You can use
#' each subscription to define subscribers with email or SNS notifications.
#' Email subscribers can set a dollar threshold and a time frequency for
#' receiving notifications.
#'
#' @usage
#' costexplorer_create_anomaly_subscription(AnomalySubscription)
#'
#' @param AnomalySubscription &#91;required&#93; The cost anomaly subscription object that you want to create.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   SubscriptionArn = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_anomaly_subscription(
#'   AnomalySubscription = list(
#'     SubscriptionArn = "string",
#'     AccountId = "string",
#'     MonitorArnList = list(
#'       "string"
#'     ),
#'     Subscribers = list(
#'       list(
#'         Address = "string",
#'         Type = "EMAIL"|"SNS",
#'         Status = "CONFIRMED"|"DECLINED"
#'       )
#'     ),
#'     Threshold = 123.0,
#'     Frequency = "DAILY"|"IMMEDIATE"|"WEEKLY",
#'     SubscriptionName = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname costexplorer_create_anomaly_subscription
costexplorer_create_anomaly_subscription <- function(AnomalySubscription) {
  op <- new_operation(
    name = "CreateAnomalySubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$create_anomaly_subscription_input(AnomalySubscription = AnomalySubscription)
  output <- .costexplorer$create_anomaly_subscription_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$create_anomaly_subscription <- costexplorer_create_anomaly_subscription

#' Creates a new Cost Category with the requested name and rules
#'
#' @description
#' Creates a new Cost Category with the requested name and rules.
#'
#' @usage
#' costexplorer_create_cost_category_definition(Name, RuleVersion, Rules)
#'
#' @param Name &#91;required&#93; 
#' @param RuleVersion &#91;required&#93; 
#' @param Rules &#91;required&#93; The Cost Category rules used to categorize costs. For more information,
#' see
#' [CostCategoryRule](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategoryRule.html).
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   CostCategoryArn = "string",
#'   EffectiveStart = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_cost_category_definition(
#'   Name = "string",
#'   RuleVersion = "CostCategoryExpression.v1",
#'   Rules = list(
#'     list(
#'       Value = "string",
#'       Rule = list(
#'         Or = list(
#'           list()
#'         ),
#'         And = list(
#'           list()
#'         ),
#'         Not = list(),
#'         Dimensions = list(
#'           Key = "AZ"|"INSTANCE_TYPE"|"LINKED_ACCOUNT"|"LINKED_ACCOUNT_NAME"|"OPERATION"|"PURCHASE_TYPE"|"REGION"|"SERVICE"|"SERVICE_CODE"|"USAGE_TYPE"|"USAGE_TYPE_GROUP"|"RECORD_TYPE"|"OPERATING_SYSTEM"|"TENANCY"|"SCOPE"|"PLATFORM"|"SUBSCRIPTION_ID"|"LEGAL_ENTITY_NAME"|"DEPLOYMENT_OPTION"|"DATABASE_ENGINE"|"CACHE_ENGINE"|"INSTANCE_TYPE_FAMILY"|"BILLING_ENTITY"|"RESERVATION_ID"|"RESOURCE_ID"|"RIGHTSIZING_TYPE"|"SAVINGS_PLANS_TYPE"|"SAVINGS_PLAN_ARN"|"PAYMENT_OPTION"|"AGREEMENT_END_DATE_TIME_AFTER"|"AGREEMENT_END_DATE_TIME_BEFORE",
#'           Values = list(
#'             "string"
#'           ),
#'           MatchOptions = list(
#'             "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'           )
#'         ),
#'         Tags = list(
#'           Key = "string",
#'           Values = list(
#'             "string"
#'           ),
#'           MatchOptions = list(
#'             "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'           )
#'         ),
#'         CostCategories = list(
#'           Key = "string",
#'           Values = list(
#'             "string"
#'           ),
#'           MatchOptions = list(
#'             "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'           )
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname costexplorer_create_cost_category_definition
costexplorer_create_cost_category_definition <- function(Name, RuleVersion, Rules) {
  op <- new_operation(
    name = "CreateCostCategoryDefinition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$create_cost_category_definition_input(Name = Name, RuleVersion = RuleVersion, Rules = Rules)
  output <- .costexplorer$create_cost_category_definition_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$create_cost_category_definition <- costexplorer_create_cost_category_definition

#' Deletes a cost anomaly monitor
#'
#' @description
#' Deletes a cost anomaly monitor.
#'
#' @usage
#' costexplorer_delete_anomaly_monitor(MonitorArn)
#'
#' @param MonitorArn &#91;required&#93; The unique identifier of the cost anomaly monitor that you want to
#' delete.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_anomaly_monitor(
#'   MonitorArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname costexplorer_delete_anomaly_monitor
costexplorer_delete_anomaly_monitor <- function(MonitorArn) {
  op <- new_operation(
    name = "DeleteAnomalyMonitor",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$delete_anomaly_monitor_input(MonitorArn = MonitorArn)
  output <- .costexplorer$delete_anomaly_monitor_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$delete_anomaly_monitor <- costexplorer_delete_anomaly_monitor

#' Deletes a cost anomaly subscription
#'
#' @description
#' Deletes a cost anomaly subscription.
#'
#' @usage
#' costexplorer_delete_anomaly_subscription(SubscriptionArn)
#'
#' @param SubscriptionArn &#91;required&#93; The unique identifier of the cost anomaly subscription that you want to
#' delete.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_anomaly_subscription(
#'   SubscriptionArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname costexplorer_delete_anomaly_subscription
costexplorer_delete_anomaly_subscription <- function(SubscriptionArn) {
  op <- new_operation(
    name = "DeleteAnomalySubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$delete_anomaly_subscription_input(SubscriptionArn = SubscriptionArn)
  output <- .costexplorer$delete_anomaly_subscription_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$delete_anomaly_subscription <- costexplorer_delete_anomaly_subscription

#' Deletes a Cost Category
#'
#' @description
#' Deletes a Cost Category. Expenses from this month going forward will no
#' longer be categorized with this Cost Category.
#'
#' @usage
#' costexplorer_delete_cost_category_definition(CostCategoryArn)
#'
#' @param CostCategoryArn &#91;required&#93; The unique identifier for your Cost Category.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   CostCategoryArn = "string",
#'   EffectiveEnd = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_cost_category_definition(
#'   CostCategoryArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname costexplorer_delete_cost_category_definition
costexplorer_delete_cost_category_definition <- function(CostCategoryArn) {
  op <- new_operation(
    name = "DeleteCostCategoryDefinition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$delete_cost_category_definition_input(CostCategoryArn = CostCategoryArn)
  output <- .costexplorer$delete_cost_category_definition_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$delete_cost_category_definition <- costexplorer_delete_cost_category_definition

#' Returns the name, ARN, rules, definition, and effective dates of a Cost
#' Category that's defined in the account
#'
#' @description
#' Returns the name, ARN, rules, definition, and effective dates of a Cost
#' Category that's defined in the account.
#' 
#' You have the option to use `EffectiveOn` to return a Cost Category that
#' is active on a specific date. If there is no `EffectiveOn` specified,
#' you’ll see a Cost Category that is effective on the current date. If
#' Cost Category is still effective, `EffectiveEnd` is omitted in the
#' response.
#'
#' @usage
#' costexplorer_describe_cost_category_definition(CostCategoryArn,
#'   EffectiveOn)
#'
#' @param CostCategoryArn &#91;required&#93; The unique identifier for your Cost Category.
#' @param EffectiveOn The date when the Cost Category was effective.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   CostCategory = list(
#'     CostCategoryArn = "string",
#'     EffectiveStart = "string",
#'     EffectiveEnd = "string",
#'     Name = "string",
#'     RuleVersion = "CostCategoryExpression.v1",
#'     Rules = list(
#'       list(
#'         Value = "string",
#'         Rule = list(
#'           Or = list(
#'             list()
#'           ),
#'           And = list(
#'             list()
#'           ),
#'           Not = list(),
#'           Dimensions = list(
#'             Key = "AZ"|"INSTANCE_TYPE"|"LINKED_ACCOUNT"|"LINKED_ACCOUNT_NAME"|"OPERATION"|"PURCHASE_TYPE"|"REGION"|"SERVICE"|"SERVICE_CODE"|"USAGE_TYPE"|"USAGE_TYPE_GROUP"|"RECORD_TYPE"|"OPERATING_SYSTEM"|"TENANCY"|"SCOPE"|"PLATFORM"|"SUBSCRIPTION_ID"|"LEGAL_ENTITY_NAME"|"DEPLOYMENT_OPTION"|"DATABASE_ENGINE"|"CACHE_ENGINE"|"INSTANCE_TYPE_FAMILY"|"BILLING_ENTITY"|"RESERVATION_ID"|"RESOURCE_ID"|"RIGHTSIZING_TYPE"|"SAVINGS_PLANS_TYPE"|"SAVINGS_PLAN_ARN"|"PAYMENT_OPTION"|"AGREEMENT_END_DATE_TIME_AFTER"|"AGREEMENT_END_DATE_TIME_BEFORE",
#'             Values = list(
#'               "string"
#'             ),
#'             MatchOptions = list(
#'               "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'             )
#'           ),
#'           Tags = list(
#'             Key = "string",
#'             Values = list(
#'               "string"
#'             ),
#'             MatchOptions = list(
#'               "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'             )
#'           ),
#'           CostCategories = list(
#'             Key = "string",
#'             Values = list(
#'               "string"
#'             ),
#'             MatchOptions = list(
#'               "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'             )
#'           )
#'         )
#'       )
#'     ),
#'     ProcessingStatus = list(
#'       list(
#'         Component = "COST_EXPLORER",
#'         Status = "PROCESSING"|"APPLIED"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_cost_category_definition(
#'   CostCategoryArn = "string",
#'   EffectiveOn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname costexplorer_describe_cost_category_definition
costexplorer_describe_cost_category_definition <- function(CostCategoryArn, EffectiveOn = NULL) {
  op <- new_operation(
    name = "DescribeCostCategoryDefinition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$describe_cost_category_definition_input(CostCategoryArn = CostCategoryArn, EffectiveOn = EffectiveOn)
  output <- .costexplorer$describe_cost_category_definition_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$describe_cost_category_definition <- costexplorer_describe_cost_category_definition

#' Retrieves all of the cost anomalies detected on your account, during the
#' time period specified by the DateInterval object
#'
#' @description
#' Retrieves all of the cost anomalies detected on your account, during the
#' time period specified by the `DateInterval` object.
#'
#' @usage
#' costexplorer_get_anomalies(MonitorArn, DateInterval, Feedback,
#'   TotalImpact, NextPageToken, MaxResults)
#'
#' @param MonitorArn Retrieves all of the cost anomalies detected for a specific cost anomaly
#' monitor Amazon Resource Name (ARN).
#' @param DateInterval &#91;required&#93; Assigns the start and end dates for retrieving cost anomalies. The
#' returned anomaly object will have an `AnomalyEndDate` in the specified
#' time range.
#' @param Feedback Filters anomaly results by the feedback field on the anomaly object.
#' @param TotalImpact Filters anomaly results by the total impact field on the anomaly object.
#' For example, you can filter anomalies `GREATER_THAN 200.00` to retrieve
#' anomalies, with an estimated dollar impact greater than 200.
#' @param NextPageToken The token to retrieve the next set of results. AWS provides the token
#' when the response from a previous call has more results than the maximum
#' page size.
#' @param MaxResults The number of entries a paginated response contains.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Anomalies = list(
#'     list(
#'       AnomalyId = "string",
#'       AnomalyStartDate = "string",
#'       AnomalyEndDate = "string",
#'       DimensionValue = "string",
#'       RootCauses = list(
#'         list(
#'           Service = "string",
#'           Region = "string",
#'           LinkedAccount = "string",
#'           UsageType = "string"
#'         )
#'       ),
#'       AnomalyScore = list(
#'         MaxScore = 123.0,
#'         CurrentScore = 123.0
#'       ),
#'       Impact = list(
#'         MaxImpact = 123.0,
#'         TotalImpact = 123.0
#'       ),
#'       MonitorArn = "string",
#'       Feedback = "YES"|"NO"|"PLANNED_ACTIVITY"
#'     )
#'   ),
#'   NextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_anomalies(
#'   MonitorArn = "string",
#'   DateInterval = list(
#'     StartDate = "string",
#'     EndDate = "string"
#'   ),
#'   Feedback = "YES"|"NO"|"PLANNED_ACTIVITY",
#'   TotalImpact = list(
#'     NumericOperator = "EQUAL"|"GREATER_THAN_OR_EQUAL"|"LESS_THAN_OR_EQUAL"|"GREATER_THAN"|"LESS_THAN"|"BETWEEN",
#'     StartValue = 123.0,
#'     EndValue = 123.0
#'   ),
#'   NextPageToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname costexplorer_get_anomalies
costexplorer_get_anomalies <- function(MonitorArn = NULL, DateInterval, Feedback = NULL, TotalImpact = NULL, NextPageToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetAnomalies",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$get_anomalies_input(MonitorArn = MonitorArn, DateInterval = DateInterval, Feedback = Feedback, TotalImpact = TotalImpact, NextPageToken = NextPageToken, MaxResults = MaxResults)
  output <- .costexplorer$get_anomalies_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$get_anomalies <- costexplorer_get_anomalies

#' Retrieves the cost anomaly monitor definitions for your account
#'
#' @description
#' Retrieves the cost anomaly monitor definitions for your account. You can
#' filter using a list of cost anomaly monitor Amazon Resource Names
#' (ARNs).
#'
#' @usage
#' costexplorer_get_anomaly_monitors(MonitorArnList, NextPageToken,
#'   MaxResults)
#'
#' @param MonitorArnList A list of cost anomaly monitor ARNs.
#' @param NextPageToken The token to retrieve the next set of results. AWS provides the token
#' when the response from a previous call has more results than the maximum
#' page size.
#' @param MaxResults The number of entries a paginated response contains.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   AnomalyMonitors = list(
#'     list(
#'       MonitorArn = "string",
#'       MonitorName = "string",
#'       CreationDate = "string",
#'       LastUpdatedDate = "string",
#'       LastEvaluatedDate = "string",
#'       MonitorType = "DIMENSIONAL"|"CUSTOM",
#'       MonitorDimension = "SERVICE",
#'       MonitorSpecification = list(
#'         Or = list(
#'           list()
#'         ),
#'         And = list(
#'           list()
#'         ),
#'         Not = list(),
#'         Dimensions = list(
#'           Key = "AZ"|"INSTANCE_TYPE"|"LINKED_ACCOUNT"|"LINKED_ACCOUNT_NAME"|"OPERATION"|"PURCHASE_TYPE"|"REGION"|"SERVICE"|"SERVICE_CODE"|"USAGE_TYPE"|"USAGE_TYPE_GROUP"|"RECORD_TYPE"|"OPERATING_SYSTEM"|"TENANCY"|"SCOPE"|"PLATFORM"|"SUBSCRIPTION_ID"|"LEGAL_ENTITY_NAME"|"DEPLOYMENT_OPTION"|"DATABASE_ENGINE"|"CACHE_ENGINE"|"INSTANCE_TYPE_FAMILY"|"BILLING_ENTITY"|"RESERVATION_ID"|"RESOURCE_ID"|"RIGHTSIZING_TYPE"|"SAVINGS_PLANS_TYPE"|"SAVINGS_PLAN_ARN"|"PAYMENT_OPTION"|"AGREEMENT_END_DATE_TIME_AFTER"|"AGREEMENT_END_DATE_TIME_BEFORE",
#'           Values = list(
#'             "string"
#'           ),
#'           MatchOptions = list(
#'             "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'           )
#'         ),
#'         Tags = list(
#'           Key = "string",
#'           Values = list(
#'             "string"
#'           ),
#'           MatchOptions = list(
#'             "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'           )
#'         ),
#'         CostCategories = list(
#'           Key = "string",
#'           Values = list(
#'             "string"
#'           ),
#'           MatchOptions = list(
#'             "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'           )
#'         )
#'       ),
#'       DimensionalValueCount = 123
#'     )
#'   ),
#'   NextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_anomaly_monitors(
#'   MonitorArnList = list(
#'     "string"
#'   ),
#'   NextPageToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname costexplorer_get_anomaly_monitors
costexplorer_get_anomaly_monitors <- function(MonitorArnList = NULL, NextPageToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetAnomalyMonitors",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$get_anomaly_monitors_input(MonitorArnList = MonitorArnList, NextPageToken = NextPageToken, MaxResults = MaxResults)
  output <- .costexplorer$get_anomaly_monitors_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$get_anomaly_monitors <- costexplorer_get_anomaly_monitors

#' Retrieves the cost anomaly subscription objects for your account
#'
#' @description
#' Retrieves the cost anomaly subscription objects for your account. You
#' can filter using a list of cost anomaly monitor Amazon Resource Names
#' (ARNs).
#'
#' @usage
#' costexplorer_get_anomaly_subscriptions(SubscriptionArnList, MonitorArn,
#'   NextPageToken, MaxResults)
#'
#' @param SubscriptionArnList A list of cost anomaly subscription ARNs.
#' @param MonitorArn Cost anomaly monitor ARNs.
#' @param NextPageToken The token to retrieve the next set of results. AWS provides the token
#' when the response from a previous call has more results than the maximum
#' page size.
#' @param MaxResults The number of entries a paginated response contains.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   AnomalySubscriptions = list(
#'     list(
#'       SubscriptionArn = "string",
#'       AccountId = "string",
#'       MonitorArnList = list(
#'         "string"
#'       ),
#'       Subscribers = list(
#'         list(
#'           Address = "string",
#'           Type = "EMAIL"|"SNS",
#'           Status = "CONFIRMED"|"DECLINED"
#'         )
#'       ),
#'       Threshold = 123.0,
#'       Frequency = "DAILY"|"IMMEDIATE"|"WEEKLY",
#'       SubscriptionName = "string"
#'     )
#'   ),
#'   NextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_anomaly_subscriptions(
#'   SubscriptionArnList = list(
#'     "string"
#'   ),
#'   MonitorArn = "string",
#'   NextPageToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname costexplorer_get_anomaly_subscriptions
costexplorer_get_anomaly_subscriptions <- function(SubscriptionArnList = NULL, MonitorArn = NULL, NextPageToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetAnomalySubscriptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$get_anomaly_subscriptions_input(SubscriptionArnList = SubscriptionArnList, MonitorArn = MonitorArn, NextPageToken = NextPageToken, MaxResults = MaxResults)
  output <- .costexplorer$get_anomaly_subscriptions_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$get_anomaly_subscriptions <- costexplorer_get_anomaly_subscriptions

#' Retrieves cost and usage metrics for your account
#'
#' @description
#' Retrieves cost and usage metrics for your account. You can specify which
#' cost and usage-related metric, such as `BlendedCosts` or
#' `UsageQuantity`, that you want the request to return. You can also
#' filter and group your data by various dimensions, such as `SERVICE` or
#' `AZ`, in a specific time range. For a complete list of valid dimensions,
#' see the [`get_dimension_values`][costexplorer_get_dimension_values]
#' operation. Management account in an organization in AWS Organizations
#' have access to all member accounts.
#' 
#' For information about filter limitations, see [Quotas and
#' restrictions](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-limits.html)
#' in the *Billing and Cost Management User Guide*.
#'
#' @usage
#' costexplorer_get_cost_and_usage(TimePeriod, Granularity, Filter,
#'   Metrics, GroupBy, NextPageToken)
#'
#' @param TimePeriod &#91;required&#93; Sets the start and end dates for retrieving AWS costs. The start date is
#' inclusive, but the end date is exclusive. For example, if `start` is
#' `2017-01-01` and `end` is `2017-05-01`, then the cost and usage data is
#' retrieved from `2017-01-01` up to and including `2017-04-30` but not
#' including `2017-05-01`.
#' @param Granularity Sets the AWS cost granularity to `MONTHLY` or `DAILY`, or `HOURLY`. If
#' `Granularity` isn't set, the response object doesn't include the
#' `Granularity`, either `MONTHLY` or `DAILY`, or `HOURLY`.
#' @param Filter Filters AWS costs by different dimensions. For example, you can specify
#' `SERVICE` and `LINKED_ACCOUNT` and get the costs that are associated
#' with that account's usage of that service. You can nest `Expression`
#' objects to define any combination of dimension filters. For more
#' information, see
#' [Expression](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html).
#' @param Metrics &#91;required&#93; Which metrics are returned in the query. For more information about
#' blended and unblended rates, see [Why does the "blended" annotation
#' appear on some line items in my
#' bill?](https://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/).
#' 
#' Valid values are `AmortizedCost`, `BlendedCost`, `NetAmortizedCost`,
#' `NetUnblendedCost`, `NormalizedUsageAmount`, `UnblendedCost`, and
#' `UsageQuantity`.
#' 
#' If you return the `UsageQuantity` metric, the service aggregates all
#' usage numbers without taking into account the units. For example, if you
#' aggregate `usageQuantity` across all of Amazon EC2, the results aren't
#' meaningful because Amazon EC2 compute hours and data transfer are
#' measured in different units (for example, hours vs. GB). To get more
#' meaningful `UsageQuantity` metrics, filter by `UsageType` or
#' `UsageTypeGroups`.
#' 
#' `Metrics` is required for
#' [`get_cost_and_usage`][costexplorer_get_cost_and_usage] requests.
#' @param GroupBy You can group AWS costs using up to two different groups, either
#' dimensions, tag keys, cost categories, or any two group by types.
#' 
#' When you group by tag key, you get all tag values, including empty
#' strings.
#' 
#' Valid values are `AZ`, `INSTANCE_TYPE`, `LEGAL_ENTITY_NAME`,
#' `LINKED_ACCOUNT`, `OPERATION`, `PLATFORM`, `PURCHASE_TYPE`, `SERVICE`,
#' `TAGS`, `TENANCY`, `RECORD_TYPE`, and `USAGE_TYPE`.
#' @param NextPageToken The token to retrieve the next set of results. AWS provides the token
#' when the response from a previous call has more results than the maximum
#' page size.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NextPageToken = "string",
#'   GroupDefinitions = list(
#'     list(
#'       Type = "DIMENSION"|"TAG"|"COST_CATEGORY",
#'       Key = "string"
#'     )
#'   ),
#'   ResultsByTime = list(
#'     list(
#'       TimePeriod = list(
#'         Start = "string",
#'         End = "string"
#'       ),
#'       Total = list(
#'         list(
#'           Amount = "string",
#'           Unit = "string"
#'         )
#'       ),
#'       Groups = list(
#'         list(
#'           Keys = list(
#'             "string"
#'           ),
#'           Metrics = list(
#'             list(
#'               Amount = "string",
#'               Unit = "string"
#'             )
#'           )
#'         )
#'       ),
#'       Estimated = TRUE|FALSE
#'     )
#'   ),
#'   DimensionValueAttributes = list(
#'     list(
#'       Value = "string",
#'       Attributes = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_cost_and_usage(
#'   TimePeriod = list(
#'     Start = "string",
#'     End = "string"
#'   ),
#'   Granularity = "DAILY"|"MONTHLY"|"HOURLY",
#'   Filter = list(
#'     Or = list(
#'       list()
#'     ),
#'     And = list(
#'       list()
#'     ),
#'     Not = list(),
#'     Dimensions = list(
#'       Key = "AZ"|"INSTANCE_TYPE"|"LINKED_ACCOUNT"|"LINKED_ACCOUNT_NAME"|"OPERATION"|"PURCHASE_TYPE"|"REGION"|"SERVICE"|"SERVICE_CODE"|"USAGE_TYPE"|"USAGE_TYPE_GROUP"|"RECORD_TYPE"|"OPERATING_SYSTEM"|"TENANCY"|"SCOPE"|"PLATFORM"|"SUBSCRIPTION_ID"|"LEGAL_ENTITY_NAME"|"DEPLOYMENT_OPTION"|"DATABASE_ENGINE"|"CACHE_ENGINE"|"INSTANCE_TYPE_FAMILY"|"BILLING_ENTITY"|"RESERVATION_ID"|"RESOURCE_ID"|"RIGHTSIZING_TYPE"|"SAVINGS_PLANS_TYPE"|"SAVINGS_PLAN_ARN"|"PAYMENT_OPTION"|"AGREEMENT_END_DATE_TIME_AFTER"|"AGREEMENT_END_DATE_TIME_BEFORE",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     ),
#'     Tags = list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     ),
#'     CostCategories = list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     )
#'   ),
#'   Metrics = list(
#'     "string"
#'   ),
#'   GroupBy = list(
#'     list(
#'       Type = "DIMENSION"|"TAG"|"COST_CATEGORY",
#'       Key = "string"
#'     )
#'   ),
#'   NextPageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname costexplorer_get_cost_and_usage
costexplorer_get_cost_and_usage <- function(TimePeriod, Granularity = NULL, Filter = NULL, Metrics, GroupBy = NULL, NextPageToken = NULL) {
  op <- new_operation(
    name = "GetCostAndUsage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$get_cost_and_usage_input(TimePeriod = TimePeriod, Granularity = Granularity, Filter = Filter, Metrics = Metrics, GroupBy = GroupBy, NextPageToken = NextPageToken)
  output <- .costexplorer$get_cost_and_usage_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$get_cost_and_usage <- costexplorer_get_cost_and_usage

#' Retrieves cost and usage metrics with resources for your account
#'
#' @description
#' Retrieves cost and usage metrics with resources for your account. You
#' can specify which cost and usage-related metric, such as `BlendedCosts`
#' or `UsageQuantity`, that you want the request to return. You can also
#' filter and group your data by various dimensions, such as `SERVICE` or
#' `AZ`, in a specific time range. For a complete list of valid dimensions,
#' see the [`get_dimension_values`][costexplorer_get_dimension_values]
#' operation. Management account in an organization in AWS Organizations
#' have access to all member accounts. This API is currently available for
#' the Amazon Elastic Compute Cloud – Compute service only.
#' 
#' This is an opt-in only feature. You can enable this feature from the
#' Cost Explorer Settings page. For information on how to access the
#' Settings page, see [Controlling Access for Cost
#' Explorer](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/ce-access.html)
#' in the *AWS Billing and Cost Management User Guide*.
#'
#' @usage
#' costexplorer_get_cost_and_usage_with_resources(TimePeriod, Granularity,
#'   Filter, Metrics, GroupBy, NextPageToken)
#'
#' @param TimePeriod &#91;required&#93; Sets the start and end dates for retrieving Amazon Web Services costs.
#' The range must be within the last 14 days (the start date cannot be
#' earlier than 14 days ago). The start date is inclusive, but the end date
#' is exclusive. For example, if `start` is `2017-01-01` and `end` is
#' `2017-05-01`, then the cost and usage data is retrieved from
#' `2017-01-01` up to and including `2017-04-30` but not including
#' `2017-05-01`.
#' @param Granularity Sets the AWS cost granularity to `MONTHLY`, `DAILY`, or `HOURLY`. If
#' `Granularity` isn't set, the response object doesn't include the
#' `Granularity`, `MONTHLY`, `DAILY`, or `HOURLY`.
#' @param Filter &#91;required&#93; Filters Amazon Web Services costs by different dimensions. For example,
#' you can specify `SERVICE` and `LINKED_ACCOUNT` and get the costs that
#' are associated with that account's usage of that service. You can nest
#' `Expression` objects to define any combination of dimension filters. For
#' more information, see
#' [Expression](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html).
#' 
#' The
#' [`get_cost_and_usage_with_resources`][costexplorer_get_cost_and_usage_with_resources]
#' operation requires that you either group by or filter by a `ResourceId`.
#' It requires the
#' [Expression](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html)
#' `"SERVICE = Amazon Elastic Compute Cloud - Compute"` in the filter.
#' @param Metrics Which metrics are returned in the query. For more information about
#' blended and unblended rates, see [Why does the "blended" annotation
#' appear on some line items in my
#' bill?](https://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/).
#' 
#' Valid values are `AmortizedCost`, `BlendedCost`, `NetAmortizedCost`,
#' `NetUnblendedCost`, `NormalizedUsageAmount`, `UnblendedCost`, and
#' `UsageQuantity`.
#' 
#' If you return the `UsageQuantity` metric, the service aggregates all
#' usage numbers without taking the units into account. For example, if you
#' aggregate `usageQuantity` across all of Amazon EC2, the results aren't
#' meaningful because Amazon EC2 compute hours and data transfer are
#' measured in different units (for example, hours vs. GB). To get more
#' meaningful `UsageQuantity` metrics, filter by `UsageType` or
#' `UsageTypeGroups`.
#' 
#' `Metrics` is required for
#' [`get_cost_and_usage_with_resources`][costexplorer_get_cost_and_usage_with_resources]
#' requests.
#' @param GroupBy You can group Amazon Web Services costs using up to two different
#' groups: `DIMENSION`, `TAG`, `COST_CATEGORY`.
#' @param NextPageToken The token to retrieve the next set of results. AWS provides the token
#' when the response from a previous call has more results than the maximum
#' page size.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NextPageToken = "string",
#'   GroupDefinitions = list(
#'     list(
#'       Type = "DIMENSION"|"TAG"|"COST_CATEGORY",
#'       Key = "string"
#'     )
#'   ),
#'   ResultsByTime = list(
#'     list(
#'       TimePeriod = list(
#'         Start = "string",
#'         End = "string"
#'       ),
#'       Total = list(
#'         list(
#'           Amount = "string",
#'           Unit = "string"
#'         )
#'       ),
#'       Groups = list(
#'         list(
#'           Keys = list(
#'             "string"
#'           ),
#'           Metrics = list(
#'             list(
#'               Amount = "string",
#'               Unit = "string"
#'             )
#'           )
#'         )
#'       ),
#'       Estimated = TRUE|FALSE
#'     )
#'   ),
#'   DimensionValueAttributes = list(
#'     list(
#'       Value = "string",
#'       Attributes = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_cost_and_usage_with_resources(
#'   TimePeriod = list(
#'     Start = "string",
#'     End = "string"
#'   ),
#'   Granularity = "DAILY"|"MONTHLY"|"HOURLY",
#'   Filter = list(
#'     Or = list(
#'       list()
#'     ),
#'     And = list(
#'       list()
#'     ),
#'     Not = list(),
#'     Dimensions = list(
#'       Key = "AZ"|"INSTANCE_TYPE"|"LINKED_ACCOUNT"|"LINKED_ACCOUNT_NAME"|"OPERATION"|"PURCHASE_TYPE"|"REGION"|"SERVICE"|"SERVICE_CODE"|"USAGE_TYPE"|"USAGE_TYPE_GROUP"|"RECORD_TYPE"|"OPERATING_SYSTEM"|"TENANCY"|"SCOPE"|"PLATFORM"|"SUBSCRIPTION_ID"|"LEGAL_ENTITY_NAME"|"DEPLOYMENT_OPTION"|"DATABASE_ENGINE"|"CACHE_ENGINE"|"INSTANCE_TYPE_FAMILY"|"BILLING_ENTITY"|"RESERVATION_ID"|"RESOURCE_ID"|"RIGHTSIZING_TYPE"|"SAVINGS_PLANS_TYPE"|"SAVINGS_PLAN_ARN"|"PAYMENT_OPTION"|"AGREEMENT_END_DATE_TIME_AFTER"|"AGREEMENT_END_DATE_TIME_BEFORE",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     ),
#'     Tags = list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     ),
#'     CostCategories = list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     )
#'   ),
#'   Metrics = list(
#'     "string"
#'   ),
#'   GroupBy = list(
#'     list(
#'       Type = "DIMENSION"|"TAG"|"COST_CATEGORY",
#'       Key = "string"
#'     )
#'   ),
#'   NextPageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname costexplorer_get_cost_and_usage_with_resources
costexplorer_get_cost_and_usage_with_resources <- function(TimePeriod, Granularity = NULL, Filter, Metrics = NULL, GroupBy = NULL, NextPageToken = NULL) {
  op <- new_operation(
    name = "GetCostAndUsageWithResources",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$get_cost_and_usage_with_resources_input(TimePeriod = TimePeriod, Granularity = Granularity, Filter = Filter, Metrics = Metrics, GroupBy = GroupBy, NextPageToken = NextPageToken)
  output <- .costexplorer$get_cost_and_usage_with_resources_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$get_cost_and_usage_with_resources <- costexplorer_get_cost_and_usage_with_resources

#' Retrieves an array of Cost Category names and values incurred cost
#'
#' @description
#' Retrieves an array of Cost Category names and values incurred cost.
#' 
#' If some Cost Category names and values are not associated with any cost,
#' they will not be returned by this API.
#'
#' @usage
#' costexplorer_get_cost_categories(SearchString, TimePeriod,
#'   CostCategoryName, Filter, SortBy, MaxResults, NextPageToken)
#'
#' @param SearchString The value that you want to search the filter values for.
#' 
#' If you do not specify a `CostCategoryName`, `SearchString` will be used
#' to filter Cost Category names that match the `SearchString` pattern. If
#' you do specifiy a `CostCategoryName`, `SearchString` will be used to
#' filter Cost Category values that match the `SearchString` pattern.
#' @param TimePeriod &#91;required&#93; 
#' @param CostCategoryName 
#' @param Filter 
#' @param SortBy The value by which you want to sort the data.
#' 
#' The key represents cost and usage metrics. The following values are
#' supported:
#' 
#' -   `BlendedCost`
#' 
#' -   `UnblendedCost`
#' 
#' -   `AmortizedCost`
#' 
#' -   `NetAmortizedCost`
#' 
#' -   `NetUnblendedCost`
#' 
#' -   `UsageQuantity`
#' 
#' -   `NormalizedUsageAmount`
#' 
#' Supported values for `SortOrder` are `ASCENDING` or `DESCENDING`.
#' 
#' When using `SortBy`, `NextPageToken` and `SearchString` are not
#' supported.
#' @param MaxResults This field is only used when `SortBy` is provided in the request.
#' 
#' The maximum number of objects that to be returned for this request. If
#' `MaxResults` is not specified with `SortBy`, the request will return
#' 1000 results as the default value for this parameter.
#' @param NextPageToken If the number of objects that are still available for retrieval exceeds
#' the limit, AWS returns a NextPageToken value in the response. To
#' retrieve the next batch of objects, provide the NextPageToken from the
#' prior call in your next request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NextPageToken = "string",
#'   CostCategoryNames = list(
#'     "string"
#'   ),
#'   CostCategoryValues = list(
#'     "string"
#'   ),
#'   ReturnSize = 123,
#'   TotalSize = 123
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_cost_categories(
#'   SearchString = "string",
#'   TimePeriod = list(
#'     Start = "string",
#'     End = "string"
#'   ),
#'   CostCategoryName = "string",
#'   Filter = list(
#'     Or = list(
#'       list()
#'     ),
#'     And = list(
#'       list()
#'     ),
#'     Not = list(),
#'     Dimensions = list(
#'       Key = "AZ"|"INSTANCE_TYPE"|"LINKED_ACCOUNT"|"LINKED_ACCOUNT_NAME"|"OPERATION"|"PURCHASE_TYPE"|"REGION"|"SERVICE"|"SERVICE_CODE"|"USAGE_TYPE"|"USAGE_TYPE_GROUP"|"RECORD_TYPE"|"OPERATING_SYSTEM"|"TENANCY"|"SCOPE"|"PLATFORM"|"SUBSCRIPTION_ID"|"LEGAL_ENTITY_NAME"|"DEPLOYMENT_OPTION"|"DATABASE_ENGINE"|"CACHE_ENGINE"|"INSTANCE_TYPE_FAMILY"|"BILLING_ENTITY"|"RESERVATION_ID"|"RESOURCE_ID"|"RIGHTSIZING_TYPE"|"SAVINGS_PLANS_TYPE"|"SAVINGS_PLAN_ARN"|"PAYMENT_OPTION"|"AGREEMENT_END_DATE_TIME_AFTER"|"AGREEMENT_END_DATE_TIME_BEFORE",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     ),
#'     Tags = list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     ),
#'     CostCategories = list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     )
#'   ),
#'   SortBy = list(
#'     list(
#'       Key = "string",
#'       SortOrder = "ASCENDING"|"DESCENDING"
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextPageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname costexplorer_get_cost_categories
costexplorer_get_cost_categories <- function(SearchString = NULL, TimePeriod, CostCategoryName = NULL, Filter = NULL, SortBy = NULL, MaxResults = NULL, NextPageToken = NULL) {
  op <- new_operation(
    name = "GetCostCategories",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$get_cost_categories_input(SearchString = SearchString, TimePeriod = TimePeriod, CostCategoryName = CostCategoryName, Filter = Filter, SortBy = SortBy, MaxResults = MaxResults, NextPageToken = NextPageToken)
  output <- .costexplorer$get_cost_categories_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$get_cost_categories <- costexplorer_get_cost_categories

#' Retrieves a forecast for how much Amazon Web Services predicts that you
#' will spend over the forecast time period that you select, based on your
#' past costs
#'
#' @description
#' Retrieves a forecast for how much Amazon Web Services predicts that you
#' will spend over the forecast time period that you select, based on your
#' past costs.
#'
#' @usage
#' costexplorer_get_cost_forecast(TimePeriod, Metric, Granularity, Filter,
#'   PredictionIntervalLevel)
#'
#' @param TimePeriod &#91;required&#93; The period of time that you want the forecast to cover. The start date
#' must be equal to or no later than the current date to avoid a validation
#' error.
#' @param Metric &#91;required&#93; Which metric Cost Explorer uses to create your forecast. For more
#' information about blended and unblended rates, see [Why does the
#' "blended" annotation appear on some line items in my
#' bill?](https://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/).
#' 
#' Valid values for a [`get_cost_forecast`][costexplorer_get_cost_forecast]
#' call are the following:
#' 
#' -   AMORTIZED_COST
#' 
#' -   BLENDED_COST
#' 
#' -   NET_AMORTIZED_COST
#' 
#' -   NET_UNBLENDED_COST
#' 
#' -   UNBLENDED_COST
#' @param Granularity &#91;required&#93; How granular you want the forecast to be. You can get 3 months of
#' `DAILY` forecasts or 12 months of `MONTHLY` forecasts.
#' 
#' The [`get_cost_forecast`][costexplorer_get_cost_forecast] operation
#' supports only `DAILY` and `MONTHLY` granularities.
#' @param Filter The filters that you want to use to filter your forecast. Cost Explorer
#' API supports all of the Cost Explorer filters.
#' @param PredictionIntervalLevel Cost Explorer always returns the mean forecast as a single point. You
#' can request a prediction interval around the mean by specifying a
#' confidence level. The higher the confidence level, the more confident
#' Cost Explorer is about the actual value falling in the prediction
#' interval. Higher confidence levels result in wider prediction intervals.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Total = list(
#'     Amount = "string",
#'     Unit = "string"
#'   ),
#'   ForecastResultsByTime = list(
#'     list(
#'       TimePeriod = list(
#'         Start = "string",
#'         End = "string"
#'       ),
#'       MeanValue = "string",
#'       PredictionIntervalLowerBound = "string",
#'       PredictionIntervalUpperBound = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_cost_forecast(
#'   TimePeriod = list(
#'     Start = "string",
#'     End = "string"
#'   ),
#'   Metric = "BLENDED_COST"|"UNBLENDED_COST"|"AMORTIZED_COST"|"NET_UNBLENDED_COST"|"NET_AMORTIZED_COST"|"USAGE_QUANTITY"|"NORMALIZED_USAGE_AMOUNT",
#'   Granularity = "DAILY"|"MONTHLY"|"HOURLY",
#'   Filter = list(
#'     Or = list(
#'       list()
#'     ),
#'     And = list(
#'       list()
#'     ),
#'     Not = list(),
#'     Dimensions = list(
#'       Key = "AZ"|"INSTANCE_TYPE"|"LINKED_ACCOUNT"|"LINKED_ACCOUNT_NAME"|"OPERATION"|"PURCHASE_TYPE"|"REGION"|"SERVICE"|"SERVICE_CODE"|"USAGE_TYPE"|"USAGE_TYPE_GROUP"|"RECORD_TYPE"|"OPERATING_SYSTEM"|"TENANCY"|"SCOPE"|"PLATFORM"|"SUBSCRIPTION_ID"|"LEGAL_ENTITY_NAME"|"DEPLOYMENT_OPTION"|"DATABASE_ENGINE"|"CACHE_ENGINE"|"INSTANCE_TYPE_FAMILY"|"BILLING_ENTITY"|"RESERVATION_ID"|"RESOURCE_ID"|"RIGHTSIZING_TYPE"|"SAVINGS_PLANS_TYPE"|"SAVINGS_PLAN_ARN"|"PAYMENT_OPTION"|"AGREEMENT_END_DATE_TIME_AFTER"|"AGREEMENT_END_DATE_TIME_BEFORE",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     ),
#'     Tags = list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     ),
#'     CostCategories = list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     )
#'   ),
#'   PredictionIntervalLevel = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname costexplorer_get_cost_forecast
costexplorer_get_cost_forecast <- function(TimePeriod, Metric, Granularity, Filter = NULL, PredictionIntervalLevel = NULL) {
  op <- new_operation(
    name = "GetCostForecast",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$get_cost_forecast_input(TimePeriod = TimePeriod, Metric = Metric, Granularity = Granularity, Filter = Filter, PredictionIntervalLevel = PredictionIntervalLevel)
  output <- .costexplorer$get_cost_forecast_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$get_cost_forecast <- costexplorer_get_cost_forecast

#' Retrieves all available filter values for a specified filter over a
#' period of time
#'
#' @description
#' Retrieves all available filter values for a specified filter over a
#' period of time. You can search the dimension values for an arbitrary
#' string.
#'
#' @usage
#' costexplorer_get_dimension_values(SearchString, TimePeriod, Dimension,
#'   Context, Filter, SortBy, MaxResults, NextPageToken)
#'
#' @param SearchString The value that you want to search the filter values for.
#' @param TimePeriod &#91;required&#93; The start and end dates for retrieving the dimension values. The start
#' date is inclusive, but the end date is exclusive. For example, if
#' `start` is `2017-01-01` and `end` is `2017-05-01`, then the cost and
#' usage data is retrieved from `2017-01-01` up to and including
#' `2017-04-30` but not including `2017-05-01`.
#' @param Dimension &#91;required&#93; The name of the dimension. Each `Dimension` is available for a different
#' `Context`. For more information, see `Context`.
#' @param Context The context for the call to
#' [`get_dimension_values`][costexplorer_get_dimension_values]. This can be
#' `RESERVATIONS` or `COST_AND_USAGE`. The default value is
#' `COST_AND_USAGE`. If the context is set to `RESERVATIONS`, the resulting
#' dimension values can be used in the
#' [`get_reservation_utilization`][costexplorer_get_reservation_utilization]
#' operation. If the context is set to `COST_AND_USAGE`, the resulting
#' dimension values can be used in the
#' [`get_cost_and_usage`][costexplorer_get_cost_and_usage] operation.
#' 
#' If you set the context to `COST_AND_USAGE`, you can use the following
#' dimensions for searching:
#' 
#' -   AZ - The Availability Zone. An example is `us-east-1a`.
#' 
#' -   DATABASE_ENGINE - The Amazon Relational Database Service database.
#'     Examples are Aurora or MySQL.
#' 
#' -   INSTANCE_TYPE - The type of Amazon EC2 instance. An example is
#'     `m4.xlarge`.
#' 
#' -   LEGAL_ENTITY_NAME - The name of the organization that sells you
#'     AWS services, such as Amazon Web Services.
#' 
#' -   LINKED_ACCOUNT - The description in the attribute map that includes
#'     the full name of the member account. The value field contains the
#'     AWS ID of the member account.
#' 
#' -   OPERATING_SYSTEM - The operating system. Examples are Windows or
#'     Linux.
#' 
#' -   OPERATION - The action performed. Examples include `RunInstance` and
#'     `CreateBucket`.
#' 
#' -   PLATFORM - The Amazon EC2 operating system. Examples are Windows or
#'     Linux.
#' 
#' -   PURCHASE_TYPE - The reservation type of the purchase to which this
#'     usage is related. Examples include On-Demand Instances and Standard
#'     Reserved Instances.
#' 
#' -   SERVICE - The AWS service such as Amazon DynamoDB.
#' 
#' -   USAGE_TYPE - The type of usage. An example is
#'     DataTransfer-In-Bytes. The response for the
#'     [`get_dimension_values`][costexplorer_get_dimension_values]
#'     operation includes a unit attribute. Examples include GB and Hrs.
#' 
#' -   USAGE_TYPE_GROUP - The grouping of common usage types. An example
#'     is Amazon EC2: CloudWatch – Alarms. The response for this operation
#'     includes a unit attribute.
#' 
#' -   REGION - The AWS Region.
#' 
#' -   RECORD_TYPE - The different types of charges such as RI fees, usage
#'     costs, tax refunds, and credits.
#' 
#' -   RESOURCE_ID - The unique identifier of the resource. ResourceId is
#'     an opt-in feature only available for last 14 days for EC2-Compute
#'     Service.
#' 
#' If you set the context to `RESERVATIONS`, you can use the following
#' dimensions for searching:
#' 
#' -   AZ - The Availability Zone. An example is `us-east-1a`.
#' 
#' -   CACHE_ENGINE - The Amazon ElastiCache operating system. Examples
#'     are Windows or Linux.
#' 
#' -   DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service
#'     deployments. Valid values are `SingleAZ` and `MultiAZ`.
#' 
#' -   INSTANCE_TYPE - The type of Amazon EC2 instance. An example is
#'     `m4.xlarge`.
#' 
#' -   LINKED_ACCOUNT - The description in the attribute map that includes
#'     the full name of the member account. The value field contains the
#'     AWS ID of the member account.
#' 
#' -   PLATFORM - The Amazon EC2 operating system. Examples are Windows or
#'     Linux.
#' 
#' -   REGION - The AWS Region.
#' 
#' -   SCOPE (Utilization only) - The scope of a Reserved Instance (RI).
#'     Values are regional or a single Availability Zone.
#' 
#' -   TAG (Coverage only) - The tags that are associated with a Reserved
#'     Instance (RI).
#' 
#' -   TENANCY - The tenancy of a resource. Examples are shared or
#'     dedicated.
#' 
#' If you set the context to `SAVINGS_PLANS`, you can use the following
#' dimensions for searching:
#' 
#' -   SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or
#'     Compute)
#' 
#' -   PAYMENT_OPTION - Payment option for the given Savings Plans (for
#'     example, All Upfront)
#' 
#' -   REGION - The AWS Region.
#' 
#' -   INSTANCE_TYPE_FAMILY - The family of instances (For example, `m5`)
#' 
#' -   LINKED_ACCOUNT - The description in the attribute map that includes
#'     the full name of the member account. The value field contains the
#'     AWS ID of the member account.
#' 
#' -   SAVINGS_PLAN_ARN - The unique identifier for your Savings Plan
#' @param Filter 
#' @param SortBy The value by which you want to sort the data.
#' 
#' The key represents cost and usage metrics. The following values are
#' supported:
#' 
#' -   `BlendedCost`
#' 
#' -   `UnblendedCost`
#' 
#' -   `AmortizedCost`
#' 
#' -   `NetAmortizedCost`
#' 
#' -   `NetUnblendedCost`
#' 
#' -   `UsageQuantity`
#' 
#' -   `NormalizedUsageAmount`
#' 
#' Supported values for `SortOrder` are `ASCENDING` or `DESCENDING`.
#' 
#' When you specify a `SortBy` paramater, the context must be
#' `COST_AND_USAGE`. Further, when using `SortBy`, `NextPageToken` and
#' `SearchString` are not supported.
#' @param MaxResults This field is only used when SortBy is provided in the request. The
#' maximum number of objects that to be returned for this request. If
#' MaxResults is not specified with SortBy, the request will return 1000
#' results as the default value for this parameter.
#' @param NextPageToken The token to retrieve the next set of results. AWS provides the token
#' when the response from a previous call has more results than the maximum
#' page size.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   DimensionValues = list(
#'     list(
#'       Value = "string",
#'       Attributes = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   ReturnSize = 123,
#'   TotalSize = 123,
#'   NextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_dimension_values(
#'   SearchString = "string",
#'   TimePeriod = list(
#'     Start = "string",
#'     End = "string"
#'   ),
#'   Dimension = "AZ"|"INSTANCE_TYPE"|"LINKED_ACCOUNT"|"LINKED_ACCOUNT_NAME"|"OPERATION"|"PURCHASE_TYPE"|"REGION"|"SERVICE"|"SERVICE_CODE"|"USAGE_TYPE"|"USAGE_TYPE_GROUP"|"RECORD_TYPE"|"OPERATING_SYSTEM"|"TENANCY"|"SCOPE"|"PLATFORM"|"SUBSCRIPTION_ID"|"LEGAL_ENTITY_NAME"|"DEPLOYMENT_OPTION"|"DATABASE_ENGINE"|"CACHE_ENGINE"|"INSTANCE_TYPE_FAMILY"|"BILLING_ENTITY"|"RESERVATION_ID"|"RESOURCE_ID"|"RIGHTSIZING_TYPE"|"SAVINGS_PLANS_TYPE"|"SAVINGS_PLAN_ARN"|"PAYMENT_OPTION"|"AGREEMENT_END_DATE_TIME_AFTER"|"AGREEMENT_END_DATE_TIME_BEFORE",
#'   Context = "COST_AND_USAGE"|"RESERVATIONS"|"SAVINGS_PLANS",
#'   Filter = list(
#'     Or = list(
#'       list()
#'     ),
#'     And = list(
#'       list()
#'     ),
#'     Not = list(),
#'     Dimensions = list(
#'       Key = "AZ"|"INSTANCE_TYPE"|"LINKED_ACCOUNT"|"LINKED_ACCOUNT_NAME"|"OPERATION"|"PURCHASE_TYPE"|"REGION"|"SERVICE"|"SERVICE_CODE"|"USAGE_TYPE"|"USAGE_TYPE_GROUP"|"RECORD_TYPE"|"OPERATING_SYSTEM"|"TENANCY"|"SCOPE"|"PLATFORM"|"SUBSCRIPTION_ID"|"LEGAL_ENTITY_NAME"|"DEPLOYMENT_OPTION"|"DATABASE_ENGINE"|"CACHE_ENGINE"|"INSTANCE_TYPE_FAMILY"|"BILLING_ENTITY"|"RESERVATION_ID"|"RESOURCE_ID"|"RIGHTSIZING_TYPE"|"SAVINGS_PLANS_TYPE"|"SAVINGS_PLAN_ARN"|"PAYMENT_OPTION"|"AGREEMENT_END_DATE_TIME_AFTER"|"AGREEMENT_END_DATE_TIME_BEFORE",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     ),
#'     Tags = list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     ),
#'     CostCategories = list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     )
#'   ),
#'   SortBy = list(
#'     list(
#'       Key = "string",
#'       SortOrder = "ASCENDING"|"DESCENDING"
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextPageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname costexplorer_get_dimension_values
costexplorer_get_dimension_values <- function(SearchString = NULL, TimePeriod, Dimension, Context = NULL, Filter = NULL, SortBy = NULL, MaxResults = NULL, NextPageToken = NULL) {
  op <- new_operation(
    name = "GetDimensionValues",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$get_dimension_values_input(SearchString = SearchString, TimePeriod = TimePeriod, Dimension = Dimension, Context = Context, Filter = Filter, SortBy = SortBy, MaxResults = MaxResults, NextPageToken = NextPageToken)
  output <- .costexplorer$get_dimension_values_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$get_dimension_values <- costexplorer_get_dimension_values

#' Retrieves the reservation coverage for your account
#'
#' @description
#' Retrieves the reservation coverage for your account. This enables you to
#' see how much of your Amazon Elastic Compute Cloud, Amazon ElastiCache,
#' Amazon Relational Database Service, or Amazon Redshift usage is covered
#' by a reservation. An organization's management account can see the
#' coverage of the associated member accounts. This supports dimensions,
#' Cost Categories, and nested expressions. For any time period, you can
#' filter data about reservation usage by the following dimensions:
#' 
#' -   AZ
#' 
#' -   CACHE_ENGINE
#' 
#' -   DATABASE_ENGINE
#' 
#' -   DEPLOYMENT_OPTION
#' 
#' -   INSTANCE_TYPE
#' 
#' -   LINKED_ACCOUNT
#' 
#' -   OPERATING_SYSTEM
#' 
#' -   PLATFORM
#' 
#' -   REGION
#' 
#' -   SERVICE
#' 
#' -   TAG
#' 
#' -   TENANCY
#' 
#' To determine valid values for a dimension, use the
#' [`get_dimension_values`][costexplorer_get_dimension_values] operation.
#'
#' @usage
#' costexplorer_get_reservation_coverage(TimePeriod, GroupBy, Granularity,
#'   Filter, Metrics, NextPageToken, SortBy, MaxResults)
#'
#' @param TimePeriod &#91;required&#93; The start and end dates of the period that you want to retrieve data
#' about reservation coverage for. You can retrieve data for a maximum of
#' 13 months: the last 12 months and the current month. The start date is
#' inclusive, but the end date is exclusive. For example, if `start` is
#' `2017-01-01` and `end` is `2017-05-01`, then the cost and usage data is
#' retrieved from `2017-01-01` up to and including `2017-04-30` but not
#' including `2017-05-01`.
#' @param GroupBy You can group the data by the following attributes:
#' 
#' -   AZ
#' 
#' -   CACHE_ENGINE
#' 
#' -   DATABASE_ENGINE
#' 
#' -   DEPLOYMENT_OPTION
#' 
#' -   INSTANCE_TYPE
#' 
#' -   LINKED_ACCOUNT
#' 
#' -   OPERATING_SYSTEM
#' 
#' -   PLATFORM
#' 
#' -   REGION
#' 
#' -   TENANCY
#' @param Granularity The granularity of the AWS cost data for the reservation. Valid values
#' are `MONTHLY` and `DAILY`.
#' 
#' If `GroupBy` is set, `Granularity` can't be set. If `Granularity` isn't
#' set, the response object doesn't include `Granularity`, either `MONTHLY`
#' or `DAILY`.
#' 
#' The [`get_reservation_coverage`][costexplorer_get_reservation_coverage]
#' operation supports only `DAILY` and `MONTHLY` granularities.
#' @param Filter Filters utilization data by dimensions. You can filter by the following
#' dimensions:
#' 
#' -   AZ
#' 
#' -   CACHE_ENGINE
#' 
#' -   DATABASE_ENGINE
#' 
#' -   DEPLOYMENT_OPTION
#' 
#' -   INSTANCE_TYPE
#' 
#' -   LINKED_ACCOUNT
#' 
#' -   OPERATING_SYSTEM
#' 
#' -   PLATFORM
#' 
#' -   REGION
#' 
#' -   SERVICE
#' 
#' -   TAG
#' 
#' -   TENANCY
#' 
#' [`get_reservation_coverage`][costexplorer_get_reservation_coverage] uses
#' the same
#' [Expression](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html)
#' object as the other operations, but only `AND` is supported among each
#' dimension. You can nest only one level deep. If there are multiple
#' values for a dimension, they are OR'd together.
#' 
#' If you don't provide a `SERVICE` filter, Cost Explorer defaults to EC2.
#' 
#' Cost category is also supported.
#' @param Metrics The measurement that you want your reservation coverage reported in.
#' 
#' Valid values are `Hour`, `Unit`, and `Cost`. You can use multiple values
#' in a request.
#' @param NextPageToken The token to retrieve the next set of results. AWS provides the token
#' when the response from a previous call has more results than the maximum
#' page size.
#' @param SortBy The value by which you want to sort the data.
#' 
#' The following values are supported for `Key`:
#' 
#' -   `OnDemandCost`
#' 
#' -   `CoverageHoursPercentage`
#' 
#' -   `OnDemandHours`
#' 
#' -   `ReservedHours`
#' 
#' -   `TotalRunningHours`
#' 
#' -   `CoverageNormalizedUnitsPercentage`
#' 
#' -   `OnDemandNormalizedUnits`
#' 
#' -   `ReservedNormalizedUnits`
#' 
#' -   `TotalRunningNormalizedUnits`
#' 
#' -   `Time`
#' 
#' Supported values for `SortOrder` are `ASCENDING` or `DESCENDING`.
#' @param MaxResults The maximum number of objects that you returned for this request. If
#' more objects are available, in the response, AWS provides a
#' NextPageToken value that you can use in a subsequent call to get the
#' next batch of objects.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   CoveragesByTime = list(
#'     list(
#'       TimePeriod = list(
#'         Start = "string",
#'         End = "string"
#'       ),
#'       Groups = list(
#'         list(
#'           Attributes = list(
#'             "string"
#'           ),
#'           Coverage = list(
#'             CoverageHours = list(
#'               OnDemandHours = "string",
#'               ReservedHours = "string",
#'               TotalRunningHours = "string",
#'               CoverageHoursPercentage = "string"
#'             ),
#'             CoverageNormalizedUnits = list(
#'               OnDemandNormalizedUnits = "string",
#'               ReservedNormalizedUnits = "string",
#'               TotalRunningNormalizedUnits = "string",
#'               CoverageNormalizedUnitsPercentage = "string"
#'             ),
#'             CoverageCost = list(
#'               OnDemandCost = "string"
#'             )
#'           )
#'         )
#'       ),
#'       Total = list(
#'         CoverageHours = list(
#'           OnDemandHours = "string",
#'           ReservedHours = "string",
#'           TotalRunningHours = "string",
#'           CoverageHoursPercentage = "string"
#'         ),
#'         CoverageNormalizedUnits = list(
#'           OnDemandNormalizedUnits = "string",
#'           ReservedNormalizedUnits = "string",
#'           TotalRunningNormalizedUnits = "string",
#'           CoverageNormalizedUnitsPercentage = "string"
#'         ),
#'         CoverageCost = list(
#'           OnDemandCost = "string"
#'         )
#'       )
#'     )
#'   ),
#'   Total = list(
#'     CoverageHours = list(
#'       OnDemandHours = "string",
#'       ReservedHours = "string",
#'       TotalRunningHours = "string",
#'       CoverageHoursPercentage = "string"
#'     ),
#'     CoverageNormalizedUnits = list(
#'       OnDemandNormalizedUnits = "string",
#'       ReservedNormalizedUnits = "string",
#'       TotalRunningNormalizedUnits = "string",
#'       CoverageNormalizedUnitsPercentage = "string"
#'     ),
#'     CoverageCost = list(
#'       OnDemandCost = "string"
#'     )
#'   ),
#'   NextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_reservation_coverage(
#'   TimePeriod = list(
#'     Start = "string",
#'     End = "string"
#'   ),
#'   GroupBy = list(
#'     list(
#'       Type = "DIMENSION"|"TAG"|"COST_CATEGORY",
#'       Key = "string"
#'     )
#'   ),
#'   Granularity = "DAILY"|"MONTHLY"|"HOURLY",
#'   Filter = list(
#'     Or = list(
#'       list()
#'     ),
#'     And = list(
#'       list()
#'     ),
#'     Not = list(),
#'     Dimensions = list(
#'       Key = "AZ"|"INSTANCE_TYPE"|"LINKED_ACCOUNT"|"LINKED_ACCOUNT_NAME"|"OPERATION"|"PURCHASE_TYPE"|"REGION"|"SERVICE"|"SERVICE_CODE"|"USAGE_TYPE"|"USAGE_TYPE_GROUP"|"RECORD_TYPE"|"OPERATING_SYSTEM"|"TENANCY"|"SCOPE"|"PLATFORM"|"SUBSCRIPTION_ID"|"LEGAL_ENTITY_NAME"|"DEPLOYMENT_OPTION"|"DATABASE_ENGINE"|"CACHE_ENGINE"|"INSTANCE_TYPE_FAMILY"|"BILLING_ENTITY"|"RESERVATION_ID"|"RESOURCE_ID"|"RIGHTSIZING_TYPE"|"SAVINGS_PLANS_TYPE"|"SAVINGS_PLAN_ARN"|"PAYMENT_OPTION"|"AGREEMENT_END_DATE_TIME_AFTER"|"AGREEMENT_END_DATE_TIME_BEFORE",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     ),
#'     Tags = list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     ),
#'     CostCategories = list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     )
#'   ),
#'   Metrics = list(
#'     "string"
#'   ),
#'   NextPageToken = "string",
#'   SortBy = list(
#'     Key = "string",
#'     SortOrder = "ASCENDING"|"DESCENDING"
#'   ),
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname costexplorer_get_reservation_coverage
costexplorer_get_reservation_coverage <- function(TimePeriod, GroupBy = NULL, Granularity = NULL, Filter = NULL, Metrics = NULL, NextPageToken = NULL, SortBy = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetReservationCoverage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$get_reservation_coverage_input(TimePeriod = TimePeriod, GroupBy = GroupBy, Granularity = Granularity, Filter = Filter, Metrics = Metrics, NextPageToken = NextPageToken, SortBy = SortBy, MaxResults = MaxResults)
  output <- .costexplorer$get_reservation_coverage_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$get_reservation_coverage <- costexplorer_get_reservation_coverage

#' Gets recommendations for which reservations to purchase
#'
#' @description
#' Gets recommendations for which reservations to purchase. These
#' recommendations could help you reduce your costs. Reservations provide a
#' discounted hourly rate (up to 75%) compared to On-Demand pricing.
#' 
#' AWS generates your recommendations by identifying your On-Demand usage
#' during a specific time period and collecting your usage into categories
#' that are eligible for a reservation. After AWS has these categories, it
#' simulates every combination of reservations in each category of usage to
#' identify the best number of each type of RI to purchase to maximize your
#' estimated savings.
#' 
#' For example, AWS automatically aggregates your Amazon EC2 Linux, shared
#' tenancy, and c4 family usage in the US West (Oregon) Region and
#' recommends that you buy size-flexible regional reservations to apply to
#' the c4 family usage. AWS recommends the smallest size instance in an
#' instance family. This makes it easier to purchase a size-flexible RI.
#' AWS also shows the equal number of normalized units so that you can
#' purchase any instance size that you want. For this example, your RI
#' recommendation would be for `c4.large` because that is the smallest size
#' instance in the c4 instance family.
#'
#' @usage
#' costexplorer_get_reservation_purchase_recommendation(AccountId, Service,
#'   Filter, AccountScope, LookbackPeriodInDays, TermInYears, PaymentOption,
#'   ServiceSpecification, PageSize, NextPageToken)
#'
#' @param AccountId The account ID that is associated with the recommendation.
#' @param Service &#91;required&#93; The specific service that you want recommendations for.
#' @param Filter 
#' @param AccountScope The account scope that you want your recommendations for. Amazon Web
#' Services calculates recommendations including the management account and
#' member accounts if the value is set to `PAYER`. If the value is
#' `LINKED`, recommendations are calculated for individual member accounts
#' only.
#' @param LookbackPeriodInDays The number of previous days that you want AWS to consider when it
#' calculates your recommendations.
#' @param TermInYears The reservation term that you want recommendations for.
#' @param PaymentOption The reservation purchase option that you want recommendations for.
#' @param ServiceSpecification The hardware specifications for the service instances that you want
#' recommendations for, such as standard or convertible Amazon EC2
#' instances.
#' @param PageSize The number of recommendations that you want returned in a single
#' response object.
#' @param NextPageToken The pagination token that indicates the next set of results that you
#' want to retrieve.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Metadata = list(
#'     RecommendationId = "string",
#'     GenerationTimestamp = "string"
#'   ),
#'   Recommendations = list(
#'     list(
#'       AccountScope = "PAYER"|"LINKED",
#'       LookbackPeriodInDays = "SEVEN_DAYS"|"THIRTY_DAYS"|"SIXTY_DAYS",
#'       TermInYears = "ONE_YEAR"|"THREE_YEARS",
#'       PaymentOption = "NO_UPFRONT"|"PARTIAL_UPFRONT"|"ALL_UPFRONT"|"LIGHT_UTILIZATION"|"MEDIUM_UTILIZATION"|"HEAVY_UTILIZATION",
#'       ServiceSpecification = list(
#'         EC2Specification = list(
#'           OfferingClass = "STANDARD"|"CONVERTIBLE"
#'         )
#'       ),
#'       RecommendationDetails = list(
#'         list(
#'           AccountId = "string",
#'           InstanceDetails = list(
#'             EC2InstanceDetails = list(
#'               Family = "string",
#'               InstanceType = "string",
#'               Region = "string",
#'               AvailabilityZone = "string",
#'               Platform = "string",
#'               Tenancy = "string",
#'               CurrentGeneration = TRUE|FALSE,
#'               SizeFlexEligible = TRUE|FALSE
#'             ),
#'             RDSInstanceDetails = list(
#'               Family = "string",
#'               InstanceType = "string",
#'               Region = "string",
#'               DatabaseEngine = "string",
#'               DatabaseEdition = "string",
#'               DeploymentOption = "string",
#'               LicenseModel = "string",
#'               CurrentGeneration = TRUE|FALSE,
#'               SizeFlexEligible = TRUE|FALSE
#'             ),
#'             RedshiftInstanceDetails = list(
#'               Family = "string",
#'               NodeType = "string",
#'               Region = "string",
#'               CurrentGeneration = TRUE|FALSE,
#'               SizeFlexEligible = TRUE|FALSE
#'             ),
#'             ElastiCacheInstanceDetails = list(
#'               Family = "string",
#'               NodeType = "string",
#'               Region = "string",
#'               ProductDescription = "string",
#'               CurrentGeneration = TRUE|FALSE,
#'               SizeFlexEligible = TRUE|FALSE
#'             ),
#'             ESInstanceDetails = list(
#'               InstanceClass = "string",
#'               InstanceSize = "string",
#'               Region = "string",
#'               CurrentGeneration = TRUE|FALSE,
#'               SizeFlexEligible = TRUE|FALSE
#'             )
#'           ),
#'           RecommendedNumberOfInstancesToPurchase = "string",
#'           RecommendedNormalizedUnitsToPurchase = "string",
#'           MinimumNumberOfInstancesUsedPerHour = "string",
#'           MinimumNormalizedUnitsUsedPerHour = "string",
#'           MaximumNumberOfInstancesUsedPerHour = "string",
#'           MaximumNormalizedUnitsUsedPerHour = "string",
#'           AverageNumberOfInstancesUsedPerHour = "string",
#'           AverageNormalizedUnitsUsedPerHour = "string",
#'           AverageUtilization = "string",
#'           EstimatedBreakEvenInMonths = "string",
#'           CurrencyCode = "string",
#'           EstimatedMonthlySavingsAmount = "string",
#'           EstimatedMonthlySavingsPercentage = "string",
#'           EstimatedMonthlyOnDemandCost = "string",
#'           EstimatedReservationCostForLookbackPeriod = "string",
#'           UpfrontCost = "string",
#'           RecurringStandardMonthlyCost = "string"
#'         )
#'       ),
#'       RecommendationSummary = list(
#'         TotalEstimatedMonthlySavingsAmount = "string",
#'         TotalEstimatedMonthlySavingsPercentage = "string",
#'         CurrencyCode = "string"
#'       )
#'     )
#'   ),
#'   NextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_reservation_purchase_recommendation(
#'   AccountId = "string",
#'   Service = "string",
#'   Filter = list(
#'     Or = list(
#'       list()
#'     ),
#'     And = list(
#'       list()
#'     ),
#'     Not = list(),
#'     Dimensions = list(
#'       Key = "AZ"|"INSTANCE_TYPE"|"LINKED_ACCOUNT"|"LINKED_ACCOUNT_NAME"|"OPERATION"|"PURCHASE_TYPE"|"REGION"|"SERVICE"|"SERVICE_CODE"|"USAGE_TYPE"|"USAGE_TYPE_GROUP"|"RECORD_TYPE"|"OPERATING_SYSTEM"|"TENANCY"|"SCOPE"|"PLATFORM"|"SUBSCRIPTION_ID"|"LEGAL_ENTITY_NAME"|"DEPLOYMENT_OPTION"|"DATABASE_ENGINE"|"CACHE_ENGINE"|"INSTANCE_TYPE_FAMILY"|"BILLING_ENTITY"|"RESERVATION_ID"|"RESOURCE_ID"|"RIGHTSIZING_TYPE"|"SAVINGS_PLANS_TYPE"|"SAVINGS_PLAN_ARN"|"PAYMENT_OPTION"|"AGREEMENT_END_DATE_TIME_AFTER"|"AGREEMENT_END_DATE_TIME_BEFORE",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     ),
#'     Tags = list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     ),
#'     CostCategories = list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     )
#'   ),
#'   AccountScope = "PAYER"|"LINKED",
#'   LookbackPeriodInDays = "SEVEN_DAYS"|"THIRTY_DAYS"|"SIXTY_DAYS",
#'   TermInYears = "ONE_YEAR"|"THREE_YEARS",
#'   PaymentOption = "NO_UPFRONT"|"PARTIAL_UPFRONT"|"ALL_UPFRONT"|"LIGHT_UTILIZATION"|"MEDIUM_UTILIZATION"|"HEAVY_UTILIZATION",
#'   ServiceSpecification = list(
#'     EC2Specification = list(
#'       OfferingClass = "STANDARD"|"CONVERTIBLE"
#'     )
#'   ),
#'   PageSize = 123,
#'   NextPageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname costexplorer_get_reservation_purchase_recommendation
costexplorer_get_reservation_purchase_recommendation <- function(AccountId = NULL, Service, Filter = NULL, AccountScope = NULL, LookbackPeriodInDays = NULL, TermInYears = NULL, PaymentOption = NULL, ServiceSpecification = NULL, PageSize = NULL, NextPageToken = NULL) {
  op <- new_operation(
    name = "GetReservationPurchaseRecommendation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$get_reservation_purchase_recommendation_input(AccountId = AccountId, Service = Service, Filter = Filter, AccountScope = AccountScope, LookbackPeriodInDays = LookbackPeriodInDays, TermInYears = TermInYears, PaymentOption = PaymentOption, ServiceSpecification = ServiceSpecification, PageSize = PageSize, NextPageToken = NextPageToken)
  output <- .costexplorer$get_reservation_purchase_recommendation_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$get_reservation_purchase_recommendation <- costexplorer_get_reservation_purchase_recommendation

#' Retrieves the reservation utilization for your account
#'
#' @description
#' Retrieves the reservation utilization for your account. Management
#' account in an organization have access to member accounts. You can
#' filter data by dimensions in a time period. You can use
#' [`get_dimension_values`][costexplorer_get_dimension_values] to determine
#' the possible dimension values. Currently, you can group only by
#' `SUBSCRIPTION_ID`.
#'
#' @usage
#' costexplorer_get_reservation_utilization(TimePeriod, GroupBy,
#'   Granularity, Filter, SortBy, NextPageToken, MaxResults)
#'
#' @param TimePeriod &#91;required&#93; Sets the start and end dates for retrieving RI utilization. The start
#' date is inclusive, but the end date is exclusive. For example, if
#' `start` is `2017-01-01` and `end` is `2017-05-01`, then the cost and
#' usage data is retrieved from `2017-01-01` up to and including
#' `2017-04-30` but not including `2017-05-01`.
#' @param GroupBy Groups only by `SUBSCRIPTION_ID`. Metadata is included.
#' @param Granularity If `GroupBy` is set, `Granularity` can't be set. If `Granularity` isn't
#' set, the response object doesn't include `Granularity`, either `MONTHLY`
#' or `DAILY`. If both `GroupBy` and `Granularity` aren't set,
#' [`get_reservation_utilization`][costexplorer_get_reservation_utilization]
#' defaults to `DAILY`.
#' 
#' The
#' [`get_reservation_utilization`][costexplorer_get_reservation_utilization]
#' operation supports only `DAILY` and `MONTHLY` granularities.
#' @param Filter Filters utilization data by dimensions. You can filter by the following
#' dimensions:
#' 
#' -   AZ
#' 
#' -   CACHE_ENGINE
#' 
#' -   DEPLOYMENT_OPTION
#' 
#' -   INSTANCE_TYPE
#' 
#' -   LINKED_ACCOUNT
#' 
#' -   OPERATING_SYSTEM
#' 
#' -   PLATFORM
#' 
#' -   REGION
#' 
#' -   SERVICE
#' 
#' -   SCOPE
#' 
#' -   TENANCY
#' 
#' [`get_reservation_utilization`][costexplorer_get_reservation_utilization]
#' uses the same
#' [Expression](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html)
#' object as the other operations, but only `AND` is supported among each
#' dimension, and nesting is supported up to only one level deep. If there
#' are multiple values for a dimension, they are OR'd together.
#' @param SortBy The value by which you want to sort the data.
#' 
#' The following values are supported for `Key`:
#' 
#' -   `UtilizationPercentage`
#' 
#' -   `UtilizationPercentageInUnits`
#' 
#' -   `PurchasedHours`
#' 
#' -   `PurchasedUnits`
#' 
#' -   `TotalActualHours`
#' 
#' -   `TotalActualUnits`
#' 
#' -   `UnusedHours`
#' 
#' -   `UnusedUnits`
#' 
#' -   `OnDemandCostOfRIHoursUsed`
#' 
#' -   `NetRISavings`
#' 
#' -   `TotalPotentialRISavings`
#' 
#' -   `AmortizedUpfrontFee`
#' 
#' -   `AmortizedRecurringFee`
#' 
#' -   `TotalAmortizedFee`
#' 
#' -   `RICostForUnusedHours`
#' 
#' -   `RealizedSavings`
#' 
#' -   `UnrealizedSavings`
#' 
#' Supported values for `SortOrder` are `ASCENDING` or `DESCENDING`.
#' @param NextPageToken The token to retrieve the next set of results. AWS provides the token
#' when the response from a previous call has more results than the maximum
#' page size.
#' @param MaxResults The maximum number of objects that you returned for this request. If
#' more objects are available, in the response, AWS provides a
#' NextPageToken value that you can use in a subsequent call to get the
#' next batch of objects.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   UtilizationsByTime = list(
#'     list(
#'       TimePeriod = list(
#'         Start = "string",
#'         End = "string"
#'       ),
#'       Groups = list(
#'         list(
#'           Key = "string",
#'           Value = "string",
#'           Attributes = list(
#'             "string"
#'           ),
#'           Utilization = list(
#'             UtilizationPercentage = "string",
#'             UtilizationPercentageInUnits = "string",
#'             PurchasedHours = "string",
#'             PurchasedUnits = "string",
#'             TotalActualHours = "string",
#'             TotalActualUnits = "string",
#'             UnusedHours = "string",
#'             UnusedUnits = "string",
#'             OnDemandCostOfRIHoursUsed = "string",
#'             NetRISavings = "string",
#'             TotalPotentialRISavings = "string",
#'             AmortizedUpfrontFee = "string",
#'             AmortizedRecurringFee = "string",
#'             TotalAmortizedFee = "string",
#'             RICostForUnusedHours = "string",
#'             RealizedSavings = "string",
#'             UnrealizedSavings = "string"
#'           )
#'         )
#'       ),
#'       Total = list(
#'         UtilizationPercentage = "string",
#'         UtilizationPercentageInUnits = "string",
#'         PurchasedHours = "string",
#'         PurchasedUnits = "string",
#'         TotalActualHours = "string",
#'         TotalActualUnits = "string",
#'         UnusedHours = "string",
#'         UnusedUnits = "string",
#'         OnDemandCostOfRIHoursUsed = "string",
#'         NetRISavings = "string",
#'         TotalPotentialRISavings = "string",
#'         AmortizedUpfrontFee = "string",
#'         AmortizedRecurringFee = "string",
#'         TotalAmortizedFee = "string",
#'         RICostForUnusedHours = "string",
#'         RealizedSavings = "string",
#'         UnrealizedSavings = "string"
#'       )
#'     )
#'   ),
#'   Total = list(
#'     UtilizationPercentage = "string",
#'     UtilizationPercentageInUnits = "string",
#'     PurchasedHours = "string",
#'     PurchasedUnits = "string",
#'     TotalActualHours = "string",
#'     TotalActualUnits = "string",
#'     UnusedHours = "string",
#'     UnusedUnits = "string",
#'     OnDemandCostOfRIHoursUsed = "string",
#'     NetRISavings = "string",
#'     TotalPotentialRISavings = "string",
#'     AmortizedUpfrontFee = "string",
#'     AmortizedRecurringFee = "string",
#'     TotalAmortizedFee = "string",
#'     RICostForUnusedHours = "string",
#'     RealizedSavings = "string",
#'     UnrealizedSavings = "string"
#'   ),
#'   NextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_reservation_utilization(
#'   TimePeriod = list(
#'     Start = "string",
#'     End = "string"
#'   ),
#'   GroupBy = list(
#'     list(
#'       Type = "DIMENSION"|"TAG"|"COST_CATEGORY",
#'       Key = "string"
#'     )
#'   ),
#'   Granularity = "DAILY"|"MONTHLY"|"HOURLY",
#'   Filter = list(
#'     Or = list(
#'       list()
#'     ),
#'     And = list(
#'       list()
#'     ),
#'     Not = list(),
#'     Dimensions = list(
#'       Key = "AZ"|"INSTANCE_TYPE"|"LINKED_ACCOUNT"|"LINKED_ACCOUNT_NAME"|"OPERATION"|"PURCHASE_TYPE"|"REGION"|"SERVICE"|"SERVICE_CODE"|"USAGE_TYPE"|"USAGE_TYPE_GROUP"|"RECORD_TYPE"|"OPERATING_SYSTEM"|"TENANCY"|"SCOPE"|"PLATFORM"|"SUBSCRIPTION_ID"|"LEGAL_ENTITY_NAME"|"DEPLOYMENT_OPTION"|"DATABASE_ENGINE"|"CACHE_ENGINE"|"INSTANCE_TYPE_FAMILY"|"BILLING_ENTITY"|"RESERVATION_ID"|"RESOURCE_ID"|"RIGHTSIZING_TYPE"|"SAVINGS_PLANS_TYPE"|"SAVINGS_PLAN_ARN"|"PAYMENT_OPTION"|"AGREEMENT_END_DATE_TIME_AFTER"|"AGREEMENT_END_DATE_TIME_BEFORE",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     ),
#'     Tags = list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     ),
#'     CostCategories = list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     )
#'   ),
#'   SortBy = list(
#'     Key = "string",
#'     SortOrder = "ASCENDING"|"DESCENDING"
#'   ),
#'   NextPageToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname costexplorer_get_reservation_utilization
costexplorer_get_reservation_utilization <- function(TimePeriod, GroupBy = NULL, Granularity = NULL, Filter = NULL, SortBy = NULL, NextPageToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetReservationUtilization",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$get_reservation_utilization_input(TimePeriod = TimePeriod, GroupBy = GroupBy, Granularity = Granularity, Filter = Filter, SortBy = SortBy, NextPageToken = NextPageToken, MaxResults = MaxResults)
  output <- .costexplorer$get_reservation_utilization_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$get_reservation_utilization <- costexplorer_get_reservation_utilization

#' Creates recommendations that help you save cost by identifying idle and
#' underutilized Amazon EC2 instances
#'
#' @description
#' Creates recommendations that help you save cost by identifying idle and
#' underutilized Amazon EC2 instances.
#' 
#' Recommendations are generated to either downsize or terminate instances,
#' along with providing savings detail and metrics. For details on
#' calculation and function, see [Optimizing Your Cost with Rightsizing
#' Recommendations](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/ce-rightsizing.html)
#' in the *AWS Billing and Cost Management User Guide*.
#'
#' @usage
#' costexplorer_get_rightsizing_recommendation(Filter, Configuration,
#'   Service, PageSize, NextPageToken)
#'
#' @param Filter 
#' @param Configuration Enables you to customize recommendations across two attributes. You can
#' choose to view recommendations for instances within the same instance
#' families or across different instance families. You can also choose to
#' view your estimated savings associated with recommendations with
#' consideration of existing Savings Plans or RI benefits, or neither.
#' @param Service &#91;required&#93; The specific service that you want recommendations for. The only valid
#' value for
#' [`get_rightsizing_recommendation`][costexplorer_get_rightsizing_recommendation]
#' is "`AmazonEC2`".
#' @param PageSize The number of recommendations that you want returned in a single
#' response object.
#' @param NextPageToken The pagination token that indicates the next set of results that you
#' want to retrieve.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Metadata = list(
#'     RecommendationId = "string",
#'     GenerationTimestamp = "string",
#'     LookbackPeriodInDays = "SEVEN_DAYS"|"THIRTY_DAYS"|"SIXTY_DAYS",
#'     AdditionalMetadata = "string"
#'   ),
#'   Summary = list(
#'     TotalRecommendationCount = "string",
#'     EstimatedTotalMonthlySavingsAmount = "string",
#'     SavingsCurrencyCode = "string",
#'     SavingsPercentage = "string"
#'   ),
#'   RightsizingRecommendations = list(
#'     list(
#'       AccountId = "string",
#'       CurrentInstance = list(
#'         ResourceId = "string",
#'         InstanceName = "string",
#'         Tags = list(
#'           list(
#'             Key = "string",
#'             Values = list(
#'               "string"
#'             ),
#'             MatchOptions = list(
#'               "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'             )
#'           )
#'         ),
#'         ResourceDetails = list(
#'           EC2ResourceDetails = list(
#'             HourlyOnDemandRate = "string",
#'             InstanceType = "string",
#'             Platform = "string",
#'             Region = "string",
#'             Sku = "string",
#'             Memory = "string",
#'             NetworkPerformance = "string",
#'             Storage = "string",
#'             Vcpu = "string"
#'           )
#'         ),
#'         ResourceUtilization = list(
#'           EC2ResourceUtilization = list(
#'             MaxCpuUtilizationPercentage = "string",
#'             MaxMemoryUtilizationPercentage = "string",
#'             MaxStorageUtilizationPercentage = "string",
#'             EBSResourceUtilization = list(
#'               EbsReadOpsPerSecond = "string",
#'               EbsWriteOpsPerSecond = "string",
#'               EbsReadBytesPerSecond = "string",
#'               EbsWriteBytesPerSecond = "string"
#'             )
#'           )
#'         ),
#'         ReservationCoveredHoursInLookbackPeriod = "string",
#'         SavingsPlansCoveredHoursInLookbackPeriod = "string",
#'         OnDemandHoursInLookbackPeriod = "string",
#'         TotalRunningHoursInLookbackPeriod = "string",
#'         MonthlyCost = "string",
#'         CurrencyCode = "string"
#'       ),
#'       RightsizingType = "TERMINATE"|"MODIFY",
#'       ModifyRecommendationDetail = list(
#'         TargetInstances = list(
#'           list(
#'             EstimatedMonthlyCost = "string",
#'             EstimatedMonthlySavings = "string",
#'             CurrencyCode = "string",
#'             DefaultTargetInstance = TRUE|FALSE,
#'             ResourceDetails = list(
#'               EC2ResourceDetails = list(
#'                 HourlyOnDemandRate = "string",
#'                 InstanceType = "string",
#'                 Platform = "string",
#'                 Region = "string",
#'                 Sku = "string",
#'                 Memory = "string",
#'                 NetworkPerformance = "string",
#'                 Storage = "string",
#'                 Vcpu = "string"
#'               )
#'             ),
#'             ExpectedResourceUtilization = list(
#'               EC2ResourceUtilization = list(
#'                 MaxCpuUtilizationPercentage = "string",
#'                 MaxMemoryUtilizationPercentage = "string",
#'                 MaxStorageUtilizationPercentage = "string",
#'                 EBSResourceUtilization = list(
#'                   EbsReadOpsPerSecond = "string",
#'                   EbsWriteOpsPerSecond = "string",
#'                   EbsReadBytesPerSecond = "string",
#'                   EbsWriteBytesPerSecond = "string"
#'                 )
#'               )
#'             )
#'           )
#'         )
#'       ),
#'       TerminateRecommendationDetail = list(
#'         EstimatedMonthlySavings = "string",
#'         CurrencyCode = "string"
#'       )
#'     )
#'   ),
#'   NextPageToken = "string",
#'   Configuration = list(
#'     RecommendationTarget = "SAME_INSTANCE_FAMILY"|"CROSS_INSTANCE_FAMILY",
#'     BenefitsConsidered = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_rightsizing_recommendation(
#'   Filter = list(
#'     Or = list(
#'       list()
#'     ),
#'     And = list(
#'       list()
#'     ),
#'     Not = list(),
#'     Dimensions = list(
#'       Key = "AZ"|"INSTANCE_TYPE"|"LINKED_ACCOUNT"|"LINKED_ACCOUNT_NAME"|"OPERATION"|"PURCHASE_TYPE"|"REGION"|"SERVICE"|"SERVICE_CODE"|"USAGE_TYPE"|"USAGE_TYPE_GROUP"|"RECORD_TYPE"|"OPERATING_SYSTEM"|"TENANCY"|"SCOPE"|"PLATFORM"|"SUBSCRIPTION_ID"|"LEGAL_ENTITY_NAME"|"DEPLOYMENT_OPTION"|"DATABASE_ENGINE"|"CACHE_ENGINE"|"INSTANCE_TYPE_FAMILY"|"BILLING_ENTITY"|"RESERVATION_ID"|"RESOURCE_ID"|"RIGHTSIZING_TYPE"|"SAVINGS_PLANS_TYPE"|"SAVINGS_PLAN_ARN"|"PAYMENT_OPTION"|"AGREEMENT_END_DATE_TIME_AFTER"|"AGREEMENT_END_DATE_TIME_BEFORE",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     ),
#'     Tags = list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     ),
#'     CostCategories = list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     )
#'   ),
#'   Configuration = list(
#'     RecommendationTarget = "SAME_INSTANCE_FAMILY"|"CROSS_INSTANCE_FAMILY",
#'     BenefitsConsidered = TRUE|FALSE
#'   ),
#'   Service = "string",
#'   PageSize = 123,
#'   NextPageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname costexplorer_get_rightsizing_recommendation
costexplorer_get_rightsizing_recommendation <- function(Filter = NULL, Configuration = NULL, Service, PageSize = NULL, NextPageToken = NULL) {
  op <- new_operation(
    name = "GetRightsizingRecommendation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$get_rightsizing_recommendation_input(Filter = Filter, Configuration = Configuration, Service = Service, PageSize = PageSize, NextPageToken = NextPageToken)
  output <- .costexplorer$get_rightsizing_recommendation_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$get_rightsizing_recommendation <- costexplorer_get_rightsizing_recommendation

#' Retrieves the Savings Plans covered for your account
#'
#' @description
#' Retrieves the Savings Plans covered for your account. This enables you
#' to see how much of your cost is covered by a Savings Plan. An
#' organization’s management account can see the coverage of the associated
#' member accounts. This supports dimensions, Cost Categories, and nested
#' expressions. For any time period, you can filter data for Savings Plans
#' usage with the following dimensions:
#' 
#' -   `LINKED_ACCOUNT`
#' 
#' -   `REGION`
#' 
#' -   `SERVICE`
#' 
#' -   `INSTANCE_FAMILY`
#' 
#' To determine valid values for a dimension, use the
#' [`get_dimension_values`][costexplorer_get_dimension_values] operation.
#'
#' @usage
#' costexplorer_get_savings_plans_coverage(TimePeriod, GroupBy,
#'   Granularity, Filter, Metrics, NextToken, MaxResults, SortBy)
#'
#' @param TimePeriod &#91;required&#93; The time period that you want the usage and costs for. The `Start` date
#' must be within 13 months. The `End` date must be after the `Start` date,
#' and before the current date. Future dates can't be used as an `End`
#' date.
#' @param GroupBy You can group the data using the attributes `INSTANCE_FAMILY`, `REGION`,
#' or `SERVICE`.
#' @param Granularity The granularity of the Amazon Web Services cost data for your Savings
#' Plans. `Granularity` can't be set if `GroupBy` is set.
#' 
#' The
#' [`get_savings_plans_coverage`][costexplorer_get_savings_plans_coverage]
#' operation supports only `DAILY` and `MONTHLY` granularities.
#' @param Filter Filters Savings Plans coverage data by dimensions. You can filter data
#' for Savings Plans usage with the following dimensions:
#' 
#' -   `LINKED_ACCOUNT`
#' 
#' -   `REGION`
#' 
#' -   `SERVICE`
#' 
#' -   `INSTANCE_FAMILY`
#' 
#' [`get_savings_plans_coverage`][costexplorer_get_savings_plans_coverage]
#' uses the same
#' [Expression](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html)
#' object as the other operations, but only `AND` is supported among each
#' dimension. If there are multiple values for a dimension, they are OR'd
#' together.
#' 
#' Cost category is also supported.
#' @param Metrics The measurement that you want your Savings Plans coverage reported in.
#' The only valid value is `SpendCoveredBySavingsPlans`.
#' @param NextToken The token to retrieve the next set of results. Amazon Web Services
#' provides the token when the response from a previous call has more
#' results than the maximum page size.
#' @param MaxResults The number of items to be returned in a response. The default is `20`,
#' with a minimum value of `1`.
#' @param SortBy The value by which you want to sort the data.
#' 
#' The following values are supported for `Key`:
#' 
#' -   `SpendCoveredBySavingsPlan`
#' 
#' -   `OnDemandCost`
#' 
#' -   `CoveragePercentage`
#' 
#' -   `TotalCost`
#' 
#' -   `InstanceFamily`
#' 
#' -   `Region`
#' 
#' -   `Service`
#' 
#' Supported values for `SortOrder` are `ASCENDING` or `DESCENDING`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   SavingsPlansCoverages = list(
#'     list(
#'       Attributes = list(
#'         "string"
#'       ),
#'       Coverage = list(
#'         SpendCoveredBySavingsPlans = "string",
#'         OnDemandCost = "string",
#'         TotalCost = "string",
#'         CoveragePercentage = "string"
#'       ),
#'       TimePeriod = list(
#'         Start = "string",
#'         End = "string"
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_savings_plans_coverage(
#'   TimePeriod = list(
#'     Start = "string",
#'     End = "string"
#'   ),
#'   GroupBy = list(
#'     list(
#'       Type = "DIMENSION"|"TAG"|"COST_CATEGORY",
#'       Key = "string"
#'     )
#'   ),
#'   Granularity = "DAILY"|"MONTHLY"|"HOURLY",
#'   Filter = list(
#'     Or = list(
#'       list()
#'     ),
#'     And = list(
#'       list()
#'     ),
#'     Not = list(),
#'     Dimensions = list(
#'       Key = "AZ"|"INSTANCE_TYPE"|"LINKED_ACCOUNT"|"LINKED_ACCOUNT_NAME"|"OPERATION"|"PURCHASE_TYPE"|"REGION"|"SERVICE"|"SERVICE_CODE"|"USAGE_TYPE"|"USAGE_TYPE_GROUP"|"RECORD_TYPE"|"OPERATING_SYSTEM"|"TENANCY"|"SCOPE"|"PLATFORM"|"SUBSCRIPTION_ID"|"LEGAL_ENTITY_NAME"|"DEPLOYMENT_OPTION"|"DATABASE_ENGINE"|"CACHE_ENGINE"|"INSTANCE_TYPE_FAMILY"|"BILLING_ENTITY"|"RESERVATION_ID"|"RESOURCE_ID"|"RIGHTSIZING_TYPE"|"SAVINGS_PLANS_TYPE"|"SAVINGS_PLAN_ARN"|"PAYMENT_OPTION"|"AGREEMENT_END_DATE_TIME_AFTER"|"AGREEMENT_END_DATE_TIME_BEFORE",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     ),
#'     Tags = list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     ),
#'     CostCategories = list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     )
#'   ),
#'   Metrics = list(
#'     "string"
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123,
#'   SortBy = list(
#'     Key = "string",
#'     SortOrder = "ASCENDING"|"DESCENDING"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname costexplorer_get_savings_plans_coverage
costexplorer_get_savings_plans_coverage <- function(TimePeriod, GroupBy = NULL, Granularity = NULL, Filter = NULL, Metrics = NULL, NextToken = NULL, MaxResults = NULL, SortBy = NULL) {
  op <- new_operation(
    name = "GetSavingsPlansCoverage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$get_savings_plans_coverage_input(TimePeriod = TimePeriod, GroupBy = GroupBy, Granularity = Granularity, Filter = Filter, Metrics = Metrics, NextToken = NextToken, MaxResults = MaxResults, SortBy = SortBy)
  output <- .costexplorer$get_savings_plans_coverage_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$get_savings_plans_coverage <- costexplorer_get_savings_plans_coverage

#' Retrieves your request parameters, Savings Plan Recommendations Summary
#' and Details
#'
#' @description
#' Retrieves your request parameters, Savings Plan Recommendations Summary
#' and Details.
#'
#' @usage
#' costexplorer_get_savings_plans_purchase_recommendation(SavingsPlansType,
#'   TermInYears, PaymentOption, AccountScope, NextPageToken, PageSize,
#'   LookbackPeriodInDays, Filter)
#'
#' @param SavingsPlansType &#91;required&#93; The Savings Plans recommendation type requested.
#' @param TermInYears &#91;required&#93; The savings plan recommendation term used to generate these
#' recommendations.
#' @param PaymentOption &#91;required&#93; The payment option used to generate these recommendations.
#' @param AccountScope The account scope that you want your recommendations for. Amazon Web
#' Services calculates recommendations including the management account and
#' member accounts if the value is set to `PAYER`. If the value is
#' `LINKED`, recommendations are calculated for individual member accounts
#' only.
#' @param NextPageToken The token to retrieve the next set of results. Amazon Web Services
#' provides the token when the response from a previous call has more
#' results than the maximum page size.
#' @param PageSize The number of recommendations that you want returned in a single
#' response object.
#' @param LookbackPeriodInDays &#91;required&#93; The lookback period used to generate the recommendation.
#' @param Filter You can filter your recommendations by Account ID with the
#' `LINKED_ACCOUNT` dimension. To filter your recommendations by Account
#' ID, specify `Key` as `LINKED_ACCOUNT` and `Value` as the comma-separated
#' Acount ID(s) for which you want to see Savings Plans purchase
#' recommendations.
#' 
#' For GetSavingsPlansPurchaseRecommendation, the `Filter` does not include
#' `CostCategories` or `Tags`. It only includes `Dimensions`. With
#' `Dimensions`, `Key` must be `LINKED_ACCOUNT` and `Value` can be a single
#' Account ID or multiple comma-separated Account IDs for which you want to
#' see Savings Plans Purchase Recommendations. `AND` and `OR` operators are
#' not supported.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Metadata = list(
#'     RecommendationId = "string",
#'     GenerationTimestamp = "string",
#'     AdditionalMetadata = "string"
#'   ),
#'   SavingsPlansPurchaseRecommendation = list(
#'     AccountScope = "PAYER"|"LINKED",
#'     SavingsPlansType = "COMPUTE_SP"|"EC2_INSTANCE_SP",
#'     TermInYears = "ONE_YEAR"|"THREE_YEARS",
#'     PaymentOption = "NO_UPFRONT"|"PARTIAL_UPFRONT"|"ALL_UPFRONT"|"LIGHT_UTILIZATION"|"MEDIUM_UTILIZATION"|"HEAVY_UTILIZATION",
#'     LookbackPeriodInDays = "SEVEN_DAYS"|"THIRTY_DAYS"|"SIXTY_DAYS",
#'     SavingsPlansPurchaseRecommendationDetails = list(
#'       list(
#'         SavingsPlansDetails = list(
#'           Region = "string",
#'           InstanceFamily = "string",
#'           OfferingId = "string"
#'         ),
#'         AccountId = "string",
#'         UpfrontCost = "string",
#'         EstimatedROI = "string",
#'         CurrencyCode = "string",
#'         EstimatedSPCost = "string",
#'         EstimatedOnDemandCost = "string",
#'         EstimatedOnDemandCostWithCurrentCommitment = "string",
#'         EstimatedSavingsAmount = "string",
#'         EstimatedSavingsPercentage = "string",
#'         HourlyCommitmentToPurchase = "string",
#'         EstimatedAverageUtilization = "string",
#'         EstimatedMonthlySavingsAmount = "string",
#'         CurrentMinimumHourlyOnDemandSpend = "string",
#'         CurrentMaximumHourlyOnDemandSpend = "string",
#'         CurrentAverageHourlyOnDemandSpend = "string"
#'       )
#'     ),
#'     SavingsPlansPurchaseRecommendationSummary = list(
#'       EstimatedROI = "string",
#'       CurrencyCode = "string",
#'       EstimatedTotalCost = "string",
#'       CurrentOnDemandSpend = "string",
#'       EstimatedSavingsAmount = "string",
#'       TotalRecommendationCount = "string",
#'       DailyCommitmentToPurchase = "string",
#'       HourlyCommitmentToPurchase = "string",
#'       EstimatedSavingsPercentage = "string",
#'       EstimatedMonthlySavingsAmount = "string",
#'       EstimatedOnDemandCostWithCurrentCommitment = "string"
#'     )
#'   ),
#'   NextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_savings_plans_purchase_recommendation(
#'   SavingsPlansType = "COMPUTE_SP"|"EC2_INSTANCE_SP",
#'   TermInYears = "ONE_YEAR"|"THREE_YEARS",
#'   PaymentOption = "NO_UPFRONT"|"PARTIAL_UPFRONT"|"ALL_UPFRONT"|"LIGHT_UTILIZATION"|"MEDIUM_UTILIZATION"|"HEAVY_UTILIZATION",
#'   AccountScope = "PAYER"|"LINKED",
#'   NextPageToken = "string",
#'   PageSize = 123,
#'   LookbackPeriodInDays = "SEVEN_DAYS"|"THIRTY_DAYS"|"SIXTY_DAYS",
#'   Filter = list(
#'     Or = list(
#'       list()
#'     ),
#'     And = list(
#'       list()
#'     ),
#'     Not = list(),
#'     Dimensions = list(
#'       Key = "AZ"|"INSTANCE_TYPE"|"LINKED_ACCOUNT"|"LINKED_ACCOUNT_NAME"|"OPERATION"|"PURCHASE_TYPE"|"REGION"|"SERVICE"|"SERVICE_CODE"|"USAGE_TYPE"|"USAGE_TYPE_GROUP"|"RECORD_TYPE"|"OPERATING_SYSTEM"|"TENANCY"|"SCOPE"|"PLATFORM"|"SUBSCRIPTION_ID"|"LEGAL_ENTITY_NAME"|"DEPLOYMENT_OPTION"|"DATABASE_ENGINE"|"CACHE_ENGINE"|"INSTANCE_TYPE_FAMILY"|"BILLING_ENTITY"|"RESERVATION_ID"|"RESOURCE_ID"|"RIGHTSIZING_TYPE"|"SAVINGS_PLANS_TYPE"|"SAVINGS_PLAN_ARN"|"PAYMENT_OPTION"|"AGREEMENT_END_DATE_TIME_AFTER"|"AGREEMENT_END_DATE_TIME_BEFORE",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     ),
#'     Tags = list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     ),
#'     CostCategories = list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname costexplorer_get_savings_plans_purchase_recommendation
costexplorer_get_savings_plans_purchase_recommendation <- function(SavingsPlansType, TermInYears, PaymentOption, AccountScope = NULL, NextPageToken = NULL, PageSize = NULL, LookbackPeriodInDays, Filter = NULL) {
  op <- new_operation(
    name = "GetSavingsPlansPurchaseRecommendation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$get_savings_plans_purchase_recommendation_input(SavingsPlansType = SavingsPlansType, TermInYears = TermInYears, PaymentOption = PaymentOption, AccountScope = AccountScope, NextPageToken = NextPageToken, PageSize = PageSize, LookbackPeriodInDays = LookbackPeriodInDays, Filter = Filter)
  output <- .costexplorer$get_savings_plans_purchase_recommendation_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$get_savings_plans_purchase_recommendation <- costexplorer_get_savings_plans_purchase_recommendation

#' Retrieves the Savings Plans utilization for your account across date
#' ranges with daily or monthly granularity
#'
#' @description
#' Retrieves the Savings Plans utilization for your account across date
#' ranges with daily or monthly granularity. Management account in an
#' organization have access to member accounts. You can use
#' [`get_dimension_values`][costexplorer_get_dimension_values] in
#' `SAVINGS_PLANS` to determine the possible dimension values.
#' 
#' You cannot group by any dimension values for
#' [`get_savings_plans_utilization`][costexplorer_get_savings_plans_utilization].
#'
#' @usage
#' costexplorer_get_savings_plans_utilization(TimePeriod, Granularity,
#'   Filter, SortBy)
#'
#' @param TimePeriod &#91;required&#93; The time period that you want the usage and costs for. The `Start` date
#' must be within 13 months. The `End` date must be after the `Start` date,
#' and before the current date. Future dates can't be used as an `End`
#' date.
#' @param Granularity The granularity of the Amazon Web Services utillization data for your
#' Savings Plans.
#' 
#' The
#' [`get_savings_plans_utilization`][costexplorer_get_savings_plans_utilization]
#' operation supports only `DAILY` and `MONTHLY` granularities.
#' @param Filter Filters Savings Plans utilization coverage data for active Savings Plans
#' dimensions. You can filter data with the following dimensions:
#' 
#' -   `LINKED_ACCOUNT`
#' 
#' -   `SAVINGS_PLAN_ARN`
#' 
#' -   `SAVINGS_PLANS_TYPE`
#' 
#' -   `REGION`
#' 
#' -   `PAYMENT_OPTION`
#' 
#' -   `INSTANCE_TYPE_FAMILY`
#' 
#' [`get_savings_plans_utilization`][costexplorer_get_savings_plans_utilization]
#' uses the same
#' [Expression](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html)
#' object as the other operations, but only `AND` is supported among each
#' dimension.
#' @param SortBy The value by which you want to sort the data.
#' 
#' The following values are supported for `Key`:
#' 
#' -   `UtilizationPercentage`
#' 
#' -   `TotalCommitment`
#' 
#' -   `UsedCommitment`
#' 
#' -   `UnusedCommitment`
#' 
#' -   `NetSavings`
#' 
#' Supported values for `SortOrder` are `ASCENDING` or `DESCENDING`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   SavingsPlansUtilizationsByTime = list(
#'     list(
#'       TimePeriod = list(
#'         Start = "string",
#'         End = "string"
#'       ),
#'       Utilization = list(
#'         TotalCommitment = "string",
#'         UsedCommitment = "string",
#'         UnusedCommitment = "string",
#'         UtilizationPercentage = "string"
#'       ),
#'       Savings = list(
#'         NetSavings = "string",
#'         OnDemandCostEquivalent = "string"
#'       ),
#'       AmortizedCommitment = list(
#'         AmortizedRecurringCommitment = "string",
#'         AmortizedUpfrontCommitment = "string",
#'         TotalAmortizedCommitment = "string"
#'       )
#'     )
#'   ),
#'   Total = list(
#'     Utilization = list(
#'       TotalCommitment = "string",
#'       UsedCommitment = "string",
#'       UnusedCommitment = "string",
#'       UtilizationPercentage = "string"
#'     ),
#'     Savings = list(
#'       NetSavings = "string",
#'       OnDemandCostEquivalent = "string"
#'     ),
#'     AmortizedCommitment = list(
#'       AmortizedRecurringCommitment = "string",
#'       AmortizedUpfrontCommitment = "string",
#'       TotalAmortizedCommitment = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_savings_plans_utilization(
#'   TimePeriod = list(
#'     Start = "string",
#'     End = "string"
#'   ),
#'   Granularity = "DAILY"|"MONTHLY"|"HOURLY",
#'   Filter = list(
#'     Or = list(
#'       list()
#'     ),
#'     And = list(
#'       list()
#'     ),
#'     Not = list(),
#'     Dimensions = list(
#'       Key = "AZ"|"INSTANCE_TYPE"|"LINKED_ACCOUNT"|"LINKED_ACCOUNT_NAME"|"OPERATION"|"PURCHASE_TYPE"|"REGION"|"SERVICE"|"SERVICE_CODE"|"USAGE_TYPE"|"USAGE_TYPE_GROUP"|"RECORD_TYPE"|"OPERATING_SYSTEM"|"TENANCY"|"SCOPE"|"PLATFORM"|"SUBSCRIPTION_ID"|"LEGAL_ENTITY_NAME"|"DEPLOYMENT_OPTION"|"DATABASE_ENGINE"|"CACHE_ENGINE"|"INSTANCE_TYPE_FAMILY"|"BILLING_ENTITY"|"RESERVATION_ID"|"RESOURCE_ID"|"RIGHTSIZING_TYPE"|"SAVINGS_PLANS_TYPE"|"SAVINGS_PLAN_ARN"|"PAYMENT_OPTION"|"AGREEMENT_END_DATE_TIME_AFTER"|"AGREEMENT_END_DATE_TIME_BEFORE",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     ),
#'     Tags = list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     ),
#'     CostCategories = list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     )
#'   ),
#'   SortBy = list(
#'     Key = "string",
#'     SortOrder = "ASCENDING"|"DESCENDING"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname costexplorer_get_savings_plans_utilization
costexplorer_get_savings_plans_utilization <- function(TimePeriod, Granularity = NULL, Filter = NULL, SortBy = NULL) {
  op <- new_operation(
    name = "GetSavingsPlansUtilization",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$get_savings_plans_utilization_input(TimePeriod = TimePeriod, Granularity = Granularity, Filter = Filter, SortBy = SortBy)
  output <- .costexplorer$get_savings_plans_utilization_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$get_savings_plans_utilization <- costexplorer_get_savings_plans_utilization

#' Retrieves attribute data along with aggregate utilization and savings
#' data for a given time period
#'
#' @description
#' Retrieves attribute data along with aggregate utilization and savings
#' data for a given time period. This doesn't support granular or grouped
#' data (daily/monthly) in response. You can't retrieve data by dates in a
#' single response similar to `GetSavingsPlanUtilization`, but you have the
#' option to make multiple calls to `GetSavingsPlanUtilizationDetails` by
#' providing individual dates. You can use
#' [`get_dimension_values`][costexplorer_get_dimension_values] in
#' `SAVINGS_PLANS` to determine the possible dimension values.
#' 
#' `GetSavingsPlanUtilizationDetails` internally groups data by
#' `SavingsPlansArn`.
#'
#' @usage
#' costexplorer_get_savings_plans_utilization_details(TimePeriod, Filter,
#'   DataType, NextToken, MaxResults, SortBy)
#'
#' @param TimePeriod &#91;required&#93; The time period that you want the usage and costs for. The `Start` date
#' must be within 13 months. The `End` date must be after the `Start` date,
#' and before the current date. Future dates can't be used as an `End`
#' date.
#' @param Filter Filters Savings Plans utilization coverage data for active Savings Plans
#' dimensions. You can filter data with the following dimensions:
#' 
#' -   `LINKED_ACCOUNT`
#' 
#' -   `SAVINGS_PLAN_ARN`
#' 
#' -   `REGION`
#' 
#' -   `PAYMENT_OPTION`
#' 
#' -   `INSTANCE_TYPE_FAMILY`
#' 
#' [`get_savings_plans_utilization_details`][costexplorer_get_savings_plans_utilization_details]
#' uses the same
#' [Expression](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html)
#' object as the other operations, but only `AND` is supported among each
#' dimension.
#' @param DataType The data type.
#' @param NextToken The token to retrieve the next set of results. Amazon Web Services
#' provides the token when the response from a previous call has more
#' results than the maximum page size.
#' @param MaxResults The number of items to be returned in a response. The default is `20`,
#' with a minimum value of `1`.
#' @param SortBy The value by which you want to sort the data.
#' 
#' The following values are supported for `Key`:
#' 
#' -   `UtilizationPercentage`
#' 
#' -   `TotalCommitment`
#' 
#' -   `UsedCommitment`
#' 
#' -   `UnusedCommitment`
#' 
#' -   `NetSavings`
#' 
#' -   `AmortizedRecurringCommitment`
#' 
#' -   `AmortizedUpfrontCommitment`
#' 
#' Supported values for `SortOrder` are `ASCENDING` or `DESCENDING`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   SavingsPlansUtilizationDetails = list(
#'     list(
#'       SavingsPlanArn = "string",
#'       Attributes = list(
#'         "string"
#'       ),
#'       Utilization = list(
#'         TotalCommitment = "string",
#'         UsedCommitment = "string",
#'         UnusedCommitment = "string",
#'         UtilizationPercentage = "string"
#'       ),
#'       Savings = list(
#'         NetSavings = "string",
#'         OnDemandCostEquivalent = "string"
#'       ),
#'       AmortizedCommitment = list(
#'         AmortizedRecurringCommitment = "string",
#'         AmortizedUpfrontCommitment = "string",
#'         TotalAmortizedCommitment = "string"
#'       )
#'     )
#'   ),
#'   Total = list(
#'     Utilization = list(
#'       TotalCommitment = "string",
#'       UsedCommitment = "string",
#'       UnusedCommitment = "string",
#'       UtilizationPercentage = "string"
#'     ),
#'     Savings = list(
#'       NetSavings = "string",
#'       OnDemandCostEquivalent = "string"
#'     ),
#'     AmortizedCommitment = list(
#'       AmortizedRecurringCommitment = "string",
#'       AmortizedUpfrontCommitment = "string",
#'       TotalAmortizedCommitment = "string"
#'     )
#'   ),
#'   TimePeriod = list(
#'     Start = "string",
#'     End = "string"
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_savings_plans_utilization_details(
#'   TimePeriod = list(
#'     Start = "string",
#'     End = "string"
#'   ),
#'   Filter = list(
#'     Or = list(
#'       list()
#'     ),
#'     And = list(
#'       list()
#'     ),
#'     Not = list(),
#'     Dimensions = list(
#'       Key = "AZ"|"INSTANCE_TYPE"|"LINKED_ACCOUNT"|"LINKED_ACCOUNT_NAME"|"OPERATION"|"PURCHASE_TYPE"|"REGION"|"SERVICE"|"SERVICE_CODE"|"USAGE_TYPE"|"USAGE_TYPE_GROUP"|"RECORD_TYPE"|"OPERATING_SYSTEM"|"TENANCY"|"SCOPE"|"PLATFORM"|"SUBSCRIPTION_ID"|"LEGAL_ENTITY_NAME"|"DEPLOYMENT_OPTION"|"DATABASE_ENGINE"|"CACHE_ENGINE"|"INSTANCE_TYPE_FAMILY"|"BILLING_ENTITY"|"RESERVATION_ID"|"RESOURCE_ID"|"RIGHTSIZING_TYPE"|"SAVINGS_PLANS_TYPE"|"SAVINGS_PLAN_ARN"|"PAYMENT_OPTION"|"AGREEMENT_END_DATE_TIME_AFTER"|"AGREEMENT_END_DATE_TIME_BEFORE",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     ),
#'     Tags = list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     ),
#'     CostCategories = list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     )
#'   ),
#'   DataType = list(
#'     "ATTRIBUTES"|"UTILIZATION"|"AMORTIZED_COMMITMENT"|"SAVINGS"
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123,
#'   SortBy = list(
#'     Key = "string",
#'     SortOrder = "ASCENDING"|"DESCENDING"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname costexplorer_get_savings_plans_utilization_details
costexplorer_get_savings_plans_utilization_details <- function(TimePeriod, Filter = NULL, DataType = NULL, NextToken = NULL, MaxResults = NULL, SortBy = NULL) {
  op <- new_operation(
    name = "GetSavingsPlansUtilizationDetails",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$get_savings_plans_utilization_details_input(TimePeriod = TimePeriod, Filter = Filter, DataType = DataType, NextToken = NextToken, MaxResults = MaxResults, SortBy = SortBy)
  output <- .costexplorer$get_savings_plans_utilization_details_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$get_savings_plans_utilization_details <- costexplorer_get_savings_plans_utilization_details

#' Queries for available tag keys and tag values for a specified period
#'
#' @description
#' Queries for available tag keys and tag values for a specified period.
#' You can search the tag values for an arbitrary string.
#'
#' @usage
#' costexplorer_get_tags(SearchString, TimePeriod, TagKey, Filter, SortBy,
#'   MaxResults, NextPageToken)
#'
#' @param SearchString The value that you want to search for.
#' @param TimePeriod &#91;required&#93; The start and end dates for retrieving the dimension values. The start
#' date is inclusive, but the end date is exclusive. For example, if
#' `start` is `2017-01-01` and `end` is `2017-05-01`, then the cost and
#' usage data is retrieved from `2017-01-01` up to and including
#' `2017-04-30` but not including `2017-05-01`.
#' @param TagKey The key of the tag that you want to return values for.
#' @param Filter 
#' @param SortBy The value by which you want to sort the data.
#' 
#' The key represents cost and usage metrics. The following values are
#' supported:
#' 
#' -   `BlendedCost`
#' 
#' -   `UnblendedCost`
#' 
#' -   `AmortizedCost`
#' 
#' -   `NetAmortizedCost`
#' 
#' -   `NetUnblendedCost`
#' 
#' -   `UsageQuantity`
#' 
#' -   `NormalizedUsageAmount`
#' 
#' Supported values for `SortOrder` are `ASCENDING` or `DESCENDING`.
#' 
#' When using `SortBy`, `NextPageToken` and `SearchString` are not
#' supported.
#' @param MaxResults This field is only used when SortBy is provided in the request. The
#' maximum number of objects that to be returned for this request. If
#' MaxResults is not specified with SortBy, the request will return 1000
#' results as the default value for this parameter.
#' @param NextPageToken The token to retrieve the next set of results. AWS provides the token
#' when the response from a previous call has more results than the maximum
#' page size.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NextPageToken = "string",
#'   Tags = list(
#'     "string"
#'   ),
#'   ReturnSize = 123,
#'   TotalSize = 123
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_tags(
#'   SearchString = "string",
#'   TimePeriod = list(
#'     Start = "string",
#'     End = "string"
#'   ),
#'   TagKey = "string",
#'   Filter = list(
#'     Or = list(
#'       list()
#'     ),
#'     And = list(
#'       list()
#'     ),
#'     Not = list(),
#'     Dimensions = list(
#'       Key = "AZ"|"INSTANCE_TYPE"|"LINKED_ACCOUNT"|"LINKED_ACCOUNT_NAME"|"OPERATION"|"PURCHASE_TYPE"|"REGION"|"SERVICE"|"SERVICE_CODE"|"USAGE_TYPE"|"USAGE_TYPE_GROUP"|"RECORD_TYPE"|"OPERATING_SYSTEM"|"TENANCY"|"SCOPE"|"PLATFORM"|"SUBSCRIPTION_ID"|"LEGAL_ENTITY_NAME"|"DEPLOYMENT_OPTION"|"DATABASE_ENGINE"|"CACHE_ENGINE"|"INSTANCE_TYPE_FAMILY"|"BILLING_ENTITY"|"RESERVATION_ID"|"RESOURCE_ID"|"RIGHTSIZING_TYPE"|"SAVINGS_PLANS_TYPE"|"SAVINGS_PLAN_ARN"|"PAYMENT_OPTION"|"AGREEMENT_END_DATE_TIME_AFTER"|"AGREEMENT_END_DATE_TIME_BEFORE",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     ),
#'     Tags = list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     ),
#'     CostCategories = list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     )
#'   ),
#'   SortBy = list(
#'     list(
#'       Key = "string",
#'       SortOrder = "ASCENDING"|"DESCENDING"
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextPageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname costexplorer_get_tags
costexplorer_get_tags <- function(SearchString = NULL, TimePeriod, TagKey = NULL, Filter = NULL, SortBy = NULL, MaxResults = NULL, NextPageToken = NULL) {
  op <- new_operation(
    name = "GetTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$get_tags_input(SearchString = SearchString, TimePeriod = TimePeriod, TagKey = TagKey, Filter = Filter, SortBy = SortBy, MaxResults = MaxResults, NextPageToken = NextPageToken)
  output <- .costexplorer$get_tags_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$get_tags <- costexplorer_get_tags

#' Retrieves a forecast for how much Amazon Web Services predicts that you
#' will use over the forecast time period that you select, based on your
#' past usage
#'
#' @description
#' Retrieves a forecast for how much Amazon Web Services predicts that you
#' will use over the forecast time period that you select, based on your
#' past usage.
#'
#' @usage
#' costexplorer_get_usage_forecast(TimePeriod, Metric, Granularity, Filter,
#'   PredictionIntervalLevel)
#'
#' @param TimePeriod &#91;required&#93; The start and end dates of the period that you want to retrieve usage
#' forecast for. The start date is inclusive, but the end date is
#' exclusive. For example, if `start` is `2017-01-01` and `end` is
#' `2017-05-01`, then the cost and usage data is retrieved from
#' `2017-01-01` up to and including `2017-04-30` but not including
#' `2017-05-01`. The start date must be equal to or later than the current
#' date to avoid a validation error.
#' @param Metric &#91;required&#93; Which metric Cost Explorer uses to create your forecast.
#' 
#' Valid values for a
#' [`get_usage_forecast`][costexplorer_get_usage_forecast] call are the
#' following:
#' 
#' -   USAGE_QUANTITY
#' 
#' -   NORMALIZED_USAGE_AMOUNT
#' @param Granularity &#91;required&#93; How granular you want the forecast to be. You can get 3 months of
#' `DAILY` forecasts or 12 months of `MONTHLY` forecasts.
#' 
#' The [`get_usage_forecast`][costexplorer_get_usage_forecast] operation
#' supports only `DAILY` and `MONTHLY` granularities.
#' @param Filter The filters that you want to use to filter your forecast. Cost Explorer
#' API supports all of the Cost Explorer filters.
#' @param PredictionIntervalLevel Cost Explorer always returns the mean forecast as a single point. You
#' can request a prediction interval around the mean by specifying a
#' confidence level. The higher the confidence level, the more confident
#' Cost Explorer is about the actual value falling in the prediction
#' interval. Higher confidence levels result in wider prediction intervals.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Total = list(
#'     Amount = "string",
#'     Unit = "string"
#'   ),
#'   ForecastResultsByTime = list(
#'     list(
#'       TimePeriod = list(
#'         Start = "string",
#'         End = "string"
#'       ),
#'       MeanValue = "string",
#'       PredictionIntervalLowerBound = "string",
#'       PredictionIntervalUpperBound = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_usage_forecast(
#'   TimePeriod = list(
#'     Start = "string",
#'     End = "string"
#'   ),
#'   Metric = "BLENDED_COST"|"UNBLENDED_COST"|"AMORTIZED_COST"|"NET_UNBLENDED_COST"|"NET_AMORTIZED_COST"|"USAGE_QUANTITY"|"NORMALIZED_USAGE_AMOUNT",
#'   Granularity = "DAILY"|"MONTHLY"|"HOURLY",
#'   Filter = list(
#'     Or = list(
#'       list()
#'     ),
#'     And = list(
#'       list()
#'     ),
#'     Not = list(),
#'     Dimensions = list(
#'       Key = "AZ"|"INSTANCE_TYPE"|"LINKED_ACCOUNT"|"LINKED_ACCOUNT_NAME"|"OPERATION"|"PURCHASE_TYPE"|"REGION"|"SERVICE"|"SERVICE_CODE"|"USAGE_TYPE"|"USAGE_TYPE_GROUP"|"RECORD_TYPE"|"OPERATING_SYSTEM"|"TENANCY"|"SCOPE"|"PLATFORM"|"SUBSCRIPTION_ID"|"LEGAL_ENTITY_NAME"|"DEPLOYMENT_OPTION"|"DATABASE_ENGINE"|"CACHE_ENGINE"|"INSTANCE_TYPE_FAMILY"|"BILLING_ENTITY"|"RESERVATION_ID"|"RESOURCE_ID"|"RIGHTSIZING_TYPE"|"SAVINGS_PLANS_TYPE"|"SAVINGS_PLAN_ARN"|"PAYMENT_OPTION"|"AGREEMENT_END_DATE_TIME_AFTER"|"AGREEMENT_END_DATE_TIME_BEFORE",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     ),
#'     Tags = list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     ),
#'     CostCategories = list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       ),
#'       MatchOptions = list(
#'         "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'       )
#'     )
#'   ),
#'   PredictionIntervalLevel = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname costexplorer_get_usage_forecast
costexplorer_get_usage_forecast <- function(TimePeriod, Metric, Granularity, Filter = NULL, PredictionIntervalLevel = NULL) {
  op <- new_operation(
    name = "GetUsageForecast",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$get_usage_forecast_input(TimePeriod = TimePeriod, Metric = Metric, Granularity = Granularity, Filter = Filter, PredictionIntervalLevel = PredictionIntervalLevel)
  output <- .costexplorer$get_usage_forecast_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$get_usage_forecast <- costexplorer_get_usage_forecast

#' Returns the name, ARN, NumberOfRules and effective dates of all Cost
#' Categories defined in the account
#'
#' @description
#' Returns the name, ARN, `NumberOfRules` and effective dates of all Cost
#' Categories defined in the account. You have the option to use
#' `EffectiveOn` to return a list of Cost Categories that were active on a
#' specific date. If there is no `EffectiveOn` specified, you’ll see Cost
#' Categories that are effective on the current date. If Cost Category is
#' still effective, `EffectiveEnd` is omitted in the response.
#' [`list_cost_category_definitions`][costexplorer_list_cost_category_definitions]
#' supports pagination. The request can have a `MaxResults` range up to
#' 100.
#'
#' @usage
#' costexplorer_list_cost_category_definitions(EffectiveOn, NextToken,
#'   MaxResults)
#'
#' @param EffectiveOn The date when the Cost Category was effective.
#' @param NextToken The token to retrieve the next set of results. Amazon Web Services
#' provides the token when the response from a previous call has more
#' results than the maximum page size.
#' @param MaxResults The number of entries a paginated response contains.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   CostCategoryReferences = list(
#'     list(
#'       CostCategoryArn = "string",
#'       Name = "string",
#'       EffectiveStart = "string",
#'       EffectiveEnd = "string",
#'       NumberOfRules = 123,
#'       ProcessingStatus = list(
#'         list(
#'           Component = "COST_EXPLORER",
#'           Status = "PROCESSING"|"APPLIED"
#'         )
#'       ),
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_cost_category_definitions(
#'   EffectiveOn = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname costexplorer_list_cost_category_definitions
costexplorer_list_cost_category_definitions <- function(EffectiveOn = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListCostCategoryDefinitions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$list_cost_category_definitions_input(EffectiveOn = EffectiveOn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .costexplorer$list_cost_category_definitions_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$list_cost_category_definitions <- costexplorer_list_cost_category_definitions

#' Modifies the feedback property of a given cost anomaly
#'
#' @description
#' Modifies the feedback property of a given cost anomaly.
#'
#' @usage
#' costexplorer_provide_anomaly_feedback(AnomalyId, Feedback)
#'
#' @param AnomalyId &#91;required&#93; A cost anomaly ID.
#' @param Feedback &#91;required&#93; Describes whether the cost anomaly was a planned activity or you
#' considered it an anomaly.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   AnomalyId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$provide_anomaly_feedback(
#'   AnomalyId = "string",
#'   Feedback = "YES"|"NO"|"PLANNED_ACTIVITY"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname costexplorer_provide_anomaly_feedback
costexplorer_provide_anomaly_feedback <- function(AnomalyId, Feedback) {
  op <- new_operation(
    name = "ProvideAnomalyFeedback",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$provide_anomaly_feedback_input(AnomalyId = AnomalyId, Feedback = Feedback)
  output <- .costexplorer$provide_anomaly_feedback_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$provide_anomaly_feedback <- costexplorer_provide_anomaly_feedback

#' Updates an existing cost anomaly monitor
#'
#' @description
#' Updates an existing cost anomaly monitor. The changes made are applied
#' going forward, and does not change anomalies detected in the past.
#'
#' @usage
#' costexplorer_update_anomaly_monitor(MonitorArn, MonitorName)
#'
#' @param MonitorArn &#91;required&#93; Cost anomaly monitor Amazon Resource Names (ARNs).
#' @param MonitorName The new name for the cost anomaly monitor.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   MonitorArn = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_anomaly_monitor(
#'   MonitorArn = "string",
#'   MonitorName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname costexplorer_update_anomaly_monitor
costexplorer_update_anomaly_monitor <- function(MonitorArn, MonitorName = NULL) {
  op <- new_operation(
    name = "UpdateAnomalyMonitor",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$update_anomaly_monitor_input(MonitorArn = MonitorArn, MonitorName = MonitorName)
  output <- .costexplorer$update_anomaly_monitor_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$update_anomaly_monitor <- costexplorer_update_anomaly_monitor

#' Updates an existing cost anomaly monitor subscription
#'
#' @description
#' Updates an existing cost anomaly monitor subscription.
#'
#' @usage
#' costexplorer_update_anomaly_subscription(SubscriptionArn, Threshold,
#'   Frequency, MonitorArnList, Subscribers, SubscriptionName)
#'
#' @param SubscriptionArn &#91;required&#93; A cost anomaly subscription Amazon Resource Name (ARN).
#' @param Threshold The update to the threshold value for receiving notifications.
#' @param Frequency The update to the frequency value at which subscribers will receive
#' notifications.
#' @param MonitorArnList A list of cost anomaly monitor ARNs.
#' @param Subscribers The update to the subscriber list.
#' @param SubscriptionName The subscription's new name.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   SubscriptionArn = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_anomaly_subscription(
#'   SubscriptionArn = "string",
#'   Threshold = 123.0,
#'   Frequency = "DAILY"|"IMMEDIATE"|"WEEKLY",
#'   MonitorArnList = list(
#'     "string"
#'   ),
#'   Subscribers = list(
#'     list(
#'       Address = "string",
#'       Type = "EMAIL"|"SNS",
#'       Status = "CONFIRMED"|"DECLINED"
#'     )
#'   ),
#'   SubscriptionName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname costexplorer_update_anomaly_subscription
costexplorer_update_anomaly_subscription <- function(SubscriptionArn, Threshold = NULL, Frequency = NULL, MonitorArnList = NULL, Subscribers = NULL, SubscriptionName = NULL) {
  op <- new_operation(
    name = "UpdateAnomalySubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$update_anomaly_subscription_input(SubscriptionArn = SubscriptionArn, Threshold = Threshold, Frequency = Frequency, MonitorArnList = MonitorArnList, Subscribers = Subscribers, SubscriptionName = SubscriptionName)
  output <- .costexplorer$update_anomaly_subscription_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$update_anomaly_subscription <- costexplorer_update_anomaly_subscription

#' Updates an existing Cost Category
#'
#' @description
#' Updates an existing Cost Category. Changes made to the Cost Category
#' rules will be used to categorize the current month’s expenses and future
#' expenses. This won’t change categorization for the previous months.
#'
#' @usage
#' costexplorer_update_cost_category_definition(CostCategoryArn,
#'   RuleVersion, Rules)
#'
#' @param CostCategoryArn &#91;required&#93; The unique identifier for your Cost Category.
#' @param RuleVersion &#91;required&#93; 
#' @param Rules &#91;required&#93; The `Expression` object used to categorize costs. For more information,
#' see
#' [CostCategoryRule](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategoryRule.html)
#' .
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   CostCategoryArn = "string",
#'   EffectiveStart = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_cost_category_definition(
#'   CostCategoryArn = "string",
#'   RuleVersion = "CostCategoryExpression.v1",
#'   Rules = list(
#'     list(
#'       Value = "string",
#'       Rule = list(
#'         Or = list(
#'           list()
#'         ),
#'         And = list(
#'           list()
#'         ),
#'         Not = list(),
#'         Dimensions = list(
#'           Key = "AZ"|"INSTANCE_TYPE"|"LINKED_ACCOUNT"|"LINKED_ACCOUNT_NAME"|"OPERATION"|"PURCHASE_TYPE"|"REGION"|"SERVICE"|"SERVICE_CODE"|"USAGE_TYPE"|"USAGE_TYPE_GROUP"|"RECORD_TYPE"|"OPERATING_SYSTEM"|"TENANCY"|"SCOPE"|"PLATFORM"|"SUBSCRIPTION_ID"|"LEGAL_ENTITY_NAME"|"DEPLOYMENT_OPTION"|"DATABASE_ENGINE"|"CACHE_ENGINE"|"INSTANCE_TYPE_FAMILY"|"BILLING_ENTITY"|"RESERVATION_ID"|"RESOURCE_ID"|"RIGHTSIZING_TYPE"|"SAVINGS_PLANS_TYPE"|"SAVINGS_PLAN_ARN"|"PAYMENT_OPTION"|"AGREEMENT_END_DATE_TIME_AFTER"|"AGREEMENT_END_DATE_TIME_BEFORE",
#'           Values = list(
#'             "string"
#'           ),
#'           MatchOptions = list(
#'             "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'           )
#'         ),
#'         Tags = list(
#'           Key = "string",
#'           Values = list(
#'             "string"
#'           ),
#'           MatchOptions = list(
#'             "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'           )
#'         ),
#'         CostCategories = list(
#'           Key = "string",
#'           Values = list(
#'             "string"
#'           ),
#'           MatchOptions = list(
#'             "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
#'           )
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname costexplorer_update_cost_category_definition
costexplorer_update_cost_category_definition <- function(CostCategoryArn, RuleVersion, Rules) {
  op <- new_operation(
    name = "UpdateCostCategoryDefinition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$update_cost_category_definition_input(CostCategoryArn = CostCategoryArn, RuleVersion = RuleVersion, Rules = Rules)
  output <- .costexplorer$update_cost_category_definition_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$update_cost_category_definition <- costexplorer_update_cost_category_definition
