# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @importFrom memuse Sys.meminfo Sys.swapinfo
NULL

#' ParallelpamSetDebug
#'
#' Sets debugging in parallelpam package to ON (with TRUE) or OFF (with FALSE) for both parts of it.\cr
#' On package load the default status is OFF.\cr
#' Setting debugging of any part to ON shows a message. Setting to OFF does not show anything (since debugging is OFF...)
#'
#' @param deb     boolean, TRUE to generate debug messages for the PAM algorithm and FALSE to turn them off. Default: true.
#' @param debjmat boolean, TRUE to generate debug messages for the jmatrix part inside this package and FALSE to turn them off. Default: false
#' @return        No return value, called for side effects (internal boolean flag changed)
#' @examples
#' ParallelpamSetDebug(TRUE,debjmat=TRUE)
#' ParallelpamSetDebug(TRUE,debjmat=FALSE)
#' @export
ParallelpamSetDebug <- function(deb = TRUE, debjmat = FALSE) {
    invisible(.Call(`_parallelpam_ParallelpamSetDebug`, deb, debjmat))
}

#' CalcAndWriteDissimilarityMatrix
#'
#' Writes a binary symmetric matrix with the dissimilarities between ROWS of the data stored in a binary matrix in the scellpam package format.\cr
#' Notice that, differently from the common practice in single cell, the rows represent cells. This is for efficiency reasons and it is transparent
#' to the user, as long as he/she has generated the binary matrix (with CsvToBinMat, dgCMatToBinMat or SceToBinMat) using the option transpose=TRUE.\cr
#' The input matrix of vectors can be a full or a sparse matrix. Output matrix type can be float or double type (but look at the comments in 'Details').
#'
#' The parameter restype forces the output to be a matrix of either floats or doubles. Precision of float if normally good enough; but if you need
#' double precision (may be because you expect your results to be in a large range, two to three orders of magnitude), change it.\cr
#' Nevertheless, notice that this at the expense of double memory usage, which is QUADRATIC with the number of individuals (rows) in your input matrix.
#'
#' @param ifname   A string with the name of the file containing the counts as a binary matrix, as written by CsvToBinMat, dgCMatToBinMat or SceToBinMat
#' @param ofname   A string with the name of the binary output file to contain the symmetric dissimilarity matrix.
#' @param distype  The dissimilarity to be calculated. It must be one of these strings: 'L1', 'L2' or 'Pearson'.\cr
#'                 Default: 'L2'.
#' @param restype  The data type of the result. It can be one of the strings 'float' or 'double'. Default: float (and don't change it unless you REALLY need to...).
#' @param comment  Comment to be added to the dissimilary matrix. Default: "" (no comment)
#' @param nthreads Number of threads to be used for the parallel calculations with this meaning:\cr
#'                 -1: don't use threads.\cr
#'                  0: let the function choose according to the number of individuals (cells) and to the number of available cores.\cr
#'                  Any possitive number > 1: use that number of threads. You can use even more than cores, but this is discouraged and raises a warning.\cr
#'                 Default: 0.
#' @return   No return value, called for side effects (creates a file)
#' @examples
#' Rf <- matrix(runif(50000),nrow=100)
#' JWriteBin(Rf,"Rfullfloat.bin",dtype="float",dmtype="full",
#'           comment="Full matrix of floats, 100 rows, 500 columns")
#' JMatInfo("Rfullfloat.bin")
#' CalcAndWriteDissimilarityMatrix("Rfullfloat.bin","RfullfloatDis.bin",distype="L2",
#'                         restype="float",comment="L2 distance matrix from full",nthreads=0)
#' JMatInfo("RfullfloatDis.bin")
#' JWriteBin(Rf,"Rsparsefloat.bin",dtype="float",dmtype="sparse",
#'                         comment="Sparse matrix of floats, 100 rows, 500 columns")
#' JMatInfo("Rsparsefloat.bin")
#' CalcAndWriteDissimilarityMatrix("Rsparsefloat.bin","RsparsefloatDis.bin",distype="L2",
#'                         restype="float",comment="L2 distance matrix from sparse",nthreads=0)
#' JMatInfo("RsparsefloatDis.bin")
#' Dfu<-GetJManyRows("RfullfloatDis.bin",c(1:nrow(Rf)))
#' Dsp<-GetJManyRows("RsparsefloatDis.bin",c(1:nrow(Rf)))
#' max(Dfu-Dsp)
#' file.remove("Rfullfloat.bin")
#' file.remove("Rsparsefloat.bin")
#' file.remove("RfullfloatDis.bin")
#' file.remove("RsparsefloatDis.bin")
#' @export
CalcAndWriteDissimilarityMatrix <- function(ifname, ofname, distype = "L2", restype = "float", comment = "", nthreads = 0L) {
    invisible(.Call(`_parallelpam_CalcAndWriteDissimilarityMatrix`, ifname, ofname, distype, restype, comment, nthreads))
}

#' FilterBySilhouetteQuantile
#'
#' Takes a silhouette, as returned by CalculateSilhouette, the list of medoids and class assignments, as returned by ApplyPam,
#' a quantile and the matrices of counts and dissimilarities and constructs the corresponding matrices clearing off the points whose silhoutte is
#' below the lower quantile, except if they are medoids.\cr
#'
#' The renumbering of indices in the returned cluster may seem confusing at first but it was the way of fitting this with the rest
#' of the package. Anyway, notice that if the numeric vectors in the input parameter L were named vectors, the point names are appropriately kept
#' in the result so point identity is preserved. Moreover, if the counts and dissimilarity input matrices had row and/or column names, they
#' are preserved in the filtered matrices, too.
#' 
#' @param s          A numeric vector with the sihouette coefficient of each point in a classification, as returned by CalculateSilhouette.
#' @param L          A list of two numeric vectors, L$med and L$clasif, obtained normally as the object returned by ApplyPAM.
#' @param fallcounts A string with the name of the binary file containing the matrix of individuals. It can be either a full or a sparse matrix.
#' @param ffilcounts A string with the name of the binary file that will contain the selected individuals. It will have the same character (full/sparse) and type of the complete file.
#' @param falldissim A string with the name of the binary file containing the dissimilarity matrix of the complete set of individuals. It must be a symmetric matrix of floats.
#' @param ffildissim A string with the name of the binary file that will contain  the dissimilarity matrix for the remaining individuals. It will be a symmetric matrix of floats.
#' @param q          Quantile to filter. All points whose silhouette is below this quantile will be filtered out. Default: 0.2
#' @param addcom     Boolean to indicate if a comment must be appended to the current comment of counts and dissimilarity matrices to indicate that they are the result of a filtering process. This comment is automatically generated and contains the value of quantile q. Succesive applications add comments at the end of those already present. Default: TRUE
#' @return Lr["med","clasif"] A list of two numeric vectors.\cr
#'                      Lr$med is a modification of the correponding first element of the passed L parameter.\cr
#'                      Lr$clasif has as many components as remaining instances.\cr
#'                      Since points will have been removed, medoid numbering is modified. Therefore, Lr$med has the NEW index of each medoid in the filtered set.\cr
#'                      Lr$clasif contains the number of the medoid (i.e.: the cluster) to which each instance has been assigned, and therefore does not change.\cr
#'                      All indexes start at 1 (R convention). Please, see Details section\cr
#'
#' @examples
#' # Synthetic problem: 10 random seeds with coordinates in [0..20]
#' # to which random values in [-0.1..0.1] are added
#' M<-matrix(0,100,500)
#' rownames(M)<-paste0("rn",c(1:100))
#' for (i in (1:10))
#' {
#'  p<-20*runif(500)
#'  Rf <- matrix(0.2*(runif(5000)-0.5),nrow=10)
#'  for (k in (1:10))
#'  {
#'   M[10*(i-1)+k,]=p+Rf[k,]
#'  }
#' }
#' JWriteBin(M,"pamtest.bin",dtype="float",dmtype="full")
#' CalcAndWriteDissimilarityMatrix("pamtest.bin","pamDL2.bin",distype="L2",restype="float",nthreads=0)
#' L <- ApplyPAM("pamDL2.bin",10,init_method="BUILD")
#' # Which are the medoids
#' L$med
#' sil <- CalculateSilhouette(L$clasif,"pamDL2.bin")
#' Lf<-FilterBySilhouetteQuantile(sil,L,"pamtest.bin","pamtestfilt.bin","pamDL2.bin","pamDL2filt.bin",
#'                                q=0.4,addcom=TRUE)
#' # The new medoids are the same points but renumbered, since the L$clasif array has less points
#' Lf$med
#' file.remove("pamtest.bin")
#' file.remove("pamDL2.bin")
#' file.remove("pamtestfilt.bin")
#' file.remove("pamDL2filt.bin")
#' @export
FilterBySilhouetteQuantile <- function(s, L, fallcounts, ffilcounts, falldissim, ffildissim, q = 0.2, addcom = TRUE) {
    .Call(`_parallelpam_FilterBySilhouetteQuantile`, s, L, fallcounts, ffilcounts, falldissim, ffildissim, q, addcom)
}

#' FilterBySilhouetteThreshold
#'
#' Takes a silhouette, as returned by CalculateSilhouette, the list of medoids and class assignments, as returned by ApplyPam,
#' a threshold and the matrices of counts and dissimilarities and constructs the corresponding matrices clearing off the points whose silhoutte is
#' below the threshold, except if they are medoids.\cr
#'
#' The renumbering of indices in the returned cluster may seem confusing at first but it was the way of fitting this with the rest
#' of the package. Anyway, notice that if the numeric vectors in the input parameter L were named vectors, the point names are appropriately kept
#' in the result so point identity is preserved. Moreover, if the individuals and dissimilarity input matrices had row and/or column names, they
#' are preserved in the filtered matrices, too.
#' 
#' @param s          A numeric vector with the sihouette coefficient of each point in a classification, as returned by CalculateSilhouette.
#' @param L          A list of two numeric vectors, L$med and L$clasif, obtained normally as the object returned by ApplyPAM.
#' @param fallcounts A string with the name of the binary file containing the matrix of counts per individuals. It can be either a full or a sparse matrix.
#' @param ffilcounts A string with the name of the binary file that will contain the selected individuals. It will have the same character (full/sparse) and type of the complete file.
#' @param falldissim A string with the name of the binary file containing the dissimilarity matrix of the complete set of individuals. It must be a symmetric matrix of floats.
#' @param ffildissim A string with the name of the binary file that will contain  the dissimilarity matrix for the remaining individuals. It will be a symmetric matrix of floats.
#' @param thres      Threshold to filter. All points whose silhouette is below this threshold will be filtered out. Default: 0.0 (remember that silhouette is in [-1..1])
#' @param addcom     Boolean to indicate if a comment must be appended to the current comment of counts and dissimilarity matrices to indicate that they are the result of a filtering process. This comment is automatically generated and contains the value of threshold t. Succesive applications add comments at the end of those already present. Default: TRUE
#' @return Lr["med","clasif"] A list of two numeric vectors.\cr
#'                      Lr$med is a modification of the correponding first element of the passed L parameter.\cr
#'                      Lr$clasif has as many components as remaining instances.\cr
#'                      Since points will have been removed, medoid numbering is modified. Therefore, Lr$med has the NEW index of each medoid in the filtered set.\cr
#'                      Lr$clasif contains the number of the medoid (i.e.: the cluster) to which each instance has been assigned, and therefore does not change.\cr
#'                      All indexes start at 1 (R convention). Please, see Details section\cr
#'
#' @examples
#' # Synthetic problem: 10 random seeds with coordinates in [0..20]
#' # to which random values in [-0.1..0.1] are added
#' M<-matrix(0,100,500)
#' rownames(M)<-paste0("rn",c(1:100))
#' for (i in (1:10))
#' {
#'  p<-20*runif(500)
#'  Rf <- matrix(0.2*(runif(5000)-0.5),nrow=10)
#'  for (k in (1:10))
#'  {
#'   M[10*(i-1)+k,]=p+Rf[k,]
#'  }
#' }
#' JWriteBin(M,"pamtest.bin",dtype="float",dmtype="full")
#' CalcAndWriteDissimilarityMatrix("pamtest.bin","pamDL2.bin",distype="L2",restype="float",nthreads=0)
#' L <- ApplyPAM("pamDL2.bin",10,init_method="BUILD")
#' # Which are the medoids
#' L$med
#' sil <- CalculateSilhouette(L$clasif,"pamDL2.bin")
#' Lf<-FilterBySilhouetteQuantile(sil,L,"pamtest.bin","pamtestfilt.bin","pamDL2.bin","pamDL2filt.bin",
#'                                 q=0.4,addcom=TRUE)
#' # The new medoids are the same points but renumbered, since the L$clasif array has less points
#' Lf$med
#' file.remove("pamtest.bin")
#' file.remove("pamDL2.bin")
#' file.remove("pamtestfilt.bin")
#' file.remove("pamDL2filt.bin")
#' @export
FilterBySilhouetteThreshold <- function(s, L, fallcounts, ffilcounts, falldissim, ffildissim, thres = 0.0, addcom = TRUE) {
    .Call(`_parallelpam_FilterBySilhouetteThreshold`, s, L, fallcounts, ffilcounts, falldissim, ffildissim, thres, addcom)
}

#' ClassifAsDataFrame
#'
#' Returns the results of the classification returned by ApplyPAM as a R dataframe
#' 
#' The dataframe has three columns: PointName (name of each point), NNPointName (name of the point which is the center of the cluster to which PointName belongs to)
#' and NNDistance (distance between the points PointName and NNPointName).
#' Medoids are identified by the fact that PointName and NNPointName are equal, or equivalently, NNDistance is 0.
#'
#' @param L      The list returned by ApplyPAM with fields L$med and\cr
#'               L$clasif with the numbers of the medoids and the classification of each point
#' @param fdist  The binary file containing the symmetric matrix with the dissimilarities between points (usually, generated by 
#'               a call to CalcAndWriteDissimilarityMatrix or to CalcAndWriteDissimilarityMatrixDouble)
#' @return Df    Dataframe with columns PointName, NNPointName and NNDistance. See Details for description.
#' @examples
#' # Synthetic problem: 10 random seeds with coordinates in [0..20]
#' # to which random values in [-0.1..0.1] are added
#' M<-matrix(0,100,500)
#' rownames(M)<-paste0("rn",c(1:100))
#' for (i in (1:10))
#' {
#'  p<-20*runif(500)
#'  Rf <- matrix(0.2*(runif(5000)-0.5),nrow=10)
#'  for (k in (1:10))
#'  {
#'   M[10*(i-1)+k,]=p+Rf[k,]
#'  }
#' }
#' JWriteBin(M,"pamtest.bin",dtype="float",dmtype="full")
#' CalcAndWriteDissimilarityMatrix("pamtest.bin","pamDL2.bin",distype="L2",restype="float",nthreads=0)
#' L <- ApplyPAM("pamDL2.bin",10,init_method="BUILD")
#' df <- ClassifAsDataFrame(L,"pamDL2.bin")
#' df
#' # Identification of medoids:
#' which(df[,3]==0)
#' # Verification they are the same as in L (in different order)
#' L$med
#' file.remove("pamtest.bin")
#' file.remove("pamDL2.bin")
#' @export
ClassifAsDataFrame <- function(L, fdist) {
    .Call(`_parallelpam_ClassifAsDataFrame`, L, fdist)
}

#' ApplyPAM
#'
#' A function to implement the Partitioning-around-medoids algorithm described in\cr 
#' Schubert, E. and Rousseeuw, P.J.: "Fast and eager k-medoids clustering: O(k) runtime improvement of the PAM, CLARA, and CLARANS algorithms."\cr
#' Information Systems, vol. 101, p. 101804, 2021.\cr
#' doi: https://doi.org/10.1016/j.is.2021.101804\cr
#' Notice that the actual values of the vectors (instances) are not needed. To recover them, look at the data matrix
#' used to generate the distance matrix.\cr
#' The number of instances, N, is not passed since dissimilarity matrix is NxN and therefore its size indicates the N value.
#' 
#' With respect to the returned value, L$med has as many components as requested medoids and\cr
#' L$clasif has as many components as instances.\cr
#' Medoids are expressed in L$med by its number in the array of points (row in the dissimilarity matrix) starting at 1 (R convention).\cr
#' L$clasif contains the number of the medoid (i.e.: the cluster) to which each instance has been assigned, according to their order in\cr
#' L$med (also from 1).\cr
#' This means that if L$clasif[p] is m, the point p belongs to the class grouped around\cr
#' medoid L$med[m].\cr
#' Moreover, if the dissimilarity matrix contains as metadata the point names, the returned are R-named vector with such names.
#' 
#' @param dissim_file  A string with the name of the binary file that contains the symmetric matrix of dissimilarities. Such matrix
#'                     should have been generated by CalcAndWriteDissimilarityMatrix and it is a matrix of type 'disttype' (in this type defined as float).
#' @param k            A possitive integer (the desired number of medoids).
#' @param init_method  One of the strings 'PREV', 'BUILD' or 'LAB'. See meaning of initialization algorithms BUILD and LAB in the original paper.\cr
#'                     'PREV' should be used exclusively to start the second part of the algorithm (optimization) from a initial set of medoids generated by a former call.\cr
#'                     Default: BUILD.
#' @param initial_med  A vector with initial medoids to start optimization. It is to be used only by the 'PREV' method and it will have been obtained as the first
#'                     element (L$med) of the two-element list returned by a previous call to this function used in just-initialize mode (max_iter=0).\cr
#'                     Default: empty vector.
#' @param max_iter     The maximum number of allowed iterations. 0 means stop immediately after finding initial medoids.\cr
#'                     Default: 1000
#' @param nthreads     For the BUILD initialization algorithm (the only part currently implemented in parallel), the number of used threads.\cr
#'                     -1 means don't use threads (serial implementation). 0 means let the program choose according to the number of cores and of points.\cr
#'                     Any other number forces this number of threads. Choosing more than the number of available cores is allowed, but discouraged.\cr
#'                     Default: 0
#' @return L["med","clasif"] A list of two numeric vectors. See section Details for more information\cr                     
#' @examples
#' # Synthetic problem: 10 random seeds with coordinates in [0..20]
#' # to which random values in [-0.1..0.1] are added
#' M<-matrix(0,100,500)
#' rownames(M)<-paste0("rn",c(1:100))
#' for (i in (1:10))
#' {
#'  p<-20*runif(500)
#'  Rf <- matrix(0.2*(runif(5000)-0.5),nrow=10)
#'  for (k in (1:10))
#'  {
#'   M[10*(i-1)+k,]=p+Rf[k,]
#'  }
#' }
#' JWriteBin(M,"pamtest.bin",dtype="float",dmtype="full")
#' CalcAndWriteDissimilarityMatrix("pamtest.bin","pamDL2.bin",distype="L2",restype="float",nthreads=0)
#' L <- ApplyPAM("pamDL2.bin",10,init_method="BUILD")
#' # Final value of sum of distances to closest medoid
#' GetTD(L,"pamDL2.bin")
#' # Medoids:
#' L$med
#' # Medoid in which each individual has been classified
#' n<-names(L$med)
#' n[L$clasif]
#' file.remove("pamtest.bin")
#' file.remove("pamDL2.bin")
#' @export
ApplyPAM <- function(dissim_file, k, init_method = "BUILD", initial_med = NULL, max_iter = 1000L, nthreads = 0L) {
    .Call(`_parallelpam_ApplyPAM`, dissim_file, k, init_method, initial_med, max_iter, nthreads)
}

#' GetTD
#'
#' Function that takes a PAM classification (as returned by ApplyPAM) and the dissimilarity matrix and returns the value of the TD function
#' (sum of dissimilarities between each point and its closest medoid, divided by the number of points).
#' This function is mainly for debugging/internal use.
#'
#' @param L            A list of two numeric vectors, L["med","clasif"], as returned by ApplyPAM (please, consult the help of ApplyPAM for details)
#' @param dissim_file  A string with the name of the binary file that contains the symmetric matrix of dissimilarities. Such matrix
#'                     should have been generated by CalcAndWriteDissimilarityMatrix and it is a matrix of type 'disttype' (currently defined as float).
#' @return TD          The value of the TD function.
#' @examples
#' # Synthetic problem: 10 random seeds with coordinates in [0..20]
#' # to which random values in [-0.1..0.1] are added
#' M<-matrix(0,100,500)
#' rownames(M)<-paste0("rn",c(1:100))
#' for (i in (1:10))
#' {
#'  p<-20*runif(500)
#'  Rf <- matrix(0.2*(runif(5000)-0.5),nrow=10)
#'  for (k in (1:10))
#'  {
#'   M[10*(i-1)+k,]=p+Rf[k,]
#'  }
#' }
#' JWriteBin(M,"pamtest.bin",dtype="float",dmtype="full")
#' CalcAndWriteDissimilarityMatrix("pamtest.bin","pamDL2.bin",distype="L2",restype="float",nthreads=0)
#' L <- ApplyPAM("pamDL2.bin",10,init_method="BUILD")
#' # Final value of sum of distances to closest medoid
#' GetTD(L,"pamDL2.bin")
#' @export
GetTD <- function(L, dissim_file) {
    .Call(`_parallelpam_GetTD`, L, dissim_file)
}

#' GetJCol
#'
#' Returns (as a R numeric vector) the requested column number from the matrix contained in a jmatrix binary file
#'
#' @param fname  String with the file name that contains the binary data.
#' @param ncol   The number of the column to be returned, in R-numbering (from 1)
#' @return       A numeric vector with the values of elements in the requested column
#' @examples
#' Rf <- matrix(runif(48),nrow=6)
#' rownames(Rf) <- c("A","B","C","D","E","F")
#' colnames(Rf) <- c("a","b","c","d","e","f","g","h")
#' JWriteBin(Rf,"Rfullfloat.bin",dtype="float",dmtype="full",comment="Full matrix of floats")
#' Rf[,3]
#' vf<-GetJCol("Rfullfloat.bin",3)
#' vf
#' file.remove("Rfullfloat.bin")
#' @export
GetJCol <- function(fname, ncol) {
    .Call(`_parallelpam_GetJCol`, fname, ncol)
}

#' GetJManyCols
#'
#' Returns (as a R numeric matrix) the columns with the requested column numbers from the matrix contained in a jmatrix binary file
#'
#' @param fname    String with the file name that contains the binary data.
#' @param extcols  A numeric vector with the indexes of the columns to be extracted, in R-numbering (from 1)
#' @return         A numeric matrix with the values of elements in the requested columns
#' @examples
#' Rf <- matrix(runif(48),nrow=6)
#' rownames(Rf) <- c("A","B","C","D","E","F")
#' colnames(Rf) <- c("a","b","c","d","e","f","g","h")
#' JWriteBin(Rf,"Rfullfloat.bin",dtype="float",dmtype="full",comment="Full matrix of floats")
#' Rf[,c(1,4)]
#' vc<-GetJManyCols("Rfullfloat.bin",c(1,4))
#' vc
#' file.remove("Rfullfloat.bin")
#' @export
GetJManyCols <- function(fname, extcols) {
    .Call(`_parallelpam_GetJManyCols`, fname, extcols)
}

#' GetJColByName
#'
#' Returns (as a R numeric vector) the requested named column from the matrix contained in a jmatrix binary file
#'
#' @param fname   String with the file name that contains the binary data.
#' @param colname The name of the column to be returned. If the matrix has no column names, or the name is not found, an empty vector is returned
#' @return        A numeric vector with the values of elements in the requested column
#' @examples
#' Rf <- matrix(runif(48),nrow=6)
#' rownames(Rf) <- c("A","B","C","D","E","F")
#' colnames(Rf) <- c("a","b","c","d","e","f","g","h")
#' JWriteBin(Rf,"Rfullfloat.bin",dtype="float",dmtype="full",comment="Full matrix of floats")
#' Rf[,"c"]
#' vf<-GetJColByName("Rfullfloat.bin","c")
#' vf
#' file.remove("Rfullfloat.bin")
#' @export
GetJColByName <- function(fname, colname) {
    .Call(`_parallelpam_GetJColByName`, fname, colname)
}

#' GetJManyColsByNames
#'
#' Returns (as a R numeric matrix) the columns with the requested column names from the matrix contained in a jmatrix binary file
#'
#' @param fname        String with the file name that contains the binary data.
#' @param extcolnames  A numeric vector with the names of the columns to be extracted. If the binary file has no column names, or _any_ of the column names is not present, an empty matrix is returned.
#' @return             A numeric matrix with the values of elements in the requested columns
#' @examples
#' Rf <- matrix(runif(48),nrow=6)
#' rownames(Rf) <- c("A","B","C","D","E","F")
#' colnames(Rf) <- c("a","b","c","d","e","f","g","h")
#' JWriteBin(Rf,"Rfullfloat.bin",dtype="float",dmtype="full",comment="Full matrix of floats")
#' Rf[,c(1,4)]
#' vf<-GetJManyColsByNames("Rfullfloat.bin",c("a","d"))
#' vf
#' file.remove("Rfullfloat.bin")
#' @export
GetJManyColsByNames <- function(fname, extcolnames) {
    .Call(`_parallelpam_GetJManyColsByNames`, fname, extcolnames)
}

#' GetSubdiag
#' 
#' Takes a symmetric matrix and returns a vector with all its elements under the main diagonal (without those at the diagonal itself)
#' Done as an instrumental function to check the PAM in package cluster. To be removed in final version of the package.
#'
#' @param    fname The name of the file with the dissimilarity matrix in jmatrix binary format.
#' @return   The vector with the values under the main diagonal, sorted by columns (i.e.: m(2,1) .. m(n,1), m(3,2)..m(n,2),..., m(n-1,n))
#' @examples
#' Rns <- matrix(runif(49),nrow=7)
#' Rsym <- 0.5*(Rns+t(Rns))
#' rownames(Rsym) <- c("A","B","C","D","E","F","G")
#' colnames(Rsym) <- c("a","b","c","d","e","f","g")
#' JWriteBin(Rsym,"Rsymfloat.bin",dtype="float",dmtype="symmetric")
#' d<-GetSubdiag("Rsymfloat.bin")
#' Rsym
#' d
#' file.remove("Rsymfloat.bin")
#' @export
GetSubdiag <- function(fname) {
    .Call(`_parallelpam_GetSubdiag`, fname)
}

#' GetJRow
#'
#' Returns (as a R numeric vector) the requested row number from the matrix contained in a jmatrix binary file
#'
#' @param fname  String with the file name that contains the binary data.
#' @param nrow   The number of the row to be returned, in R-numbering (from 1)
#' @return       A numeric vector with the values of elements in the requested row
#' @examples
#' Rf <- matrix(runif(48),nrow=6)
#' rownames(Rf) <- c("A","B","C","D","E","F")
#' colnames(Rf) <- c("a","b","c","d","e","f","g","h")
#' JWriteBin(Rf,"Rfullfloat.bin",dtype="float",dmtype="full",comment="Full matrix of floats")
#' Rf[3,]
#' vf<-GetJRow("Rfullfloat.bin",3)
#' vf
#' file.remove("Rfullfloat.bin")
#' @export
GetJRow <- function(fname, nrow) {
    .Call(`_parallelpam_GetJRow`, fname, nrow)
}

#' GetJManyRows
#'
#' Returns (as a R numeric matrix) the rows with the requested row numbers from the matrix contained in a jmatrix binary file
#'
#' @param fname    String with the file name that contains the binary data.
#' @param extrows  A numeric vector with the indexes of the rows to be extracted, in R-numbering (from 1)
#' @return         A numeric matrix with the values of elements in the requested rows
#' @examples
#' Rf <- matrix(runif(48),nrow=6)
#' rownames(Rf) <- c("A","B","C","D","E","F")
#' colnames(Rf) <- c("a","b","c","d","e","f","g","h")
#' JWriteBin(Rf,"Rfullfloat.bin",dtype="float",dmtype="full",comment="Full matrix of floats")
#' Rf[c(1,4),]
#' vc<-GetJManyRows("Rfullfloat.bin",c(1,4))
#' vc
#' file.remove("Rfullfloat.bin")
#' @export
GetJManyRows <- function(fname, extrows) {
    .Call(`_parallelpam_GetJManyRows`, fname, extrows)
}

#' GetJRowByName
#'
#' Returns (as a R numeric vector) the requested named row from the matrix contained in a jmatrix binary file
#'
#' @param fname   String with the file name that contains the binary data.
#' @param rowname The name of the row to be returned. If the matrix has no row names, or the name is not found, an empty vector is returned
#' @return        A numeric vector with the values of elements in the requested row
#' @examples
#' Rf <- matrix(runif(48),nrow=6)
#' rownames(Rf) <- c("A","B","C","D","E","F")
#' colnames(Rf) <- c("a","b","c","d","e","f","g","h")
#' JWriteBin(Rf,"Rfullfloat.bin",dtype="float",dmtype="full",comment="Full matrix of floats")
#' Rf["C",]
#' vf<-GetJRowByName("Rfullfloat.bin","C")
#' vf
#' file.remove("Rfullfloat.bin")
#' @export
GetJRowByName <- function(fname, rowname) {
    .Call(`_parallelpam_GetJRowByName`, fname, rowname)
}

#' GetJManyRowsByNames
#'
#' Returns (as a R numeric matrix) the rows with the requested row names from the matrix contained in a jmatrix binary file
#'
#' @param fname        String with the file name that contains the binary data.
#' @param extrownames  A numeric vector with the names of the rows to be extracted. If the binary file has no row names, or _any_ of the row names is not present, an empty matrix is returned.
#' @return             A numeric matrix with the values of elements in the requested rows
#' @examples
#' Rf <- matrix(runif(48),nrow=6)
#' rownames(Rf) <- c("A","B","C","D","E","F")
#' colnames(Rf) <- c("a","b","c","d","e","f","g","h")
#' JWriteBin(Rf,"Rfullfloat.bin",dtype="float",dmtype="full",comment="Full matrix of floats")
#' Rf[c("A","C"),]
#' vf<-GetJManyRowsByNames("Rfullfloat.bin",c("A","C"))
#' vf
#' file.remove("Rfullfloat.bin")
#' @export
GetJManyRowsByNames <- function(fname, extrownames) {
    .Call(`_parallelpam_GetJManyRowsByNames`, fname, extrownames)
}

#' JMatInfo
#'
#' Shows in the screen or writes to a file information about a matrix stored in the binary format of package jmatrix
#'
#' @param fname  String with the file name that contains the binary data.
#' @param fres   String with the name of the file to write the information. Default: "" (information is written to the console)
#' @return       No return value, called for its side effects (writes on screen or creates a file)
#' @examples
#' Rf <- matrix(runif(48),nrow=6)
#' rownames(Rf) <- c("A","B","C","D","E","F")
#' colnames(Rf) <- c("a","b","c","d","e","f","g","h")
#' JWriteBin(Rf,"Rfullfloat.bin",dtype="float",dmtype="full",comment="Full matrix of floats")
#' JMatInfo("Rfullfloat.bin")
#' file.remove("Rfullfloat.bin")
#' @export
JMatInfo <- function(fname, fres = "") {
    invisible(.Call(`_parallelpam_JMatInfo`, fname, fres))
}

#' GetJRowNames
#'
#' Returns a R StringVector with the row names of a matrix stored in the binary format of package jmatrix, if it has them stored.
#'
#' @param  fname  String with the file name that contains the binary data.
#' @return A R StringVector with the row names, or the empty vector if the binary file has no row names as metadata.
#' @examples
#' Rf <- matrix(runif(48),nrow=6)
#' rownames(Rf) <- c("A","B","C","D","E","F")
#' colnames(Rf) <- c("a","b","c","d","e","f","g","h")
#' JWriteBin(Rf,"Rfullfloat.bin",dtype="float",dmtype="full",comment="Full matrix of floats")
#' rn<-GetJRowNames("Rfullfloat.bin")
#' rn
#' file.remove("Rfullfloat.bin")
#' @export
GetJRowNames <- function(fname) {
    .Call(`_parallelpam_GetJRowNames`, fname)
}

#' GetJColNames
#'
#' Returns a R StringVector with the column names of a matrix stored in the binary format of package jmatrix, if it has them stored.
#'
#' @param fname  String with the file name that contains the binary data.
#' @return A R StringVector with the column names, or the empty vector if the binaryfile has no row column names as metadata.
#' @examples
#' Rf <- matrix(runif(48),nrow=6)
#' rownames(Rf) <- c("A","B","C","D","E","F")
#' colnames(Rf) <- c("a","b","c","d","e","f","g","h")
#' JWriteBin(Rf,"Rfullfloat.bin",dtype="float",dmtype="full",comment="Full matrix of floats")
#' cn<-GetJColNames("Rfullfloat.bin")
#' cn
#' file.remove("Rfullfloat.bin")
#' @export
GetJColNames <- function(fname) {
    .Call(`_parallelpam_GetJColNames`, fname)
}

#' GetJNames
#'
#' Returns a R list of two elements, rownames and colnames, each of them being a R StringVector with the corresponding names
#'
#' @param fname  String with the file name that contains the binary data.
#' @return N["rownames","colnames"]: A list with two elements named rownames and colnames which are R StringVectors.
#'         If the binary file has no row or column names as metadata BOTH will be returned as empty vectors, even if one of them exists.
#'         If you want to extract only one, use either GetBinRowNames or GetBinColNames, as appropriate.
#' @examples
#' Rf <- matrix(runif(48),nrow=6)
#' rownames(Rf) <- c("A","B","C","D","E","F")
#' colnames(Rf) <- c("a","b","c","d","e","f","g","h")
#' JWriteBin(Rf,"Rfullfloat.bin",dtype="float",dmtype="full",comment="Full matrix of floats")
#' N<-GetJNames("Rfullfloat.bin")
#' N["rownames"]
#' N["colnames"]
#' file.remove("Rfullfloat.bin")
#' @export
GetJNames <- function(fname) {
    .Call(`_parallelpam_GetJNames`, fname)
}

#' JWriteBin
#'
#' Writes a R matrix to a disk file as a binary matrix in the jmatrix format
#'
#'
#' Use this function cautiously. Differently to the functions to get one or more rows or columns from the binary file,
#' which book only the memory strictly needed for the vector/matrix and do not load all the binary file in memory,
#' this function books the full matrix in the requested data type and writes it later so with very big matrices
#' you might run out of memory.\cr
#' Type 'int' is really long int (8-bytes in most modern machines) so using 'int' or 'long' is equivalent.\cr
#' Type is coerced from double (the internal type of R matrices) to the requested type, which may provoke a loose of precision.\cr
#' If M is a named-R matrix, row and column names are written as metadata, too.\cr
#' Also, if you write as symmetric a matrix which is not such, only the lower-diagonal part will be written.
#' The rest of the data will be lost. In this case, if the matrix has row and column names, only row names are written.
#'
#' @param    M The R matrix to be written
#' @param    fname The name of the file to write
#' @param    dtype The data type of the matrix to be written: one of the strings 'short', 'int', 'long', 'float' or 'double'. Default: 'float'
#' @param    dmtype The matrix type: one of the strings 'full', 'sparse' or 'symmetric'. Default: 'full'
#' @param    comment A optional string with the comment to be added as metadata. Default: "" (empty string, no added comment)
#' @return   No return value, called for side effects (creates a file)
#' @examples
#' Rf <- matrix(runif(48),nrow=6)
#' rownames(Rf) <- c("A","B","C","D","E","F")
#' colnames(Rf) <- c("a","b","c","d","e","f","g","h")
#' JWriteBin(Rf,"Rfullfloat.bin",dtype="float",dmtype="full",comment="Full matrix of floats")
#' file.remove("Rfullfloat.bin")
#' @export
JWriteBin <- function(M, fname, dtype = "float", dmtype = "full", comment = "") {
    invisible(.Call(`_parallelpam_JWriteBin`, M, fname, dtype, dmtype, comment))
}

#' CalculateSilhouette
#'
#' Calculates the silhouette of each point of those classified by a clustering algorithm.
#'
#' 
#' @param cl        The array of classification with the number of the class to which each point belongs to. This number must be in 1..number_of_classes.\cr
#'                  This function takes something like the L$clasif array which is the second element of the list returned by ApplyPAM
#' @param fdist     The binary file containing the symmetric matrix with the dissimilarities between points (usually, generated by a call to CalcAndWriteDissimilarityMatrix)
#' @param nthreads  The number of used threads.\cr
#'                  -1 means don't use threads (serial implementation). 0 means let the program choose according to the number of cores and of points.\cr
#'                   Any other number forces this number of threads. Choosing more than the number of available cores is allowed, but discouraged.\cr
#'                   Default: 0
#' @return sil       Numeric vector with the values of the silhouette for each point, in the same order in which points are in cl.\cr
#'                   If cl is a named vector sill will be a named vector, too, with the same names.
#' @examples
#' # Synthetic problem: 10 random seeds with coordinates in [0..20]
#' # to which random values in [-0.1..0.1] are added
#' M<-matrix(0,100,500)
#' rownames(M)<-paste0("rn",c(1:100))
#' for (i in (1:10))
#' {
#'  p<-20*runif(500)
#'  Rf <- matrix(0.2*(runif(5000)-0.5),nrow=10)
#'  for (k in (1:10))
#'  {
#'   M[10*(i-1)+k,]=p+Rf[k,]
#'  }
#' }
#' JWriteBin(M,"pamtest.bin",dtype="float",dmtype="full")
#' CalcAndWriteDissimilarityMatrix("pamtest.bin","pamDL2.bin",distype="L2",restype="float",nthreads=0)
#' L <- ApplyPAM("pamDL2.bin",10,init_method="BUILD")
#' sil <- CalculateSilhouette(L$clasif,"pamDL2.bin")
#' # Histogram of the silhouette. In this synthetic problem, almost 1 for all points
#' hist(sil)
#' file.remove("pamtest.bin")
#' file.remove("pamDL2.bin")
#' @export
CalculateSilhouette <- function(cl, fdist, nthreads = 0L) {
    .Call(`_parallelpam_CalculateSilhouette`, cl, fdist, nthreads)
}

#' NumSilToClusterSil
#'
#' Takes a silhouette in the form of a NumericVector, as returned by CalculateSilhouette, and returns it as a numeric matrix appropriate to be plotted by the package 'cluster'
#'
#' @param cl        The array of classification with the number of the class to which each point belongs to. This number must be in 1..number_of_classes.\cr
#'                  This function takes something like the L$clasif array which is the second element of the list returned by ApplyPAM
#' @param s         The numeric value of the silhouette for each point, with points in the same order as they appear in cl.\cr
#'                  This is the vector returned by after a call to CalculateSilhouette with the same value of parameter cl.
#' @return sp       A silhouette in the format of the cluster package which is a NumericMatrix of as many rows as points and three columns: cluster, neighbor and sil_width.\cr
#'                  Its structure and dimension names are as in package 'cluster', which allows to use it with the silhouette plotting functions of such package\cr
#'                  This means you can do library(cluster) followed by plot(NumSilToClusterSil(cl,s)) to get a beatiful plot.
#' @examples
#' # Synthetic problem: 10 random seeds with coordinates in [0..20]
#' # to which random values in [-0.1..0.1] are added
#' M<-matrix(0,100,500)
#' rownames(M)<-paste0("rn",c(1:100))
#' for (i in (1:10))
#' {
#'  p<-20*runif(500)
#'  Rf <- matrix(0.2*(runif(5000)-0.5),nrow=10)
#'  for (k in (1:10))
#'  {
#'   M[10*(i-1)+k,]=p+Rf[k,]
#'  }
#' }
#' JWriteBin(M,"pamtest.bin",dtype="float",dmtype="full")
#' CalcAndWriteDissimilarityMatrix("pamtest.bin","pamDL2.bin",distype="L2",restype="float",nthreads=0)
#' L <- ApplyPAM("pamDL2.bin",10,init_method="BUILD")
#' sil <- CalculateSilhouette(L$clasif,"pamDL2.bin")
#' sp <- NumSilToClusterSil(L$clasif,sil)
#' # Here you can install and load package cluster and make plot(sp)
#' file.remove("pamtest.bin")
#' file.remove("pamDL2.bin")
#' @export
NumSilToClusterSil <- function(cl, s) {
    .Call(`_parallelpam_NumSilToClusterSil`, cl, s)
}

