% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importTreeSummarizedExperiment.R
\name{importTreeSummarizedExperiment}
\alias{importTreeSummarizedExperiment}
\title{Import TreeSummarizedExperiment object for PARAFAC modelling}
\usage{
importTreeSummarizedExperiment(
  treeObject,
  subjectIDs,
  thirdMode,
  taxa_are_rows
)
}
\arguments{
\item{treeObject}{TreeSummarizedExperiment object containing at least an OTU table and sample information, preferably also taxonomic information.}

\item{subjectIDs}{Column name in the sample information corresponding to the subject IDs.}

\item{thirdMode}{Column name in the sample information corresponding to the study design aspect to put in the third mode of the data cube.}

\item{taxa_are_rows}{Boolean specifying if the taxa are in the rows of the OTU table (TRUE) or not (FALSE).}
}
\value{
List object containing:
\itemize{
\item 'data': data cube
\item 'mode1': metadata of the subject mode
\item 'mode2': taxonomy information
\item 'mode3': metadata of the third mode
}
}
\description{
Import TreeSummarizedExperiment object for PARAFAC modelling
}
\examples{
\dontshow{if (rlang::is_installed("TreeSummarizedExperiment")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(TreeSummarizedExperiment)

fakeOTU = t(rTensor::k_unfold(rTensor::as.tensor(Fujita2023$data), 2)@data)
fakeTaxa = as.matrix(Fujita2023$mode2)
fakeSam = as.data.frame(cbind(rep(1:8, 110), rep(1:110, each=8)))
colnames(fakeSam) = c("replicate.id", "timepoint")

fakeTreeObj = TreeSummarizedExperiment(assays = list(Count = fakeOTU),
                                      rowData = fakeSam,
                                      colData = fakeTaxa)
dataset = importTreeSummarizedExperiment(fakeTreeObj,
                                         subjectIDs="replicate.id",
                                         thirdMode="timepoint",
                                         taxa_are_rows=FALSE)
\dontshow{\}) # examplesIf}
}
