% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optional.R
\name{make_opt}
\alias{make_opt}
\title{Make optional}
\usage{
make_opt(fun, stop_if_none = FALSE, fun_if_none = NULL)
}
\arguments{
\item{fun}{The function to make optional, might be any 
function.}

\item{stop_if_none}{If true, \code{f_opt()} will stop and return 
\code{none} if one of the arguments provided 
is \code{none}. Else, \code{none} will be 
sent as \code{NULL} to the function.
*Default: FALSE*}

\item{fun_if_none}{If not null, will be executed if an argument
is \code{none}.
*Default: NULL*}
}
\value{
The optional function. To be used with the
                             same parameters than \code{fun()}.
}
\description{
Make an existing function accepting and returning optionals.
}
\details{
\enumerate{
  \item Every optional argument passed to \code{f_opt()} will be  
        converted to its original type before being sent 
        to \code{f()}. If one or more of them is \code{none},  
        several behaviors are available (see argument list).
  \item If \code{f()} returns null, or if an error is thrown 
        during its execution, then \code{f_opt()} returns 
        \code{none}. Else it will return  \code{some(f(...))}.
}
}
\examples{
c_opt <- make_opt(c)
c_opt(some(2), none, some(5))
## [1] 2 5
c_opt()
## [1] "None"
}
\seealso{
some(), none(), match_with()
}

