% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot.R
\name{pivotEstimates}
\alias{pivotEstimates}
\title{Set estimates as columns}
\usage{
pivotEstimates(result, pivotEstimatesBy = "estimate_name", nameStyle = NULL)
}
\arguments{
\item{result}{A \verb{<summarised_result>}.}

\item{pivotEstimatesBy}{Names from which pivot wider the estimate values. If
NULL the table will not be pivotted.}

\item{nameStyle}{Name style (glue package specifications) to customise names
when pivotting estimates. If NULL standard tidyr::pivot_wider formatting will
be used.}
}
\value{
A tibble.
}
\description{
Pivot the estimates as new columns in result table.
}
\examples{
{
  library(dplyr)
  library(omopgenerics)

  x <- tibble(
    "result_id" = 1L,
    "cdm_name" = c("cprd", "eunomia"),
    "group_name" = "cohort_name",
    "group_level" = "my_cohort",
    "strata_name" = "sex",
    "strata_level" = "male",
    "variable_name" = "Age group",
    "variable_level" = "10 to 50",
    "estimate_name" = "count",
    "estimate_type" = "numeric",
    "estimate_value" = "5",
    "additional_name" = "overall",
    "additional_level" = "overall"
  ) |>
    newSummarisedResult()

  x |>
    pivotEstimates()
}

}
