% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_diffnet2.R
\name{weighted_var}
\alias{weighted_var}
\alias{wvar}
\title{Computes weighted variance}
\usage{
weighted_var(x, w)

wvar(x, w)
}
\arguments{
\item{x}{A numeric vector of length \eqn{n}.}

\item{w}{A numeric vector of length \eqn{n}.}
}
\value{
Numeric scalar with the weighted variance.
}
\description{
Computes weighted variance
}
\details{
\code{weighted_variance} implements weighted variance computation
in the following form:
\deqn{%
\frac{\sum_i w_i'(x_i - \bar x)^2}{(1-n)}
}{%
sum[w(i)'(x(i) - w.mean(x))^2/(1-n)]
}

where \eqn{w_i'=w_i/\sum_i w_i}{w(i)' = w(i)/sum(w)}, and
\eqn{\bar x = \sum_i w_i'x_i}{w.mean(x)=sum[w(i)'*x(i)]}.
}
\seealso{
This function is used in \code{\link{diffmap}}.
}
