% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_graph.R
\name{rewire_graph}
\alias{rewire_graph}
\title{Rewires a graph}
\usage{
rewire_graph(graph, p, both.ends = FALSE, self = FALSE, multiple = FALSE,
  undirected = getOption("diffnet.undirected"))
}
\arguments{
\item{graph}{Any class of accepted graph format (see \code{\link{netdiffuseR-graphs}})}

\item{p}{Numeric scalar. Set the probability of changing an edge.}

\item{both.ends}{Logical scalar. When \code{TRUE} rewires both ends.}

\item{self}{Logical scalar. When \code{TRUE}, allows loops (self edges).}

\item{multiple}{Logical scalar. When \code{TRUE} allows multiple edges.}

\item{undirected}{Logical scalar. \code{TRUE} when the graph is undirected.}
}
\description{
By changing the endpoints of the edges, this is the workhorse of the
function \code{\link{rgraph_ws}}.
}
\details{
Rewiring assumes a weighted network, hence \eqn{G(i,j) = k = G(i',j')},
where \eqn{i',j'} are the new end points of the edge and \eqn{k} may not be equal
to one.
}
\author{
Vega Yon
}
\seealso{
Other simulation functions: \code{\link{rdiffnet}},
  \code{\link{rgraph_ba}}, \code{\link{rgraph_er}},
  \code{\link{rgraph_ws}}
}

