% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{exposure}
\alias{exposure}
\title{Ego exposure}
\usage{
exposure(graph, cumadopt, attrs = NULL, alt.graph = NULL, outgoing = TRUE,
  valued = getOption("diffnet.valued"), normalized = TRUE)
}
\arguments{
\item{graph}{A dynamic graph (see \code{\link{netdiffuseR-graphs}}).}

\item{cumadopt}{nxT matrix. Cumulative adoption matrix obtained from
\code{\link{toa_mat}}}

\item{attrs}{A numeric matrix of size \eqn{n\times T}{n * T}. Weighting for each time, period (see details).}

\item{alt.graph}{A dynamic graph that should be used instead of \code{graph} (see details).}

\item{outgoing}{Logical scalar. When TRUE, computed using outgoing ties.}

\item{valued}{Logical scalar. When FALSE, values of \code{graph} are set to one.}

\item{normalized}{Logical scalar. When true, the exposure will be between zero
and one (see details).}
}
\value{
A matrix of size \eqn{n\times T}{n * T} with exposure for each node.
}
\description{
Calculates exposure to adoption over time via multiple different types of weight
matrices.  The basic  model is exposure to adoption by immediate neighbors
(outdegree) at the time period prior to ego’s adoption. This exposure can also be
based on (1) incoming ties, (2) structural equivalence, (3) indirect ties, (4)
attribute weighted (5) network-metric weighted (e.g., central nodes have more
influence), and attribute-weighted (e.g., based on homophily or tie strength).
}
\details{
Exposure is calculated as follows:

\deqn{ %
E_t = \left(S_t \times \left[x_t \circ A_t\right]\right) / (S_t \times x_t) %
}{%
E(t) = (S(t) \%*\% [x(t) * A(t)]) / [S(t) \%*\% x(t)]
}

Where \eqn{S_t}{S(t)} is the graph in time \eqn{t}, \eqn{x_t}{x(t)} is an attribute
vector of size \eqn{n} at time \eqn{t}, \eqn{A_t}{A(t)} is the t-th column of
the cumulative adopters matrix (a vector of length \eqn{n} with \eqn{a_{ti}=1}{a(t,i)=1}
if \eqn{i} has adopted at or prior to \eqn{t}), \eqn{\circ}{*} is the kronecker
product (element-wise), and \eqn{\times}{\%*\%} is the matrix product.

By default the graph used for this calculation, \eqn{S}, is the social network. Alternatively,
in the case of \code{diffnet} objects, the user can provide an alaternative
graph using \code{alt.graph}. An example of this would be using \eqn{1/SE},
the element-wise inverse of the structural equivalence matrix (see example below).

If the user does not specifies a particular weighting attribute in \code{attrs},
the function sets this as a matrix of ones. Otherwise the function will return
an attribute weighted exposure. See the examples section for a demonstration using
degree.

When \code{outgoing=FALSE}, \eqn{S} is replaced by its transposed, so in the
case of a social network exposure will be computed based on the incomming ties.
}
\examples{
# Calculating the exposure based on Structural Equivalence ------------------
set.seed(113132)
graph <- rdiffnet(100, 10)

SE <- lapply(struct_equiv(graph), "[[", "SE")
SE <- lapply(SE, function(x) 1/(x + 1e-15))
eSE <- exposure(graph, alt.graph=SE)
eNO <- exposure(graph)
any(eSE != eNO) # Different outputs

# Weighted Exposure using degree --------------------------------------------
eDE <- exposure(graph, attrs=dgr(graph))
any(eNO != eDE) # Different outputs

# Comparing using incomming edges -------------------------------------------
eIN <- exposure(graph, outgoing=FALSE)
any(eIN != eNO) # Different outputs

}
\author{
Vega Yon, Dyal, Hayes & Valente
}
\references{
Burt, R. S. (1987). "Social Contagion and Innovation: Cohesion versus Structural
Equivalence". American Journal of Sociology, 92(6), 1287.
\url{http://doi.org/10.1086/228667}

Valente, T. W. (1995). "Network models of the diffusion of innovations"
 (2nd ed.). Cresskill N.J.: Hampton Press.
}
\seealso{
Other statistics: \code{\link{cumulative_adopt_count}},
  \code{\link{dgr}}, \code{\link{hazard_rate}},
  \code{\link{infection}}, \code{\link{moran}},
  \code{\link{struct_equiv}}, \code{\link{threshold}}
}
\keyword{univar}

