## ----Setup, echo=FALSE---------------------------------------------------
doctype <- knitr::opts_knit$get("rmarkdown.pandoc.to")

# Whether is html or not
ishtml <- !is.null(doctype) && doctype=='html'
knitr::opts_chunk$set(fig.height=5, fig.width=8, fig.align="center", 
                      out.width=ifelse(ishtml, 600, ".8\\linewidth"))

## ------------------------------------------------------------------------
library(netdiffuseR)

## ------------------------------------------------------------------------
# Generating a random graph
set.seed(1234)
n <- 100
nper <- 20
graph <- rgraph_er(n,nper, p=.40, undirected = FALSE)
toa <- sample(1:(1+nper-1), n, TRUE)
head(toa)

# Creating a diffnet object
diffnet <- as_diffnet(graph, toa)

# Visualizing distribution of suscep/infect
out <- plot_infectsuscep(graph, toa, K=1, logscale = TRUE)

## ------------------------------------------------------------------------
plot_infectsuscep(diffnet, K=1, logscale = TRUE)

## ---- fig.height=8-------------------------------------------------------
# Generating a random graph
set.seed(123)
n <- 6
nper <- 5
toa  <- sample(2000:(2000+nper-1), n, TRUE)
nper <- length(unique(toa))
graph <- rgraph_er(n,nper, p=.3, undirected = FALSE)
adopt <- toa_mat(toa)

# Computing exposure
expos <- exposure(graph, adopt$cumadopt)

x<-plot_threshold(graph, expos, toa, undirected = FALSE)
plot_threshold(graph, expos, toa, vertex.cex = 1/4)

# Not everybody adopted!
toa[2] <- NA

adopt <- toa_mat(toa)

# Computing exposure
expos <- exposure(graph, adopt$cumadopt)

plot_threshold(graph, expos, toa, undirected = FALSE)
plot_threshold(graph, expos, toa, vertex.cex = 1/4)

## ------------------------------------------------------------------------
plot_diffnet(graph, adopt$cumadopt)

