\name{boot.err}
\alias{boot.err}
\title{Calculate .632 and .632+ Bootstrap Error Rate}

\description{
  Calculate .632 bootstrap and .632 plus bootstrap error rate.
}

\usage{
boot.err(err, resub)       
}

\arguments{
  \item{err}{ Average error rate of bootstrap samples.}
  \item{resub}{ A list including apparent error rate, class label and
    the predicted class label of the original training data (not resampled
    training data). Can be generated by \code{\link{classifier}}.
  }
}

\value{
  A list with the following components:
  \item{ae}{Apparent error rate.}
  \item{boot}{Average error rate of bootstrap samples(Same as \code{err})}
  \item{b632 }{.632 bootstrap error rate.}
  \item{b632p}{.632 plus bootstrap error rate.}
}

\references{
  Witten, I. H. and Frank, E. (2005) \emph{Data Mining - Practical
  Machine Learning and Techniques}. Elsevier.
  
  Efron, B. and Tibshirani, R. (1993) \emph{An Introduction to the
  Bootstrap}. Chapman & Hall.
  
  Efron, B. and Tibshirani, R. (1997) Improvements on cross-validation:
  the .632+ bootstrap method. \emph{Journal of the American Statistical
  Association}, \bold{92}, 548-560.
}

% ----------------------------------------------------------------------
\author{
  Wanchang Lin 
}

\seealso{
  \code{\link{classifier}}
}

\examples{
## iris data set
data(iris)
x      <- subset(iris, select = -Species)
y      <- iris$Species

## 10 bootstrap training samples 
pars   <- valipars(sampling = "boot", niter = 1, nreps = 10)
tr.idx <- trainind(y, pars=pars)[[1]]

## bootstrap error rate
err <- sapply(tr.idx, function(i){
  pred <- classifier(x[i,,drop = FALSE],y[i],x[-i,,drop = FALSE],y[-i], 
                     method = "knn")$err
})

## average bootstrap error rate
err <- mean(err)

## apparent error rate
resub  <- classifier(x,y,method = "knn")

## 
err.boot <- boot.err(err, resub)

}

\keyword{classif}
