% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mt_interpolate.R
\name{mt_interpolate}
\alias{mt_interpolate}
\title{Linearly interpolate locations}
\usage{
mt_interpolate(x, time, max_time_lag, omit = FALSE)
}
\arguments{
\item{x}{A \code{move2} object}

\item{time}{The times to interpolate to, if missing the interpolation is to the empty locations.
Alternatively if the timestamps in \code{x} are \code{POSIXct} then also an interval can be provided.
For details on the interval specification see \code{\link[lubridate]{floor_date}}.}

\item{max_time_lag}{The maximal time lag to interpolate over, if not provided any interval is interpolated}

\item{omit}{If the original location that do not match a value in \code{time} should be omitted. This only
takes affect when \code{time} is not missing.}
}
\value{
A \code{move2} object with the interpolated locations
}
\description{
Linear interpolation along the straight line between consecutive locations.
}
\details{
Each interpolation is done along a straight path from the previous to the next location.
Interpolation is done with \code{\link[sf]{st_line_sample}} when there is no CRS provided and \code{\link[s2]{s2_interpolate_normalized}} when the data has a projection.
}
\examples{
data <- mt_sim_brownian_motion(t = c(0, 0.6, 3, 3.5))
## interpolating at specific times
mt_interpolate(data, c(.5, 1.5, 2.5))
## interpolating to empty locations
data$geometry[c(1, 3)] <- sf::st_point() ## creating empty locations
mt_interpolate(data)
\dontshow{if (parallel::detectCores() < 9) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
fishers <- mt_read(mt_example())[1:200, ]
mt_interpolate(fishers, "2 hours")
## omit the original records
mt_interpolate(fishers, "2 hours", omit = TRUE)
\dontshow{\}) # examplesIf}
}
