% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intlinprog.R
\name{intlinprog}
\alias{intlinprog}
\title{MatLab(R)-style Mixed Integer Linear Programming in R using ROI}
\usage{
intlinprog(f, intcon = NULL, A = NULL, b = NULL, Aeq = NULL,
  beq = NULL, lb = NULL, ub = NULL, x0 = NULL, options = NULL)
}
\arguments{
\item{f}{Linear term (vector) of the objective function}

\item{intcon}{Vector of which variables are integer}

\item{A}{Inequality constraints (left-hand side)}

\item{b}{Inequality constraints (right-hand side)}

\item{Aeq}{Equality constraints (left-hand side)}

\item{beq}{Equality constraints (right-hand side)}

\item{lb}{Lower bound}

\item{ub}{Upper bound}

\item{x0}{Initial solution}

\item{options}{Additional optimization parameters}
}
\value{
The solution vector in \code{x} as well as the objective value
in \code{fval}.
}
\description{
\code{intlinprog} provides a simple interface to ROI using the optimization
model specification of MatLab(R)

minimize in x: f'*x
subject to
  A*x <= b 
  Aeq*x == beq
  x >= lb
  x <= ub
}
\examples{
# minimize 8x1 + x2
# subject to
#   x1 + 2x2 >= -14
#   -4x1 - 1x2 <= -33
#   2x1 + x2 <= 20
#   x1, x2 integer

f <- c(8, 1)
A <- matrix(c(-1, -2, -4, -1, 2, 1), nrow=3, byrow=TRUE)
b <- c(14, -33, 20)

sol <- intlinprog(f, c(1, 2), A, b)
sol <- intlinprog(f, NULL, A, b)

sol$x

}
\author{
Ronald Hochreiter, \email{ron@hochreiter.net}
}
