#' Watson churn data
#'
#' @details These data were downloaded from the IBM Watson site
#'  (see below) in September 2018. The data contain a factor for
#'  whether a customer churned or not. Alternatively, the `tenure`
#'  column presumably contains information on how long the customer
#'  has had an account. A survival analysis can be done on this
#'  column using the `churn` outcome as the censoring information. A
#'  data dictionary can be found on the source website.
#'
#' @name wa_churn
#' @aliases wa_churn
#' @docType data
#' @return \item{wa_churn}{a data frame}
#'
#' @source IBM Watson Analytics https://ibm.co/2sOvyvy
#'
#' @keywords datasets
#' @examples
#' data(wa_churn)
#' str(wa_churn)
NULL
