#' Rates of Cricket Chirps
#'
#' These data are from from McDonald (2009), by way of Mangiafico (2015), on
#' the relationship between the ambient temperature and the rate of cricket
#' chirps per minute. Data were collected for two species of the genus _Oecanthus_: _O. exclamationis_
#' and _O. niveus_. The data are contained in a data frame called `crickets` with
#' a total of 31 data points.
#'
#' @name crickets
#' @aliases crickets
#' @docType data
#' @return \item{crickets}{a tibble}
#' @source Mangiafico, S. 2015. "An R Companion for the Handbook of Biological
#' Statistics." \url{https://rcompanion.org/handbook/}.
#'
#' McDonald, J. 2009. _Handbook of Biological Statistics_. Sparky House Publishing.
#' @keywords datasets
#' @examples
#' data(crickets)
#' str(crickets)
NULL
