% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataBackend.R
\docType{data}
\name{DataBackend}
\alias{DataBackend}
\title{DataBackend}
\format{\link[R6:R6Class]{R6::R6Class} object.}
\description{
This is the abstract base class for data backends.

Data Backends provide a layer of abstraction for various data storage systems.
It is not recommended to work directly with the DataBackend.
Instead, all data access is handled transparently via the \link{Task}.

To connect to out-of-memory database management systems such as SQL servers, see \CRANpkg{mlr3db}.

The required set of fields and methods to implement a custom DataBackend is listed in the respective sections.
See \link{DataBackendDataTable} or \link{DataBackendMatrix} for exemplary implementations of the interface.
}
\section{Construction}{

Note: This object is typically constructed via a derived classes, e.g. \link{DataBackendDataTable} or \link{DataBackendMatrix},
or via the S3 method \code{\link[=as_data_backend]{as_data_backend()}}.\preformatted{DataBackend$new(data, primary_key = NULL, data_formats = "data.table", converters = list())
}
\itemize{
\item \code{data} :: \code{any}\cr
The format of the input data depends on the specialization.
E.g., \link{DataBackendDataTable} expects a \code{\link[data.table:data.table]{data.table::data.table()}} and \link{DataBackendMatrix} expects a \code{\link[Matrix:Matrix]{Matrix::Matrix()}}
constructed with the \CRANpkg{Matrix} package.
\item \code{primary_key} :: \code{character(1)}\cr
Each DataBackend needs a way to address rows, which is done via a column of unique values, referenced here by \code{primary_key}.
The use of this variable may differ between backends.
\item data_formats (\code{character()})\cr
Set of supported formats, e.g. \code{"data.table"} or \code{"Matrix"}.
}
}

\section{Fields}{

\itemize{
\item \code{nrow} :: \code{integer(1)}\cr
Number of rows (observations).
\item \code{ncol} :: \code{integer(1)}\cr
Number of columns (variables), including the primary key column.
\item \code{colnames} :: \code{character()}\cr
Returns vector of all column names, including the primary key column.
\item \code{rownames} :: (\code{integer()} | \code{character()})\cr
Returns vector of all distinct row identifiers, i.e. the primary key column.
\item \code{hash} :: \code{character(1)}\cr
Returns a unique hash for this backend. This hash is cached.
\item \code{data_formats} :: \code{character()}\cr
Vector of supported data formats.
A specific format can be chosen in the \code{$data()} method.
}
}

\section{Methods}{

\itemize{
\item \code{data(rows = NULL, cols = NULL, format = "data.table")}\cr
(\code{integer()} | \code{character()}, \code{character()}) -> \code{any}\cr
Returns a slice of the data in the specified format.
Currently, the only supported formats are \code{"data.table"} and \code{"Matrix"}.
The rows must be addressed as vector of primary key values, columns must be referred to via column names.
Queries for rows with no matching row id and queries for columns with no matching column name are silently ignored.
Rows are guaranteed to be returned in the same order as \code{rows}, columns may be returned in an arbitrary order.
Duplicated row ids result in duplicated rows, duplicated column names lead to an exception.
\item \code{distinct(rows, cols, na_rm = TRUE)}\cr
(\code{integer()} | \code{character()}, \code{character()}, \code{logical(1)}) -> named \code{list()}\cr
Returns a named list of vectors of distinct values for each column specified.
If \code{na_rm} is \code{TRUE}, missing values are removed from the returned vectors of distinct values.
Non-existing rows and columns are silently ignored.

If \code{rows} is \code{NULL}, all possible distinct values will be returned, even if the value is not present in the data.
This affects factor-like variables with empty levels, if supported by the backend.
\item \code{head(n = 6)}\cr
\code{integer(1)} -> \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Returns the first up-to \code{n} rows of the data as \code{\link[data.table:data.table]{data.table::data.table()}}.
\item \code{missings(rows, cols)}\cr
(\code{integer()} | \code{character()}, \code{character()}) -> named \code{integer()}\cr
Returns the number of missing values per column in the specified slice of data.
Non-existing rows and columns are silently ignored.
}
}

\examples{
data = data.table::data.table(id = 1:5, x = runif(5), y = sample(letters[1:3], 5, replace = TRUE))

b = DataBackendDataTable$new(data, primary_key = "id")
print(b)
b$head(2)
b$data(rows = 1:2, cols = "x")
b$distinct(rows = b$rownames, "y")
b$missings(rows = b$rownames, cols = names(data))
}
\seealso{
Extension Packages: \CRANpkg{mlr3db}

Other DataBackend: \code{\link{DataBackendDataTable}},
  \code{\link{DataBackendMatrix}},
  \code{\link{as_data_backend}}
}
\concept{DataBackend}
\keyword{datasets}
