% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkFunctions.R
\name{get2ComptModelCurve}
\alias{get2ComptModelCurve}
\title{provides solution of two compartmental pharmacodynamic model at specified time points}
\usage{
get2ComptModelCurve(parameters, time, dosingInfo,
  internalODEs = pkOdeModel2Compartments, returnAll = FALSE)
}
\arguments{
\item{parameters}{a list with correclty named input parameters}

\item{time}{a numeric vector of times}

\item{dosingInfo}{a data.frame with 2 colunmns
\itemize{
 \item time at which a dose is administered
 \item dose the amount administred to the gut
}}

\item{internalODEs}{the model function used defaults to \code{pkOdeModel2Compartments}}

\item{returnAll}{logical indicator if \code{TRUE} the solutions of all response variables is returned as a \code{data.frame}
if \code{FALSE} only the plasma concentration is returned as a vector, defaults to \code{FALSE}}
}
\value{
\code{data.frame} or numeric vector of solutions, depending on the value of \code{returnAll}
}
\description{
provides solution of two compartmental pharmacodynamic model at specified time points
}
\examples{
  pkModel               <-  getExamplePkModel()
  parameters            <-  getParameters( pkModel )
  testParameters        <-  parameters[ , "value"] 
  names(testParameters)  <-  parameters[ , "parameter"]
  time                  <-  seq( 0 , 3 , 0.1 )
  dosingInfo            <-  data.frame( time = c( 0 , 1 , 2) , 
       dose = c( 5 , 2 , 1.5 ) )
  get2ComptModelCurve( parameters = testParameters , time , dosingInfo )
  get2ComptModelCurve( parameters = testParameters, time ,
    dosingInfo , returnAll = TRUE )  
}
