% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip_info.R
\name{manip_info}
\alias{manip_info}
\alias{add_info}
\alias{mutate_net}
\title{Modifying network data}
\usage{
add_info(.data, ...)

mutate_net(.data, ...)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{...}{Named attributes. The following are currently recognised:
"name", "year", and "doi" of the network,
"collection" or "mode" of the network
("survey", "interview","sensor","observation","archival", or "simulation"),
"nodes" (a vector of the names of the nodes) or "vertex1"/"vertex2",
"ties" or "edge.pos"/"edge.neg" for defining the ties.}
}
\description{
These functions allow users to add and edit information about the network
itself.
This includes the name, year, and mode of collection of the network,
as well as definitions of the nodes and ties in the network.
Where available, this information is printed for tidygraph-class objects,
and can be used for printing a grand table in the \code{{grand}} package.
}
\examples{
add_info(ison_algebra, name = "Algebra")
}
