% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_ison.R
\docType{data}
\name{irps_usgeo}
\alias{irps_usgeo}
\title{One-mode undirected network of US state contiguity (Meghanathan 2017)}
\format{
\if{html}{\out{<div class="sourceCode">}}\preformatted{#> -- # US State Contiguity -------------------------------------------------------
#> # A labelled, undirected network of 50 states and 107 contiguity ties
#> 
#> -- Nodes
#> # A tibble: 50 x 3
#>   name  capitol     population
#>   <chr> <chr>            <int>
#> 1 AK    Juneau              NA
#> 2 AL    Montgomery     4780127
#> 3 AR    Little Rock    2915958
#> 4 AZ    Phoenix        6392307
#> 5 CA    Sacramento    37252895
#> 6 CO    Denver         5029324
#> # i 44 more rows
#> 
#> -- Ties
#> # A tibble: 107 x 2
#>    from    to
#>   <int> <int>
#> 1     2     9
#> 2     2    10
#> 3     2    25
#> 4     2    42
#> 5     3    18
#> 6     3    24
#> # i 101 more rows
#> 
}\if{html}{\out{</div>}}
}
\usage{
data(irps_usgeo)
}
\description{
This network is of contiguity between US states.
States that share a border are connected by a tie in the network.
The data is a network of 107 ties among 50 US states (nodes).
States are named by their two-letter ISO-3166 code.
This data includes also the names of the capitol cities of each state,
which are listed in the node attribute 'capitol'.
}
\references{
Meghanathan, Natarajan. 2017.
"Complex network analysis of the contiguous United States graph."
\emph{Computer and Information Science}, 10(1): 54-76.
\doi{10.5539/cis.v10n1p54}
}
\keyword{datasets}
