% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codebook.R
\name{mp_codebook}
\alias{mp_codebook}
\alias{mp_describe_code}
\alias{mp_view_codebook}
\title{Access to the Codebook for the Manifesto Project Main Dataset}
\usage{
mp_codebook(version = "current", cache = TRUE, chapter = "categories")

mp_describe_code(
  code,
  version = "current",
  columns = c("title", "description_md")
)

mp_view_codebook(version = "current", columns = c("type", "code", "title"))
}
\arguments{
\item{version}{version of the Manifesto Project Main Dataset for which the
codebook is requested. Note that only codebooks from version MPDS2017b on
are available via the API/manifestoR. Defaults to "currrent", which fetches
the most recent codebook version. Must be formatted as e.g. "MPDS2017b".}

\item{cache}{Whether result of API call should be cached locally (defaults to TRUE)}

\item{chapter}{Which part of the codebook should be returned. As of this manifestoR
release, only the content-analytical variables (parameter value "categories") are accessible via the API.}

\item{code}{specific code (as character) to display information about.}

\item{columns}{Information to display about each variable. Given as a vector of
selected column names from: "type", "domain_code", "domain_name", "code", "variable_name",
"title", "description_md", "label"}
}
\description{
These functions provide access to machine- and human-readable versions
of the Codebook (variable descriptions) of the Manifesto Project
Main Dataset, as can be found in PDF form under https://manifesto-project.wzb.eu/datasets .
As of this manifestoR release only the content-analytical variables (categories)
are accessible. Note also that the codebook contains only condensed descriptions
of the categories. For detailed information on coding instructions, you can refer
to the different handbook versions under https://manifesto-project.wzb.eu/information/documents/handbooks .
Only codebooks from version MPDS2017b on are accessible via the API.

\code{mp_codebook} returns the codebook as a \code{data_frame}, ideal for further automatic processing.
}
