% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fliteMethods.R
\name{fliteMethods}
\alias{fliteMethods}
\alias{plot.flite}
\alias{coef.flite}
\alias{vcov.flite}
\alias{nobs.flite}
\alias{logLik.flite}
\alias{summary.flite}
\alias{print.summary.flite}
\title{Methods for objects of class \code{"flite"}}
\usage{
\method{plot}{flite}(
  x,
  which = c("all", "pu", "gp", "xi", "theta"),
  adj_type = c("vertical", "none", "cholesky", "spectral"),
  ...
)

\method{coef}{flite}(object, ...)

\method{vcov}{flite}(object, adjust = TRUE, ...)

\method{nobs}{flite}(object, ...)

\method{logLik}{flite}(object, ...)

\method{summary}{flite}(object, adjust = TRUE, digits = max(3, getOption("digits") - 3L), ...)

\method{print}{summary.flite}(x, ...)
}
\arguments{
\item{x}{An object inheriting from class \code{"flite"}, a result of a
call to \code{\link{flite}}.}

\item{which}{A character scalar indicating which plot(s) to produce.
If \code{which = "all"} then all 4 plots described in \strong{Details}
are produced.  Otherwise, only one of these plots is produced, with the
possible names of the arguments being in the order that the plots are
described in \strong{Details}.}

\item{adj_type}{A character scalar passed to
\code{\link[chandwich]{conf_intervals}} and
\code{\link[chandwich]{conf_region}} as the argument \code{type} to select
the type of adjustment applied to the independence log-likelihood.  Of the
3 adjustments, \code{"vertical"} is preferred because it preserves
constraints on the parameters, whereas the \code{"cholesky"} and
\code{"spectral"} adjustment do not.  In the generalised Pareto case the
constraint that \eqn{\xi > - \sigma_u / x_{(n)}}{\xi > \sigma_u / x_(n)},
where \eqn{x_{(n)}}{x_(n)} is the largest excesses of the threshold \eqn{u},
is preserved.}

\item{...}{For \code{plot.flite}: arguments passed to
  \code{\link[graphics:plot.default]{plot}}, such as graphical parameters.

  For \code{print.summary.flite}: additional arguments passed to
  \code{\link{print.default}}.}

\item{object}{An object inheriting from class \code{"flite"}, a result of a
call to \code{\link{flite}}.}

\item{adjust}{A logical scalar.  If \code{adjust = TRUE} then the elements
of the variance-covariance matrix corresponding to
\eqn{(p_u, \sigma_u, \xi)} are estimated using a sandwich estimator.
See \code{\link{flite}}.  Otherwise, this matrix is the inverse of the
observed information matrix.}

\item{digits}{An integer. Passed to \code{\link[base:Round]{signif}} to
round the values in the summary.}
}
\value{
\code{plot.flite}: No return value, only the plot is produced.

  \code{coef.flite}: a numeric vector of length 4 with names
    \code{c("p[u]", "sigma[u]", "xi", "theta")}.  The MLEs of the parameters
    \eqn{p_u}, \eqn{\sigma_u}, \eqn{\xi} and \eqn{\theta}.

  \code{vcov.flite}: a \eqn{4 \times 4}{4 x 4} matrix with row and
    column names \code{c("p[u]", "sigma[u]", "xi", "theta")}.  The estimated
    variance-covariance matrix for the model parameters.  If
    \code{adjust = TRUE} then the elements corresponding to \eqn{p_u},
    \eqn{\sigma_u} and \eqn{\xi} are adjusted for cluster dependence using
    a sandwich estimator; otherwise they are not adjusted.

  \code{nobs.flite}: a numeric vector of length 3 with names
    \code{c("p[u]", "gp", "theta")}.  The respective number of observations
    used to estimate \eqn{p_u}, (\eqn{\sigma_u}, \eqn{\xi}) and
    \eqn{\theta}.

  \code{logLik.flite}: an object of class \code{"logLik"}: a numeric scalar
    with value equal to the maximised log-likelihood.  This is the sum of
    contributions from three fitted models, from a Bernoulli model for
    occurrences of threshold exceedances, a generalised Pareto model for
    threshold excesses and a \eqn{K}-gaps model for the extremal index.
    The returned object also has attributes \code{nobs}, the numbers of
    observations used in each of these model fits, and \code{"df"} (degrees
    of freedom), which is equal to the number of total number of parameters
    estimated (4).

  \code{summary.flite}: an object containing the original function call and
    a matrix of estimates and estimated standard errors with row names
    \code{c("p[u]", "sigma[u]", "xi", "theta")}.  The object is printed by
    \code{\link{print.summary.flite}}.

  \code{print.summary.flite}: the argument \code{x} is returned, invisibly.
}
\description{
Methods for objects of class \code{"flite"} returned from
\code{\link{flite}}.
}
\details{
For \code{plot.flite}, if \code{which = "all"} then 4 plots are produced.
    \itemize{
      \item{Top left: (adjusted) log-likelihood for the threshold exceedence
        probability \eqn{p_u}, with a horizontal line indicating a
        95\% confidence interval for \eqn{p_u}.}
      \item{Top right: contour plot of the (adjusted) log-likelihood for the
        GP parameters \eqn{(\sigma_u, \xi)}, showing
        (25, 50, 75, 90, 95)\% confidence regions. The linear constraint
        \eqn{\xi > - \sigma_u / x_{(n)}}{\xi > \sigma_u / x_(n)} is drawn
        on the plot.}
      \item{Bottom left: (adjusted) log-likelihood for \eqn{\xi}, with a
        horizontal line indicating a 95\% confidence interval for \eqn{\xi}.}
      \item{Bottom right: log-likelihood for the extremal index \eqn{\theta},
        with a horizontal line indicating a 95\% confidence interval for
        \eqn{\theta}.}
    }
}
\seealso{
\code{\link{flite}} to perform frequentist threshold-based
  inference for time series extremes.
}
