% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_lavaan.R
\name{plot_lavaan}
\alias{plot_lavaan}
\title{Create Interactive Path Diagrams for Lavaan Models}
\usage{
plot_lavaan(fit, where = "gadget")
}
\arguments{
\item{fit}{A lavaan model, as returned by the functions \code{lavaan}, \code{sem}, or \code{cfa} from the \code{lavaan} package.}

\item{where}{A character string to specify where the path diagram should be shown.
The default value "gadget" shows it directly in Rstudio. For "browser", it's shown in your default browser.
For non-RStudio users, the parameter has no effect, and the path diagram is always shown in the browser.}
}
\value{
nothing
}
\description{
The \code{plot_lavaan} function creates path diagrams for lavaan model.
The created paths diagrams  are interactive.
That is, their appearance can be customized easily, for example, by dragging
around nodes representing variable with the mouse.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(lavaan)
model <- ' 
  visual  =~ x1 + loadingx2*x2 + x3
  textual =~ x4 + x5 + x6
  speed   =~ x7 + x8 + x9
'
fit <- cfa(model, data = HolzingerSwineford1939)
plot_lavaan(fit)


\dontshow{\}) # examplesIf}
}
