% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lavaangui.R
\name{lavaangui}
\alias{lavaangui}
\title{Start lavaangui Shiny Application}
\usage{
lavaangui(fit = NULL)
}
\arguments{
\item{fit}{A lavaan model, as returned by the \code{lavaan}, \code{sem}, or \code{cfa} functions from the \code{lavaan} package.
If provided, lavaangui imports the model and data. If left empty, lavaangui starts without importing.}
}
\value{
nothing
}
\description{
The \code{lavaangui} function launches the lavaangui Shiny application.
}
\details{
Currently, multiple-group models are not supported. However, you can create an
interactive plot of those models using \code{\link{plot_lavaan}}
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Without importing lavaan model
lavaangui()

# Importing a lavaan model
library(lavaan)
model <- "
  visual  =~ x1 + loadingx2*x2 + x3
  textual =~ x4 + x5 + x6
  speed   =~ x7 + x8 + x9
"
fit <- cfa(model, data = HolzingerSwineford1939)
lavaangui(fit)
\dontshow{\}) # examplesIf}
}
